/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseSLAWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLATaskResult;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import com.liferay.portal.workflow.metrics.sla.processor.WorkfowMetricsSLAStatus;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class, SLATaskResultWorkflowMetricsIndexer.class})
public class SLATaskResultWorkflowMetricsIndexer
extends BaseSLAWorkflowMetricsIndexer {
    @Reference(target="(workflow.metrics.index.entity.name=sla-task-result)")
    private WorkflowMetricsIndexNameBuilder _slaTaskResultWorkflowMetricsIndexNameBuilder;

    public void addDocuments(List<WorkflowMetricsSLATaskResult> workflowMetricsSLATaskResults) {
        if (this.searchEngineAdapter == null) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        workflowMetricsSLATaskResults.forEach(workflowMetricsSLATaskResult -> {
            Document document = this.createDocument((WorkflowMetricsSLATaskResult)workflowMetricsSLATaskResult);
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), document.getUID(), document){
                {
                    this.setType(SLATaskResultWorkflowMetricsIndexer.this.getIndexType());
                }
            });
        });
        if (ListUtil.isNotEmpty((List)bulkDocumentRequest.getBulkableDocumentRequests())) {
            this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        }
    }

    public Document createDocument(WorkflowMetricsSLATaskResult workflowMetricsSLATaskResult) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsSLATaskResult", this.digest(Long.valueOf(workflowMetricsSLATaskResult.getCompanyId()), Long.valueOf(workflowMetricsSLATaskResult.getInstanceId()), Long.valueOf(workflowMetricsSLATaskResult.getProcessId()), Long.valueOf(workflowMetricsSLATaskResult.getSLADefinitionId()), Long.valueOf(workflowMetricsSLATaskResult.getTaskId()), Long.valueOf(workflowMetricsSLATaskResult.getTokenId())));
        document.addKeyword("companyId", workflowMetricsSLATaskResult.getCompanyId());
        document.addKeyword("breached", workflowMetricsSLATaskResult.isBreached());
        document.addKeyword("deleted", false);
        document.addKeyword("instanceId", workflowMetricsSLATaskResult.getInstanceId());
        document.addDateSortable("lastCheckDate", (Date)Timestamp.valueOf(workflowMetricsSLATaskResult.getLastCheckLocalDateTime()));
        document.addKeyword("onTime", workflowMetricsSLATaskResult.isOnTime());
        document.addKeyword("processId", workflowMetricsSLATaskResult.getProcessId());
        document.addKeyword("slaDefinitionId", workflowMetricsSLATaskResult.getSLADefinitionId());
        WorkfowMetricsSLAStatus workfowMetricsSLAStatus = workflowMetricsSLATaskResult.getWorkfowMetricsSLAStatus();
        document.addKeyword("status", workfowMetricsSLAStatus.name());
        document.addKeyword("taskId", workflowMetricsSLATaskResult.getTaskId());
        document.addKeyword("taskName", workflowMetricsSLATaskResult.getTaskName());
        document.addKeyword("tokenId", workflowMetricsSLATaskResult.getTokenId());
        return document;
    }

    @Override
    public void reindex(long companyId) {
    }

    @Override
    protected String getIndexName(long companyId) {
        return this._slaTaskResultWorkflowMetricsIndexNameBuilder.getIndexName(companyId);
    }

    @Override
    protected String getIndexType() {
        return "WorkflowMetricsSLATaskResultType";
    }
}

