/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermsQuery;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoNodeModel;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseSLAWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAProcessResult;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAProcessor;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionModel;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersionModel;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionLocalService;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionVersionLocalService;
import com.liferay.portal.workflow.metrics.sla.processor.WorkfowMetricsSLAStatus;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={Indexer.class, SLAProcessResultWorkflowMetricsIndexer.class})
public class SLAProcessResultWorkflowMetricsIndexer
extends BaseSLAWorkflowMetricsIndexer {
    @Reference
    protected KaleoNodeLocalService kaleoNodeLocalService;
    @Reference
    protected SLATaskResultWorkflowMetricsIndexer slaTaskResultWorkflowMetricsIndexer;
    @Reference
    protected Sorts sorts;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile WorkflowMetricsSLADefinitionLocalService workflowMetricsSLADefinitionLocalService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile WorkflowMetricsSLADefinitionVersionLocalService workflowMetricsSLADefinitionVersionLocalService;
    @Reference
    protected WorkflowMetricsSLAProcessor workflowMetricsSLAProcessor;
    private static final Log _log = LogFactoryUtil.getLog(SLAProcessResultWorkflowMetricsIndexer.class);
    private final DateTimeFormatter _dateTimeFormatter = DateTimeFormatter.ofPattern(PropsUtil.get((String)"index.date.format.pattern"));
    @Reference(target="(workflow.metrics.index.entity.name=instance)")
    private WorkflowMetricsIndexNameBuilder _instanceWorkflowMetricsIndexNameBuilder;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference(target="(workflow.metrics.index.entity.name=sla-process-result)")
    private WorkflowMetricsIndexNameBuilder _slaProcessResultWorkflowMetricsIndexNameBuilder;

    public Document createDocument(WorkflowMetricsSLAProcessResult workflowMetricsSLAProcessResult) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsSLAProcessResult", this.digest(Long.valueOf(workflowMetricsSLAProcessResult.getCompanyId()), Long.valueOf(workflowMetricsSLAProcessResult.getInstanceId()), Long.valueOf(workflowMetricsSLAProcessResult.getProcessId()), Long.valueOf(workflowMetricsSLAProcessResult.getSLADefinitionId())));
        document.addKeyword("companyId", workflowMetricsSLAProcessResult.getCompanyId());
        document.addKeyword("deleted", false);
        document.addKeyword("elapsedTime", workflowMetricsSLAProcessResult.getElapsedTime());
        KaleoInstance kaleoInstance = this._kaleoInstanceLocalService.fetchKaleoInstance(workflowMetricsSLAProcessResult.getInstanceId());
        if (kaleoInstance != null) {
            document.addKeyword("instanceCompleted", kaleoInstance.isCompleted());
        }
        document.addKeyword("instanceId", workflowMetricsSLAProcessResult.getInstanceId());
        document.addDateSortable("lastCheckDate", (Date)Timestamp.valueOf(workflowMetricsSLAProcessResult.getLastCheckLocalDateTime()));
        document.addKeyword("onTime", workflowMetricsSLAProcessResult.isOnTime());
        document.addDateSortable("overdueDate", (Date)Timestamp.valueOf(workflowMetricsSLAProcessResult.getOverdueLocalDateTime()));
        document.addKeyword("processId", workflowMetricsSLAProcessResult.getProcessId());
        document.addKeyword("remainingTime", workflowMetricsSLAProcessResult.getRemainingTime());
        document.addKeyword("slaDefinitionId", workflowMetricsSLAProcessResult.getSLADefinitionId());
        WorkfowMetricsSLAStatus workfowMetricsSLAStatus = workflowMetricsSLAProcessResult.getWorkfowMetricsSLAStatus();
        document.addKeyword("status", workfowMetricsSLAStatus.name());
        return document;
    }

    @Override
    protected String getIndexName(long companyId) {
        return this._slaProcessResultWorkflowMetricsIndexNameBuilder.getIndexName(companyId);
    }

    @Override
    protected String getIndexType() {
        return "WorkflowMetricsSLAProcessResultType";
    }

    @Override
    protected void reindex(long companyId) throws PortalException {
        if (this.workflowMetricsSLADefinitionLocalService == null) {
            return;
        }
        List workflowMetricsSLADefinitions = this.workflowMetricsSLADefinitionLocalService.getWorkflowMetricsSLADefinitions(companyId, 0);
        if (workflowMetricsSLADefinitions.isEmpty()) {
            return;
        }
        long lastInstanceId = 0L;
        long searchHitsTotal = 0L;
        int searchRequestSize = 50;
        SearchSearchResponse searchSearchResponse = null;
        Stream stream = workflowMetricsSLADefinitions.stream();
        Set<Long> processIds = stream.map(WorkflowMetricsSLADefinitionModel::getProcessId).collect(Collectors.toSet());
        do {
            searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)this._createInstanceSearchSearchRequest(companyId, lastInstanceId, processIds, searchRequestSize));
            this._reindexSLAProcessResults(companyId, searchSearchResponse);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            searchHitsTotal = searchHits.getTotalHits();
            if (searchHitsTotal == 0L) break;
            List searchHitsList = searchHits.getSearchHits();
            SearchHit searchHit = (SearchHit)searchHitsList.get(searchHitsList.size() - 1);
            com.liferay.portal.search.document.Document document = searchHit.getDocument();
            lastInstanceId = document.getLong("instanceId");
        } while (searchHitsTotal == (long)searchRequestSize);
    }

    private BooleanQuery _createInstancesBooleanQuery(long companyId, long lastInstanceId, Set<Long> processIds) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        return booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)companyId), this.queries.term("completed", (Object)true), this.queries.term("deleted", (Object)false), this.queries.rangeTerm("instanceId", false, true, (Object)lastInstanceId, null), this._createProcessIdTermsQuery(processIds)});
    }

    private SearchSearchRequest _createInstanceSearchSearchRequest(long companyId, long lastInstanceId, Set<Long> processIds, int searchRequestSize) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._instanceWorkflowMetricsIndexNameBuilder.getIndexName(companyId)});
        searchSearchRequest.setQuery((Query)this._createInstancesBooleanQuery(companyId, lastInstanceId, processIds));
        searchSearchRequest.setSize(Integer.valueOf(searchRequestSize));
        searchSearchRequest.setSorts(Collections.singleton(this.sorts.field("instanceId", SortOrder.ASC)));
        return searchSearchRequest;
    }

    private TermsQuery _createProcessIdTermsQuery(Set<Long> processIds) {
        TermsQuery termsQuery = this.queries.terms("processId");
        Stream stream = processIds.stream();
        termsQuery.addValues((Object[])stream.map(String::valueOf).toArray(Object[]::new));
        return termsQuery;
    }

    private long _getStartNodeId(long processId, String version) {
        try {
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.getKaleoDefinition(processId);
            KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(kaleoDefinition.getCompanyId(), kaleoDefinition.getName(), version);
            List kaleoNodes = this.kaleoNodeLocalService.getKaleoDefinitionVersionKaleoNodes(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
            Stream stream = kaleoNodes.stream();
            return stream.filter(KaleoNodeModel::isInitial).findFirst().map(KaleoNodeModel::getKaleoNodeId).orElseGet(() -> 0L);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return 0L;
        }
    }

    private void _reindexSLAProcessResults(long companyId, SearchSearchResponse searchSearchResponse) {
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        Stream.of(searchSearchResponse.getSearchHits()).map(SearchHits::getSearchHits).flatMap(Collection::stream).map(SearchHit::getDocument).forEach(document -> {
            LocalDateTime completionDate = LocalDateTime.parse(document.getString("completionDate"), this._dateTimeFormatter);
            List workflowMetricsSLADefinitionVersions = this.workflowMetricsSLADefinitionVersionLocalService.getWorkflowMetricsSLADefinitionVersions(companyId, (Date)Timestamp.valueOf(completionDate.withNano(LocalDateTime.MAX.getNano())), 0);
            Stream stream = workflowMetricsSLADefinitionVersions.stream();
            stream.filter(WorkflowMetricsSLADefinitionVersionModel::isActive).forEach(workflowMetricsSLADefinitionVersion -> {
                Optional<WorkflowMetricsSLAProcessResult> optional = this.workflowMetricsSLAProcessor.process(workflowMetricsSLADefinitionVersion.getCompanyId(), LocalDateTime.parse(document.getString("createDate"), this._dateTimeFormatter), document.getLong("instanceId"), LocalDateTime.now(), this._getStartNodeId(document.getLong("processId"), document.getString("version")), (WorkflowMetricsSLADefinitionVersion)workflowMetricsSLADefinitionVersion);
                optional.ifPresent(workflowMetricsSLAProcessResult -> {
                    workflowMetricsSLAProcessResult.setWorkfowMetricsSLAStatus(WorkfowMetricsSLAStatus.COMPLETED);
                    bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this.getIndexName(companyId), this.createDocument((WorkflowMetricsSLAProcessResult)workflowMetricsSLAProcessResult)){
                        {
                            this.setType(SLAProcessResultWorkflowMetricsIndexer.this.getIndexType());
                        }
                    });
                    this.slaTaskResultWorkflowMetricsIndexer.addDocuments(workflowMetricsSLAProcessResult.getWorkflowMetricsSLATaskResults());
                });
            });
        });
        if (ListUtil.isNotEmpty((List)bulkDocumentRequest.getBulkableDocumentRequests())) {
            this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        }
    }
}

