/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.InstanceWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAProcessResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class, ProcessWorkflowMetricsIndexer.class})
public class ProcessWorkflowMetricsIndexer
extends BaseWorkflowMetricsIndexer {
    @Reference
    private InstanceWorkflowMetricsIndexer _instanceWorkflowMetricsIndexer;
    @Reference(target="(workflow.metrics.index.entity.name=process)")
    private WorkflowMetricsIndexNameBuilder _processWorkflowMetricsIndexNameBuilder;
    @Reference
    private SLAProcessResultWorkflowMetricsIndexer _slaProcessResultWorkflowMetricsIndexer;

    @Override
    public void addDocument(Document document) {
        if (this.searchEngineAdapter == null) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this._instanceWorkflowMetricsIndexer.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), this._createWorkflowMetricsInstanceDocument(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("processId")))){
            {
                this.setType(ProcessWorkflowMetricsIndexer.this._instanceWorkflowMetricsIndexer.getIndexType());
            }
        });
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this._slaProcessResultWorkflowMetricsIndexer.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), this._creatWorkflowMetricsSLAProcessResultDocument(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("processId")))){
            {
                this.setType(ProcessWorkflowMetricsIndexer.this._slaProcessResultWorkflowMetricsIndexer.getIndexType());
            }
        });
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), document){
            {
                this.setType(ProcessWorkflowMetricsIndexer.this.getIndexType());
            }
        });
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    public Document createDocument(KaleoDefinition kaleoDefinition) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsProcess", this.digest(Long.valueOf(kaleoDefinition.getCompanyId()), Long.valueOf(kaleoDefinition.getKaleoDefinitionId())));
        document.addKeyword("active", kaleoDefinition.isActive());
        document.addKeyword("companyId", kaleoDefinition.getCompanyId());
        document.addDateSortable("createDate", kaleoDefinition.getCreateDate());
        document.addKeyword("deleted", false);
        document.addText("description", kaleoDefinition.getDescription());
        document.addDateSortable("modifiedDate", kaleoDefinition.getModifiedDate());
        document.addKeyword("name", kaleoDefinition.getName());
        document.addKeyword("processId", kaleoDefinition.getKaleoDefinitionId());
        document.addLocalizedKeyword("title", LocalizationUtil.populateLocalizationMap((Map)kaleoDefinition.getTitleMap(), (String)kaleoDefinition.getDefaultLanguageId(), (long)kaleoDefinition.getGroupId()), false, true);
        document.addKeyword("userId", kaleoDefinition.getUserId());
        document.addKeyword("version", StringBundler.concat((Object[])new Object[]{kaleoDefinition.getVersion(), Character.valueOf('.'), 0}));
        return document;
    }

    @Override
    protected String getIndexName(long companyId) {
        return this._processWorkflowMetricsIndexNameBuilder.getIndexName(companyId);
    }

    @Override
    protected String getIndexType() {
        return "WorkflowMetricsProcessType";
    }

    @Override
    protected void reindex(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.kaleoDefinitionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        actionableDynamicQuery.setPerformActionMethod(kaleoDefinition -> this.workflowMetricsPortalExecutor.execute(() -> this.addDocument(this.createDocument((KaleoDefinition)kaleoDefinition))));
        actionableDynamicQuery.performActions();
    }

    private Document _createWorkflowMetricsInstanceDocument(long companyId, long kaleoDefinitionId) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsInstance", this.digest(Long.valueOf(companyId), Long.valueOf(kaleoDefinitionId), Integer.valueOf(0)));
        document.addKeyword("companyId", companyId);
        document.addKeyword("completed", false);
        document.addKeyword("deleted", false);
        document.addKeyword("instanceId", 0);
        document.addKeyword("processId", kaleoDefinitionId);
        return document;
    }

    private Document _creatWorkflowMetricsSLAProcessResultDocument(long companyId, long kaleoDefinitionId) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsSLAProcessResult", this.digest(Long.valueOf(companyId), Integer.valueOf(0), Long.valueOf(kaleoDefinitionId), Integer.valueOf(0)));
        document.addKeyword("companyId", companyId);
        document.addKeyword("deleted", false);
        document.addKeyword("instanceCompleted", false);
        document.addKeyword("instanceId", 0);
        document.addKeyword("processId", kaleoDefinitionId);
        document.addKeyword("slaDefinitionId", 0);
        return document;
    }
}

