/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.TokenWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import java.util.Date;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class, NodeWorkflowMetricsIndexer.class})
public class NodeWorkflowMetricsIndexer
extends BaseWorkflowMetricsIndexer {
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference(target="(workflow.metrics.index.entity.name=node)")
    private WorkflowMetricsIndexNameBuilder _nodeWorkflowMetricsIndexNameBuilder;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;
    @Reference
    private TokenWorkflowMetricsIndexer _tokenWorkflowMetricsIndexer;

    @Override
    public void addDocument(Document document) {
        if (this.searchEngineAdapter == null) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (Objects.equals(GetterUtil.getString((String)document.get("type")), NodeType.TASK.name())) {
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this._slaTaskResultWorkflowMetricsIndexer.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), this._creatWorkflowMetricsSLATaskResultDocument(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("processId")), GetterUtil.getLong((String)document.get("nodeId")), GetterUtil.getString((String)document.get("name")))){
                {
                    this.setType(NodeWorkflowMetricsIndexer.this._slaTaskResultWorkflowMetricsIndexer.getIndexType());
                }
            });
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this._tokenWorkflowMetricsIndexer.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), this._createWorkflowMetricsTokenDocument(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("processId")), GetterUtil.getLong((String)document.get("nodeId")), GetterUtil.getString((String)document.get("name")), GetterUtil.getString((String)document.get("version")))){
                {
                    this.setType(NodeWorkflowMetricsIndexer.this._tokenWorkflowMetricsIndexer.getIndexType());
                }
            });
        }
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), document){
            {
                this.setType(NodeWorkflowMetricsIndexer.this.getIndexType());
            }
        });
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    public Document createDocument(KaleoNode kaleoNode) {
        return this._createDocument(kaleoNode.getCompanyId(), kaleoNode.getCreateDate(), kaleoNode.isInitial(), kaleoNode.getKaleoDefinitionVersionId(), kaleoNode.getModifiedDate(), kaleoNode.getName(), kaleoNode.getKaleoNodeId(), kaleoNode.isTerminal(), kaleoNode.getType());
    }

    public Document createDocument(KaleoTask kaleoTask) {
        return this._createDocument(kaleoTask.getCompanyId(), kaleoTask.getCreateDate(), false, kaleoTask.getKaleoDefinitionVersionId(), kaleoTask.getModifiedDate(), kaleoTask.getName(), kaleoTask.getKaleoTaskId(), false, NodeType.TASK.name());
    }

    @Override
    protected String getIndexName(long companyId) {
        return this._nodeWorkflowMetricsIndexNameBuilder.getIndexName(companyId);
    }

    @Override
    protected String getIndexType() {
        return "WorkflowMetricsNodeType";
    }

    @Override
    protected void reindex(long companyId) throws PortalException {
        this._reindexIndexWithKaleoNode(companyId);
        this._reindexIndexWithKaleoTask(companyId);
    }

    private Document _createDocument(long companyId, Date createDate, boolean initial, long kaleoDefinitionVersionId, Date modifiedDate, String name, long nodeId, boolean terminal, String type) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsNode", this.digest(Long.valueOf(companyId), Long.valueOf(kaleoDefinitionVersionId), Long.valueOf(nodeId)));
        document.addKeyword("companyId", companyId);
        document.addDateSortable("createDate", createDate);
        document.addKeyword("deleted", false);
        document.addKeyword("initial", initial);
        document.addDateSortable("modifiedDate", modifiedDate);
        document.addKeyword("name", name);
        document.addKeyword("nodeId", nodeId);
        KaleoDefinition kaleoDefinition = this.getKaleoDefinition(kaleoDefinitionVersionId);
        if (kaleoDefinition != null) {
            document.addKeyword("processId", kaleoDefinition.getKaleoDefinitionId());
        }
        document.addKeyword("terminal", terminal);
        document.addKeyword("type", type);
        KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(kaleoDefinitionVersionId);
        if (kaleoDefinitionVersion != null) {
            document.addKeyword("version", kaleoDefinitionVersion.getVersion());
        }
        return document;
    }

    private Document _createWorkflowMetricsTokenDocument(long companyId, long processId, long taskId, String taskName, String version) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsToken", this.digest(Long.valueOf(companyId), Long.valueOf(processId), Integer.valueOf(0), Long.valueOf(taskId), Integer.valueOf(0)));
        document.addKeyword("companyId", companyId);
        document.addKeyword("completed", false);
        document.addKeyword("deleted", false);
        document.addKeyword("instanceId", 0);
        document.addKeyword("processId", processId);
        document.addKeyword("taskId", taskId);
        document.addKeyword("taskName", taskName);
        document.addKeyword("tokenId", 0);
        document.addKeyword("version", version);
        return document;
    }

    private Document _creatWorkflowMetricsSLATaskResultDocument(long companyId, long processId, long taskId, String taskName) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsSLATaskResult", this.digest(Long.valueOf(companyId), Integer.valueOf(0), Long.valueOf(processId), Integer.valueOf(0), Long.valueOf(taskId)));
        document.addKeyword("companyId", companyId);
        document.addKeyword("deleted", false);
        document.addKeyword("instanceCompleted", false);
        document.addKeyword("instanceId", 0);
        document.addKeyword("processId", processId);
        document.addKeyword("slaDefinitionId", 0);
        document.addKeyword("taskId", taskId);
        document.addKeyword("taskName", taskName);
        return document;
    }

    private void _reindexIndexWithKaleoNode(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoNodeLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.eq((Object)NodeType.STATE.name()));
        });
        actionableDynamicQuery.setPerformActionMethod(kaleoNode -> this.workflowMetricsPortalExecutor.execute(() -> this.addDocument(this.createDocument((KaleoNode)kaleoNode))));
        actionableDynamicQuery.performActions();
    }

    private void _reindexIndexWithKaleoTask(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoTaskLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        actionableDynamicQuery.setPerformActionMethod(kaleoTask -> this.workflowMetricsPortalExecutor.execute(() -> this.addDocument(this.createDocument((KaleoTask)kaleoTask))));
        actionableDynamicQuery.performActions();
    }
}

