/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAProcessResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class, InstanceWorkflowMetricsIndexer.class})
public class InstanceWorkflowMetricsIndexer
extends BaseWorkflowMetricsIndexer {
    private static final Log _log = LogFactoryUtil.getLog(InstanceWorkflowMetricsIndexer.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference(target="(workflow.metrics.index.entity.name=instance)")
    private WorkflowMetricsIndexNameBuilder _instanceWorkflowMetricsIndexNameBuilder;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private SLAProcessResultWorkflowMetricsIndexer _slaProcessResultWorkflowMetricsIndexer;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;

    public Document createDocument(KaleoInstance kaleoInstance) {
        DocumentImpl document = new DocumentImpl();
        document.addUID("WorkflowMetricsInstance", this.digest(Long.valueOf(kaleoInstance.getCompanyId()), Long.valueOf(kaleoInstance.getKaleoDefinitionVersionId()), Long.valueOf(kaleoInstance.getKaleoInstanceId())));
        document.addLocalizedKeyword("assetTitle", this._createAssetTitleLocalizationMap(kaleoInstance), false, true);
        document.addLocalizedKeyword("assetType", this._createAssetTypeLocalizationMap(kaleoInstance), false, true);
        document.addKeyword("className", kaleoInstance.getClassName());
        document.addKeyword("classPK", kaleoInstance.getClassPK());
        document.addKeyword("companyId", kaleoInstance.getCompanyId());
        document.addKeyword("completed", kaleoInstance.isCompleted());
        Date completionDate = kaleoInstance.getCompletionDate();
        if (kaleoInstance.isCompleted()) {
            document.addDateSortable("completionDate", completionDate);
        }
        Date createDate = kaleoInstance.getCreateDate();
        document.addDateSortable("createDate", createDate);
        document.addKeyword("deleted", false);
        if (kaleoInstance.isCompleted()) {
            Duration duration = Duration.between(createDate.toInstant(), completionDate.toInstant());
            document.addNumber("duration", duration.toMillis());
        }
        document.addKeyword("instanceId", kaleoInstance.getKaleoInstanceId());
        document.addDateSortable("modifiedDate", kaleoInstance.getModifiedDate());
        KaleoDefinition kaleoDefinition = this.getKaleoDefinition(kaleoInstance.getKaleoDefinitionVersionId());
        if (kaleoDefinition != null) {
            document.addKeyword("processId", kaleoDefinition.getKaleoDefinitionId());
        }
        document.addKeyword("userId", kaleoInstance.getUserId());
        document.addKeyword("userName", kaleoInstance.getUserName());
        document.addKeyword("version", StringBundler.concat((Object[])new Object[]{kaleoInstance.getKaleoDefinitionVersion(), Character.valueOf('.'), 0}));
        return document;
    }

    @Override
    public void deleteDocument(Document document) {
        super.deleteDocument(document);
        this._slaProcessResultWorkflowMetricsIndexer.deleteDocuments(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("instanceId")));
        this._slaTaskResultWorkflowMetricsIndexer.deleteDocuments(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("instanceId")));
    }

    @Override
    public void updateDocument(Document document) {
        super.updateDocument(document);
        if (GetterUtil.getBoolean((String)document.get("completed"))) {
            this._slaProcessResultWorkflowMetricsIndexer.expireDocuments(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("instanceId")));
            this._slaTaskResultWorkflowMetricsIndexer.expireDocuments(GetterUtil.getLong((String)document.get("companyId")), GetterUtil.getLong((String)document.get("instanceId")));
        }
    }

    @Override
    protected String getIndexName(long companyId) {
        return this._instanceWorkflowMetricsIndexNameBuilder.getIndexName(companyId);
    }

    @Override
    protected String getIndexType() {
        return "WorkflowMetricsInstanceType";
    }

    @Override
    protected void reindex(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoInstanceLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        });
        actionableDynamicQuery.setPerformActionMethod(kaleoInstance -> this.workflowMetricsPortalExecutor.execute(() -> this.addDocument(this.createDocument((KaleoInstance)kaleoInstance))));
        actionableDynamicQuery.performActions();
    }

    private Map<Locale, String> _createAssetTitleLocalizationMap(KaleoInstance kaleoInstance) {
        AssetEntry assetEntry;
        AssetRenderer<?> assetRenderer = this._getAssetRenderer(kaleoInstance.getClassName(), kaleoInstance.getClassPK());
        if (assetRenderer != null && (assetEntry = this._assetEntryLocalService.fetchEntry(assetRenderer.getClassName(), assetRenderer.getClassPK())) != null) {
            return LocalizationUtil.populateLocalizationMap((Map)assetEntry.getTitleMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId());
        }
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)kaleoInstance.getClassName());
        if (workflowHandler != null) {
            HashMap<Locale, String> localizationMap = new HashMap<Locale, String>();
            for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)kaleoInstance.getGroupId())) {
                localizationMap.put(availableLocale, workflowHandler.getTitle(kaleoInstance.getClassPK(), availableLocale));
            }
            return localizationMap;
        }
        return Collections.emptyMap();
    }

    private Map<Locale, String> _createAssetTypeLocalizationMap(KaleoInstance kaleoInstance) {
        HashMap<Locale, String> localizationMap = new HashMap<Locale, String>();
        for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)kaleoInstance.getGroupId())) {
            localizationMap.put(availableLocale, ResourceActionsUtil.getModelResource((Locale)availableLocale, (String)kaleoInstance.getClassName()));
        }
        return localizationMap;
    }

    private AssetRenderer<?> _getAssetRenderer(String className, long classPK) {
        block3: {
            AssetRendererFactory<?> assetRendererFactory = this._getAssetRendererFactory(className);
            if (assetRendererFactory != null) {
                try {
                    return assetRendererFactory.getAssetRenderer(classPK);
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)portalException, (Throwable)portalException);
                }
            }
        }
        return null;
    }

    private AssetRendererFactory<?> _getAssetRendererFactory(String className) {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
    }
}

