/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.index.CreateIndexRequest;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.metrics.internal.petra.executor.WorkflowMetricsPortalExecutor;
import java.io.Serializable;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

public abstract class BaseWorkflowMetricsIndexer
extends BaseIndexer<Object> {
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference
    protected KaleoDefinitionLocalService kaleoDefinitionLocalService;
    @Reference
    protected KaleoDefinitionVersionLocalService kaleoDefinitionVersionLocalService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(search.engine.impl=Elasticsearch)")
    protected volatile SearchEngineAdapter searchEngineAdapter;
    @Reference
    protected WorkflowMetricsPortalExecutor workflowMetricsPortalExecutor;
    private static final boolean _INDEX_ON_STARTUP = GetterUtil.getBoolean((String)PropsUtil.get((String)"index.on.startup"));

    public void addDocument(Document document) {
        if (this.searchEngineAdapter == null) {
            return;
        }
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), document);
        indexDocumentRequest.setRefresh(true);
        indexDocumentRequest.setType(this.getIndexType());
        this.searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
    }

    public void clearIndex(long companyId) throws PortalException {
        if (this.searchEngineAdapter == null || !this._hasIndex(companyId)) {
            return;
        }
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        booleanQuery.add((Query)new MatchAllQuery(), BooleanClauseOccur.MUST);
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add((Filter)new TermFilter("companyId", String.valueOf(companyId)), BooleanClauseOccur.MUST);
        booleanQuery.setPreBooleanFilter(booleanFilter);
        DeleteByQueryDocumentRequest deleteByQueryDocumentRequest = new DeleteByQueryDocumentRequest((Query)booleanQuery, new String[]{this.getIndexName(companyId)});
        if (PortalRunMode.isTestMode()) {
            deleteByQueryDocumentRequest.setRefresh(true);
        }
        this.searchEngineAdapter.execute((DocumentRequest)deleteByQueryDocumentRequest);
    }

    public void createIndex(long companyId) throws PortalException {
        if (this.searchEngineAdapter == null || this._hasIndex(companyId)) {
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(this.getIndexName(companyId));
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read(((Object)((Object)this)).getClass(), (String)"/META-INF/search/mappings.json"));
        createIndexRequest.setSource(JSONUtil.put((String)"mappings", (Object)JSONUtil.put((String)this.getIndexType(), (Object)jsonObject.get(this.getIndexType()))).put("settings", JSONFactoryUtil.createJSONObject((String)StringUtil.read(((Object)((Object)this)).getClass(), (String)"/META-INF/search/settings.json"))).toString());
        this.searchEngineAdapter.execute((IndexRequest)createIndexRequest);
        if (!_INDEX_ON_STARTUP) {
            this.reindex(companyId);
        }
    }

    public void deleteDocument(Document document) {
        document.addKeyword("deleted", true);
        this._updateDocument(document);
    }

    public String getClassName() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getName();
    }

    public void removeIndex(long companyId) throws PortalException {
        if (this.searchEngineAdapter == null || !this._hasIndex(companyId)) {
            return;
        }
        this.searchEngineAdapter.execute((IndexRequest)new DeleteIndexRequest(new String[]{this.getIndexName(companyId)}));
    }

    public void updateDocument(Document document) {
        this._updateDocument(document);
    }

    @Activate
    protected void activate() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this.companyLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(company -> this.createIndex(company.getCompanyId()));
        actionableDynamicQuery.performActions();
    }

    protected String digest(Serializable ... parts) {
        StringBuilder sb = new StringBuilder();
        for (Serializable part : parts) {
            sb.append(part);
        }
        return DigestUtils.sha256Hex((String)sb.toString());
    }

    protected final void doDelete(Object t) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected final Document doGetDocument(Object object) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected final Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected final void doReindex(Object object) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected final void doReindex(String className, long classPK) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doReindex(String[] ids) throws Exception {
        this.clearIndex(GetterUtil.getLong((String)ids[0]));
        this.createIndex(GetterUtil.getLong((String)ids[0]));
        this.reindex(GetterUtil.getLong((String)ids[0]));
    }

    protected abstract String getIndexName(long var1);

    protected abstract String getIndexType();

    protected KaleoDefinition getKaleoDefinition(long kaleoDefinitionVersionId) {
        KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(kaleoDefinitionVersionId);
        if (kaleoDefinitionVersion != null) {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(kaleoDefinitionVersion.getCompanyId());
            return this.kaleoDefinitionLocalService.fetchKaleoDefinition(kaleoDefinitionVersion.getName(), serviceContext);
        }
        return null;
    }

    protected KaleoDefinitionVersion getKaleoDefinitionVersion(long kaleoDefinitionVersionId) {
        return this.kaleoDefinitionVersionLocalService.fetchKaleoDefinitionVersion(kaleoDefinitionVersionId);
    }

    protected abstract void reindex(long var1) throws PortalException;

    @Reference(target="(module.service.lifecycle=portlets.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private boolean _hasIndex(long companyId) {
        if (this.searchEngineAdapter == null) {
            return false;
        }
        IndicesExistsIndexRequest indicesExistsIndexRequest = new IndicesExistsIndexRequest(new String[]{this.getIndexName(companyId)});
        IndicesExistsIndexResponse indicesExistsIndexResponse = (IndicesExistsIndexResponse)this.searchEngineAdapter.execute((IndexRequest)indicesExistsIndexRequest);
        return indicesExistsIndexResponse.isExists();
    }

    private void _updateDocument(Document document) {
        if (this.searchEngineAdapter == null) {
            return;
        }
        UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(this.getIndexName(GetterUtil.getLong((String)document.get("companyId"))), document.getUID(), document);
        updateDocumentRequest.setType(this.getIndexType());
        this.searchEngineAdapter.execute((DocumentRequest)updateDocumentRequest);
    }
}

