/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.sla.processor.WorkfowMetricsSLAStatus;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSLAWorkflowMetricsIndexer
extends BaseWorkflowMetricsIndexer {
    @Reference
    protected Queries queries;

    public void deleteDocuments(long companyId, long instanceId) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        this._deleteDocuments(companyId, booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)companyId), this.queries.term("instanceId", (Object)instanceId)}));
    }

    public void deleteDocuments(long companyId, long processId, long slaDefinitionId) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        booleanQuery.addMustNotQueryClauses(new Query[]{this.queries.term("status", (Object)WorkfowMetricsSLAStatus.COMPLETED.name()), this.queries.term("status", (Object)WorkfowMetricsSLAStatus.STOPPED.name())});
        this._deleteDocuments(companyId, booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)companyId), this.queries.term("processId", (Object)processId), this.queries.term("slaDefinitionId", (Object)slaDefinitionId)}));
    }

    public void expireDocuments(long companyId, long instanceId) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        this._updateDocuments(companyId, document -> new DocumentImpl((com.liferay.portal.search.document.Document)document){
            final /* synthetic */ com.liferay.portal.search.document.Document val$document;
            {
                this.val$document = document;
                this.addKeyword("instanceCompleted", true);
                this.addKeyword("status", WorkfowMetricsSLAStatus.EXPIRED.name());
                this.addKeyword("uid", this.val$document.getString("uid"));
            }
        }, (Query)booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)companyId), this.queries.term("instanceId", (Object)instanceId)}));
    }

    private void _deleteDocuments(long companyId, BooleanQuery booleanQuery) {
        this._updateDocuments(companyId, document -> new DocumentImpl((com.liferay.portal.search.document.Document)document){
            final /* synthetic */ com.liferay.portal.search.document.Document val$document;
            {
                this.val$document = document;
                this.addKeyword("deleted", true);
                this.addKeyword("uid", this.val$document.getString("uid"));
            }
        }, (Query)booleanQuery);
    }

    private void _updateDocuments(long companyId, Function<com.liferay.portal.search.document.Document, Document> transformDocumentFunction, Query query) {
        if (this.searchEngineAdapter == null) {
            return;
        }
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this.getIndexName(companyId)});
        searchSearchRequest.setQuery(query);
        searchSearchRequest.setSelectedFieldNames(new String[]{"uid"});
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        if (searchHits.getTotalHits() == 0L) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        Stream.of(searchHits.getSearchHits()).flatMap(Collection::stream).map(SearchHit::getDocument).map(document -> new UpdateDocumentRequest(this.getIndexName(companyId), document.getString("uid"), (Document)transformDocumentFunction.apply((com.liferay.portal.search.document.Document)document)){
            {
                this.setType(BaseSLAWorkflowMetricsIndexer.this.getIndexType());
            }
        }).forEach(arg_0 -> ((BulkDocumentRequest)bulkDocumentRequest).addBulkableDocumentRequest(arg_0));
        if (ListUtil.isNotEmpty((List)bulkDocumentRequest.getBulkableDocumentRequests())) {
            this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        }
    }
}

