/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsSLAProcessBackgroundTaskExecutor;
import com.liferay.portal.workflow.metrics.internal.configuration.WorkflowMetricsConfiguration;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinition;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionLocalService;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.workflow.metrics.internal.configuration.WorkflowMetricsConfiguration"}, immediate=true, service={MessageListener.class, WorkflowMetricsSLAProcessMessageListener.class})
public class WorkflowMetricsSLAProcessMessageListener
extends BaseMessageListener {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;
    private volatile WorkflowMetricsConfiguration _workflowMetricsConfiguration;
    @Reference
    private WorkflowMetricsSLADefinitionLocalService _workflowMetricsSLADefinitionLocalService;
    @Reference(target="(background.task.executor.class.name=com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsSLAProcessBackgroundTaskExecutor)")
    private BackgroundTaskExecutor _workflowMetricsSLAProcessBackgroundTaskExecutor;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._workflowMetricsConfiguration = (WorkflowMetricsConfiguration)ConfigurableUtil.createConfigurable(WorkflowMetricsConfiguration.class, properties);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._workflowMetricsConfiguration.checkSLAJobInterval(), TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._workflowMetricsSLADefinitionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property activeProperty = PropertyFactoryUtil.forName((String)"active");
            dynamicQuery.add(activeProperty.eq((Object)true));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)0));
        });
        actionableDynamicQuery.setPerformActionMethod(workflowMetricsSLADefinition -> {
            int count = this._backgroundTaskLocalService.getBackgroundTasksCount(workflowMetricsSLADefinition.getGroupId(), this._getBackgroundTaskName((WorkflowMetricsSLADefinition)workflowMetricsSLADefinition), WorkflowMetricsSLAProcessBackgroundTaskExecutor.class.getName(), false);
            if (count > 0) {
                return;
            }
            HashMap taskContextMap = HashMapBuilder.put((Object)"deleteOnSuccess", (Object)true).put((Object)"workflowMetricsSLADefinitionId", (Object)workflowMetricsSLADefinition.getPrimaryKey()).build();
            this._backgroundTaskLocalService.addBackgroundTask(workflowMetricsSLADefinition.getUserId(), workflowMetricsSLADefinition.getGroupId(), this._getBackgroundTaskName((WorkflowMetricsSLADefinition)workflowMetricsSLADefinition), WorkflowMetricsSLAProcessBackgroundTaskExecutor.class.getName(), (Map)taskContextMap, new ServiceContext());
        });
        actionableDynamicQuery.performActions();
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private String _getBackgroundTaskName(WorkflowMetricsSLADefinition workflowMetricsSLADefinition) {
        return StringBundler.concat((Object[])new Object[]{WorkflowMetricsSLAProcessMessageListener.class.getSimpleName(), "-", workflowMetricsSLADefinition.getProcessId(), workflowMetricsSLADefinition.getPrimaryKey()});
    }
}

