/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.background.task;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.bucket.FilterAggregation;
import com.liferay.portal.search.aggregation.bucket.FilterAggregationResult;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregationResult;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAProcessResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAProcessResult;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAProcessor;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinition;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionLocalService;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionVersionLocalService;
import com.liferay.portal.workflow.metrics.sla.processor.WorkfowMetricsSLAStatus;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"background.task.executor.class.name=com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsSLAProcessBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class WorkflowMetricsSLAProcessBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    private static final String _INDEX_DATE_FORMAT_PATTERN = PropsUtil.get((String)"index.date.format.pattern");
    @Reference
    private Aggregations _aggregations;
    @Reference(target="(workflow.metrics.index.entity.name=instance)")
    private WorkflowMetricsIndexNameBuilder _instanceWorkflowMetricsIndexNameBuilder;
    @Reference(target="(workflow.metrics.index.entity.name=node)")
    private WorkflowMetricsIndexNameBuilder _nodeWorkflowMetricsIndexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(search.engine.impl=Elasticsearch)")
    private volatile SearchRequestExecutor _searchRequestExecutor;
    @Reference
    private SLAProcessResultWorkflowMetricsIndexer _slaProcessResultWorkflowMetricsIndexer;
    @Reference(target="(workflow.metrics.index.entity.name=sla-process-result)")
    private WorkflowMetricsIndexNameBuilder _slaProcessResultWorkflowMetricsIndexNameBuilder;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;
    @Reference
    private WorkflowMetricsSLADefinitionLocalService _workflowMetricsSLADefinitionLocalService;
    @Reference
    private WorkflowMetricsSLADefinitionVersionLocalService _workflowMetricsSLADefinitionVersionLocalService;
    @Reference
    private WorkflowMetricsSLAProcessor _workflowMetricsSLAProcessor;

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        if (this._searchRequestExecutor == null) {
            return new BackgroundTaskResult(5);
        }
        long workflowMetricsSLADefinitionId = MapUtil.getLong((Map)backgroundTask.getTaskContextMap(), (String)"workflowMetricsSLADefinitionId");
        WorkflowMetricsSLADefinition workflowMetricsSLADefinition = this._workflowMetricsSLADefinitionLocalService.fetchWorkflowMetricsSLADefinition(workflowMetricsSLADefinitionId);
        WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion = this._workflowMetricsSLADefinitionVersionLocalService.getWorkflowMetricsSLADefinitionVersion(workflowMetricsSLADefinitionId, workflowMetricsSLADefinition.getVersion());
        long startNodeId = this._getStartNodeId(workflowMetricsSLADefinition.getCompanyId(), workflowMetricsSLADefinition.getProcessId(), workflowMetricsSLADefinition.getProcessVersion());
        Map<Long, LocalDateTime> createLocalDateTimes = this._getCreateLocalDateTimes(workflowMetricsSLADefinition.getCompanyId(), workflowMetricsSLADefinition.getProcessId());
        Map<Long, LocalDateTime> missingCreateLocalDateTimes = this._getMissingCreateLocalDateTimes(workflowMetricsSLADefinition.getCompanyId(), workflowMetricsSLADefinition.getProcessId());
        missingCreateLocalDateTimes.putAll(createLocalDateTimes);
        this._processRunningInstances(missingCreateLocalDateTimes, startNodeId, workflowMetricsSLADefinitionVersion);
        this._processCompletedInstances(startNodeId, workflowMetricsSLADefinitionVersion);
        return BackgroundTaskResult.SUCCESS;
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return null;
    }

    @Reference(target="(module.service.lifecycle=portlets.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private BooleanQuery _createBooleanQuery(long companyId) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        BooleanQuery instancesBooleanQuery = this._queries.booleanQuery();
        instancesBooleanQuery.addFilterQueryClauses(new Query[]{this._queries.term("_index", (Object)this._instanceWorkflowMetricsIndexNameBuilder.getIndexName(companyId))});
        instancesBooleanQuery.addMustQueryClauses(new Query[]{this._queries.exists("instanceId")});
        BooleanQuery slaProcessResultsBooleanQuery = this._queries.booleanQuery();
        slaProcessResultsBooleanQuery.addFilterQueryClauses(new Query[]{this._queries.term("_index", (Object)this._slaProcessResultWorkflowMetricsIndexNameBuilder.getIndexName(companyId))});
        slaProcessResultsBooleanQuery.addMustNotQueryClauses(new Query[]{this._queries.exists("instanceId")});
        return booleanQuery.addShouldQueryClauses(new Query[]{instancesBooleanQuery, slaProcessResultsBooleanQuery});
    }

    private BooleanQuery _createBooleanQuery(long companyId, long processId) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        BooleanQuery instancesBooleanQuery = this._queries.booleanQuery();
        instancesBooleanQuery.addFilterQueryClauses(new Query[]{this._queries.term("_index", (Object)this._instanceWorkflowMetricsIndexNameBuilder.getIndexName(companyId))});
        instancesBooleanQuery.addMustQueryClauses(new Query[]{this._createInstancesBooleanQuery(true, companyId, processId)});
        BooleanQuery slaProcessResultsBooleanQuery = this._queries.booleanQuery();
        slaProcessResultsBooleanQuery.addFilterQueryClauses(new Query[]{this._queries.term("_index", (Object)this._slaProcessResultWorkflowMetricsIndexNameBuilder.getIndexName(companyId))});
        slaProcessResultsBooleanQuery.addMustNotQueryClauses(new Query[]{this._queries.term("slaDefinitionId", (Object)0)});
        slaProcessResultsBooleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("deleted", (Object)false), this._queries.term("processId", (Object)processId)});
        return booleanQuery.addShouldQueryClauses(new Query[]{instancesBooleanQuery, slaProcessResultsBooleanQuery});
    }

    private BooleanQuery _createInstancesBooleanQuery(boolean completed, long companyId, long processId) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        booleanQuery.addMustNotQueryClauses(new Query[]{this._queries.term("instanceId", (Object)"0")});
        return booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("completed", (Object)completed), this._queries.term("deleted", (Object)false), this._queries.term("processId", (Object)processId)});
    }

    private BooleanQuery _createSLAProcessResultsBooleanQuery(long companyId, long processId, long slaDefinitionId) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        booleanQuery.addMustNotQueryClauses(new Query[]{this._queries.term("slaDefinitionId", (Object)"0"), this._queries.term("status", (Object)WorkfowMetricsSLAStatus.COMPLETED.name())});
        return booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("deleted", (Object)false), this._queries.term("instanceCompleted", (Object)true), this._queries.term("processId", (Object)processId), this._queries.term("slaDefinitionId", (Object)slaDefinitionId)});
    }

    private Map<Long, LocalDateTime> _getCreateLocalDateTimes(long companyId, long processId) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._instanceWorkflowMetricsIndexNameBuilder.getIndexName(companyId)});
        searchSearchRequest.setQuery((Query)this._createInstancesBooleanQuery(false, companyId, processId));
        searchSearchRequest.setSize(Integer.valueOf(10000));
        return Stream.of(this._searchRequestExecutor.executeSearchRequest(searchSearchRequest)).map(SearchSearchResponse::getSearchHits).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getDocument).collect(Collectors.toMap(document -> document.getLong("instanceId"), document -> LocalDateTime.parse(document.getString("createDate"), DateTimeFormatter.ofPattern(_INDEX_DATE_FORMAT_PATTERN))));
    }

    private Map<Long, LocalDateTime> _getMissingCreateLocalDateTimes(long companyId, long processId) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        FilterAggregation filterAggregation = this._aggregations.filter("instanceId", (Query)this._createBooleanQuery(companyId));
        filterAggregation.addChildAggregation((Aggregation)this._aggregations.topHits("topHits"));
        searchSearchRequest.addAggregation((Aggregation)filterAggregation);
        searchSearchRequest.setIndexNames(new String[]{this._instanceWorkflowMetricsIndexNameBuilder.getIndexName(companyId), this._slaProcessResultWorkflowMetricsIndexNameBuilder.getIndexName(companyId)});
        searchSearchRequest.setQuery((Query)this._createBooleanQuery(companyId, processId));
        return Stream.of(this._searchRequestExecutor.executeSearchRequest(searchSearchRequest)).map(BaseSearchResponse::getAggregationResultsMap).map(aggregationResultsMap -> (FilterAggregationResult)aggregationResultsMap.get("instanceId")).map(filterAggregationResult -> (TopHitsAggregationResult)filterAggregationResult.getChildAggregationResult("topHits")).map(TopHitsAggregationResult::getSearchHits).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getSourcesMap).collect(Collectors.toMap(sourcesMap -> GetterUtil.getLong(sourcesMap.get("instanceId")), sourcesMap -> LocalDateTime.parse(GetterUtil.getString(sourcesMap.get("createDate")), DateTimeFormatter.ofPattern(_INDEX_DATE_FORMAT_PATTERN))));
    }

    private long _getStartNodeId(long companyId, long processId, String version) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._nodeWorkflowMetricsIndexNameBuilder.getIndexName(companyId)});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("deleted", (Object)false), this._queries.term("initial", (Object)true), this._queries.term("processId", (Object)processId), this._queries.term("version", (Object)version)}));
        return Stream.of(this._searchRequestExecutor.executeSearchRequest(searchSearchRequest)).map(SearchSearchResponse::getSearchHits).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getDocument).findFirst().map(document -> document.getLong("nodeId")).orElseGet(() -> 0L);
    }

    private void _indexWorkflowMetricsSLAProcessResult(WorkflowMetricsSLAProcessResult workflowMetricsSLAProcessResult) {
        this._slaProcessResultWorkflowMetricsIndexer.addDocument(this._slaProcessResultWorkflowMetricsIndexer.createDocument(workflowMetricsSLAProcessResult));
        this._slaTaskResultWorkflowMetricsIndexer.addDocuments(workflowMetricsSLAProcessResult.getWorkflowMetricsSLATaskResults());
    }

    private void _processCompletedInstances(long startNodeId, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._slaProcessResultWorkflowMetricsIndexNameBuilder.getIndexName(workflowMetricsSLADefinitionVersion.getCompanyId())});
        searchSearchRequest.setQuery((Query)this._createSLAProcessResultsBooleanQuery(workflowMetricsSLADefinitionVersion.getCompanyId(), workflowMetricsSLADefinitionVersion.getProcessId(), workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId()));
        searchSearchRequest.setSize(Integer.valueOf(10000));
        Stream.of(this._searchRequestExecutor.executeSearchRequest(searchSearchRequest)).map(SearchSearchResponse::getSearchHits).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getDocument).map(document -> this._workflowMetricsSLAProcessor.process(workflowMetricsSLADefinitionVersion.getCompanyId(), null, document.getLong("instanceId"), LocalDateTime.now(), startNodeId, workflowMetricsSLADefinitionVersion)).map(optional -> {
            WorkflowMetricsSLAProcessResult workflowMetricsSLAProcessResult = (WorkflowMetricsSLAProcessResult)optional.get();
            workflowMetricsSLAProcessResult.setWorkfowMetricsSLAStatus(WorkfowMetricsSLAStatus.COMPLETED);
            return workflowMetricsSLAProcessResult;
        }).forEach(this::_indexWorkflowMetricsSLAProcessResult);
    }

    private void _processRunningInstances(Map<Long, LocalDateTime> createLocalDateTimes, long startNodeId, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion) {
        Set<Map.Entry<Long, LocalDateTime>> entrySet = createLocalDateTimes.entrySet();
        Stream stream = entrySet.parallelStream();
        stream.map(entry -> this._workflowMetricsSLAProcessor.process(workflowMetricsSLADefinitionVersion.getCompanyId(), (LocalDateTime)entry.getValue(), (Long)entry.getKey(), LocalDateTime.now(), startNodeId, workflowMetricsSLADefinitionVersion)).filter(Optional::isPresent).map(Optional::get).forEach(this::_indexWorkflowMetricsSLAProcessResult);
    }
}

