/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.workflow.metrics.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersionModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the WorkflowMetricsSLADefinitionVersion service. Represents a row in the &quot;WMSLADefinitionVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>WorkflowMetricsSLADefinitionVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorkflowMetricsSLADefinitionVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WorkflowMetricsSLADefinitionVersionImpl
 * @generated
 */
public class WorkflowMetricsSLADefinitionVersionModelImpl
	extends BaseModelImpl<WorkflowMetricsSLADefinitionVersion>
	implements WorkflowMetricsSLADefinitionVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a workflow metrics sla definition version model instance should use the <code>WorkflowMetricsSLADefinitionVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "WMSLADefinitionVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"wmSLADefinitionVersionId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"active_", Types.BOOLEAN},
		{"calendarKey", Types.VARCHAR}, {"description", Types.CLOB},
		{"duration", Types.BIGINT}, {"name", Types.VARCHAR},
		{"pauseNodeKeys", Types.VARCHAR}, {"processId", Types.BIGINT},
		{"processVersion", Types.VARCHAR}, {"startNodeKeys", Types.VARCHAR},
		{"stopNodeKeys", Types.VARCHAR}, {"version", Types.VARCHAR},
		{"wmSLADefinitionId", Types.BIGINT}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("wmSLADefinitionVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("calendarKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.CLOB);
		TABLE_COLUMNS_MAP.put("duration", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("pauseNodeKeys", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("processId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("processVersion", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("startNodeKeys", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("stopNodeKeys", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("wmSLADefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table WMSLADefinitionVersion (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,wmSLADefinitionVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,active_ BOOLEAN,calendarKey VARCHAR(75) null,description TEXT null,duration LONG,name VARCHAR(75) null,pauseNodeKeys VARCHAR(75) null,processId LONG,processVersion VARCHAR(75) null,startNodeKeys VARCHAR(75) null,stopNodeKeys VARCHAR(75) null,version VARCHAR(75) null,wmSLADefinitionId LONG,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table WMSLADefinitionVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY workflowMetricsSLADefinitionVersion.modifiedDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY WMSLADefinitionVersion.modifiedDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.workflow.metrics.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.workflow.metrics.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.workflow.metrics.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long GROUPID_COLUMN_BITMASK = 2L;

	public static final long UUID_COLUMN_BITMASK = 4L;

	public static final long VERSION_COLUMN_BITMASK = 8L;

	public static final long WORKFLOWMETRICSSLADEFINITIONID_COLUMN_BITMASK =
		16L;

	public static final long MODIFIEDDATE_COLUMN_BITMASK = 32L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.workflow.metrics.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion"));

	public WorkflowMetricsSLADefinitionVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _workflowMetricsSLADefinitionVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setWorkflowMetricsSLADefinitionVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _workflowMetricsSLADefinitionVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return WorkflowMetricsSLADefinitionVersion.class;
	}

	@Override
	public String getModelClassName() {
		return WorkflowMetricsSLADefinitionVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry
				<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WorkflowMetricsSLADefinitionVersion, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(WorkflowMetricsSLADefinitionVersion)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<WorkflowMetricsSLADefinitionVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<WorkflowMetricsSLADefinitionVersion, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(WorkflowMetricsSLADefinitionVersion)this,
					entry.getValue());
			}
		}
	}

	public Map<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<WorkflowMetricsSLADefinitionVersion, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map
		<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
			_attributeGetterFunctions;

	static {
		Map<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<WorkflowMetricsSLADefinitionVersion, Object>>();

		attributeGetterFunctions.put(
			"mvccVersion", WorkflowMetricsSLADefinitionVersion::getMvccVersion);
		attributeGetterFunctions.put(
			"uuid", WorkflowMetricsSLADefinitionVersion::getUuid);
		attributeGetterFunctions.put(
			"workflowMetricsSLADefinitionVersionId",
			WorkflowMetricsSLADefinitionVersion::
				getWorkflowMetricsSLADefinitionVersionId);
		attributeGetterFunctions.put(
			"groupId", WorkflowMetricsSLADefinitionVersion::getGroupId);
		attributeGetterFunctions.put(
			"companyId", WorkflowMetricsSLADefinitionVersion::getCompanyId);
		attributeGetterFunctions.put(
			"userId", WorkflowMetricsSLADefinitionVersion::getUserId);
		attributeGetterFunctions.put(
			"userName", WorkflowMetricsSLADefinitionVersion::getUserName);
		attributeGetterFunctions.put(
			"createDate", WorkflowMetricsSLADefinitionVersion::getCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate",
			WorkflowMetricsSLADefinitionVersion::getModifiedDate);
		attributeGetterFunctions.put(
			"active", WorkflowMetricsSLADefinitionVersion::getActive);
		attributeGetterFunctions.put(
			"calendarKey", WorkflowMetricsSLADefinitionVersion::getCalendarKey);
		attributeGetterFunctions.put(
			"description", WorkflowMetricsSLADefinitionVersion::getDescription);
		attributeGetterFunctions.put(
			"duration", WorkflowMetricsSLADefinitionVersion::getDuration);
		attributeGetterFunctions.put(
			"name", WorkflowMetricsSLADefinitionVersion::getName);
		attributeGetterFunctions.put(
			"pauseNodeKeys",
			WorkflowMetricsSLADefinitionVersion::getPauseNodeKeys);
		attributeGetterFunctions.put(
			"processId", WorkflowMetricsSLADefinitionVersion::getProcessId);
		attributeGetterFunctions.put(
			"processVersion",
			WorkflowMetricsSLADefinitionVersion::getProcessVersion);
		attributeGetterFunctions.put(
			"startNodeKeys",
			WorkflowMetricsSLADefinitionVersion::getStartNodeKeys);
		attributeGetterFunctions.put(
			"stopNodeKeys",
			WorkflowMetricsSLADefinitionVersion::getStopNodeKeys);
		attributeGetterFunctions.put(
			"version", WorkflowMetricsSLADefinitionVersion::getVersion);
		attributeGetterFunctions.put(
			"workflowMetricsSLADefinitionId",
			WorkflowMetricsSLADefinitionVersion::
				getWorkflowMetricsSLADefinitionId);
		attributeGetterFunctions.put(
			"status", WorkflowMetricsSLADefinitionVersion::getStatus);
		attributeGetterFunctions.put(
			"statusByUserId",
			WorkflowMetricsSLADefinitionVersion::getStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName",
			WorkflowMetricsSLADefinitionVersion::getStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", WorkflowMetricsSLADefinitionVersion::getStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map
		<String, BiConsumer<WorkflowMetricsSLADefinitionVersion, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<WorkflowMetricsSLADefinitionVersion, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String,
					 BiConsumer<WorkflowMetricsSLADefinitionVersion, ?>>();

		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::setMvccVersion);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setUuid);
		attributeSetterBiConsumers.put(
			"workflowMetricsSLADefinitionVersionId",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::
					setWorkflowMetricsSLADefinitionVersionId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::setGroupId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::setCompanyId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::setUserId);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setUserName);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Date>)
				WorkflowMetricsSLADefinitionVersion::setCreateDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Date>)
				WorkflowMetricsSLADefinitionVersion::setModifiedDate);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Boolean>)
				WorkflowMetricsSLADefinitionVersion::setActive);
		attributeSetterBiConsumers.put(
			"calendarKey",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setCalendarKey);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setDescription);
		attributeSetterBiConsumers.put(
			"duration",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::setDuration);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setName);
		attributeSetterBiConsumers.put(
			"pauseNodeKeys",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setPauseNodeKeys);
		attributeSetterBiConsumers.put(
			"processId",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::setProcessId);
		attributeSetterBiConsumers.put(
			"processVersion",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setProcessVersion);
		attributeSetterBiConsumers.put(
			"startNodeKeys",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setStartNodeKeys);
		attributeSetterBiConsumers.put(
			"stopNodeKeys",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setStopNodeKeys);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setVersion);
		attributeSetterBiConsumers.put(
			"workflowMetricsSLADefinitionId",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::
					setWorkflowMetricsSLADefinitionId);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Integer>)
				WorkflowMetricsSLADefinitionVersion::setStatus);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Long>)
				WorkflowMetricsSLADefinitionVersion::setStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, String>)
				WorkflowMetricsSLADefinitionVersion::setStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<WorkflowMetricsSLADefinitionVersion, Date>)
				WorkflowMetricsSLADefinitionVersion::setStatusDate);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@Override
	public long getWorkflowMetricsSLADefinitionVersionId() {
		return _workflowMetricsSLADefinitionVersionId;
	}

	@Override
	public void setWorkflowMetricsSLADefinitionVersionId(
		long workflowMetricsSLADefinitionVersionId) {

		_workflowMetricsSLADefinitionVersionId =
			workflowMetricsSLADefinitionVersionId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_columnBitmask = -1L;

		_modifiedDate = modifiedDate;
	}

	@Override
	public boolean getActive() {
		return _active;
	}

	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		_active = active;
	}

	@Override
	public String getCalendarKey() {
		if (_calendarKey == null) {
			return "";
		}
		else {
			return _calendarKey;
		}
	}

	@Override
	public void setCalendarKey(String calendarKey) {
		_calendarKey = calendarKey;
	}

	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@Override
	public long getDuration() {
		return _duration;
	}

	@Override
	public void setDuration(long duration) {
		_duration = duration;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_name = name;
	}

	@Override
	public String getPauseNodeKeys() {
		if (_pauseNodeKeys == null) {
			return "";
		}
		else {
			return _pauseNodeKeys;
		}
	}

	@Override
	public void setPauseNodeKeys(String pauseNodeKeys) {
		_pauseNodeKeys = pauseNodeKeys;
	}

	@Override
	public long getProcessId() {
		return _processId;
	}

	@Override
	public void setProcessId(long processId) {
		_processId = processId;
	}

	@Override
	public String getProcessVersion() {
		if (_processVersion == null) {
			return "";
		}
		else {
			return _processVersion;
		}
	}

	@Override
	public void setProcessVersion(String processVersion) {
		_processVersion = processVersion;
	}

	@Override
	public String getStartNodeKeys() {
		if (_startNodeKeys == null) {
			return "";
		}
		else {
			return _startNodeKeys;
		}
	}

	@Override
	public void setStartNodeKeys(String startNodeKeys) {
		_startNodeKeys = startNodeKeys;
	}

	@Override
	public String getStopNodeKeys() {
		if (_stopNodeKeys == null) {
			return "";
		}
		else {
			return _stopNodeKeys;
		}
	}

	@Override
	public void setStopNodeKeys(String stopNodeKeys) {
		_stopNodeKeys = stopNodeKeys;
	}

	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		_columnBitmask |= VERSION_COLUMN_BITMASK;

		if (_originalVersion == null) {
			_originalVersion = _version;
		}

		_version = version;
	}

	public String getOriginalVersion() {
		return GetterUtil.getString(_originalVersion);
	}

	@Override
	public long getWorkflowMetricsSLADefinitionId() {
		return _workflowMetricsSLADefinitionId;
	}

	@Override
	public void setWorkflowMetricsSLADefinitionId(
		long workflowMetricsSLADefinitionId) {

		_columnBitmask |= WORKFLOWMETRICSSLADEFINITIONID_COLUMN_BITMASK;

		if (!_setOriginalWorkflowMetricsSLADefinitionId) {
			_setOriginalWorkflowMetricsSLADefinitionId = true;

			_originalWorkflowMetricsSLADefinitionId =
				_workflowMetricsSLADefinitionId;
		}

		_workflowMetricsSLADefinitionId = workflowMetricsSLADefinitionId;
	}

	public long getOriginalWorkflowMetricsSLADefinitionId() {
		return _originalWorkflowMetricsSLADefinitionId;
	}

	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_status = status;
	}

	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				WorkflowMetricsSLADefinitionVersion.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), WorkflowMetricsSLADefinitionVersion.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public WorkflowMetricsSLADefinitionVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, WorkflowMetricsSLADefinitionVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		WorkflowMetricsSLADefinitionVersionImpl
			workflowMetricsSLADefinitionVersionImpl =
				new WorkflowMetricsSLADefinitionVersionImpl();

		workflowMetricsSLADefinitionVersionImpl.setMvccVersion(
			getMvccVersion());
		workflowMetricsSLADefinitionVersionImpl.setUuid(getUuid());
		workflowMetricsSLADefinitionVersionImpl.
			setWorkflowMetricsSLADefinitionVersionId(
				getWorkflowMetricsSLADefinitionVersionId());
		workflowMetricsSLADefinitionVersionImpl.setGroupId(getGroupId());
		workflowMetricsSLADefinitionVersionImpl.setCompanyId(getCompanyId());
		workflowMetricsSLADefinitionVersionImpl.setUserId(getUserId());
		workflowMetricsSLADefinitionVersionImpl.setUserName(getUserName());
		workflowMetricsSLADefinitionVersionImpl.setCreateDate(getCreateDate());
		workflowMetricsSLADefinitionVersionImpl.setModifiedDate(
			getModifiedDate());
		workflowMetricsSLADefinitionVersionImpl.setActive(isActive());
		workflowMetricsSLADefinitionVersionImpl.setCalendarKey(
			getCalendarKey());
		workflowMetricsSLADefinitionVersionImpl.setDescription(
			getDescription());
		workflowMetricsSLADefinitionVersionImpl.setDuration(getDuration());
		workflowMetricsSLADefinitionVersionImpl.setName(getName());
		workflowMetricsSLADefinitionVersionImpl.setPauseNodeKeys(
			getPauseNodeKeys());
		workflowMetricsSLADefinitionVersionImpl.setProcessId(getProcessId());
		workflowMetricsSLADefinitionVersionImpl.setProcessVersion(
			getProcessVersion());
		workflowMetricsSLADefinitionVersionImpl.setStartNodeKeys(
			getStartNodeKeys());
		workflowMetricsSLADefinitionVersionImpl.setStopNodeKeys(
			getStopNodeKeys());
		workflowMetricsSLADefinitionVersionImpl.setVersion(getVersion());
		workflowMetricsSLADefinitionVersionImpl.
			setWorkflowMetricsSLADefinitionId(
				getWorkflowMetricsSLADefinitionId());
		workflowMetricsSLADefinitionVersionImpl.setStatus(getStatus());
		workflowMetricsSLADefinitionVersionImpl.setStatusByUserId(
			getStatusByUserId());
		workflowMetricsSLADefinitionVersionImpl.setStatusByUserName(
			getStatusByUserName());
		workflowMetricsSLADefinitionVersionImpl.setStatusDate(getStatusDate());

		workflowMetricsSLADefinitionVersionImpl.resetOriginalValues();

		return workflowMetricsSLADefinitionVersionImpl;
	}

	@Override
	public int compareTo(
		WorkflowMetricsSLADefinitionVersion
			workflowMetricsSLADefinitionVersion) {

		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(),
			workflowMetricsSLADefinitionVersion.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof WorkflowMetricsSLADefinitionVersion)) {
			return false;
		}

		WorkflowMetricsSLADefinitionVersion
			workflowMetricsSLADefinitionVersion =
				(WorkflowMetricsSLADefinitionVersion)object;

		long primaryKey = workflowMetricsSLADefinitionVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_setModifiedDate = false;

		_originalVersion = _version;

		_originalWorkflowMetricsSLADefinitionId =
			_workflowMetricsSLADefinitionId;

		_setOriginalWorkflowMetricsSLADefinitionId = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<WorkflowMetricsSLADefinitionVersion> toCacheModel() {
		WorkflowMetricsSLADefinitionVersionCacheModel
			workflowMetricsSLADefinitionVersionCacheModel =
				new WorkflowMetricsSLADefinitionVersionCacheModel();

		workflowMetricsSLADefinitionVersionCacheModel.mvccVersion =
			getMvccVersion();

		workflowMetricsSLADefinitionVersionCacheModel.uuid = getUuid();

		String uuid = workflowMetricsSLADefinitionVersionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.uuid = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.
			workflowMetricsSLADefinitionVersionId =
				getWorkflowMetricsSLADefinitionVersionId();

		workflowMetricsSLADefinitionVersionCacheModel.groupId = getGroupId();

		workflowMetricsSLADefinitionVersionCacheModel.companyId =
			getCompanyId();

		workflowMetricsSLADefinitionVersionCacheModel.userId = getUserId();

		workflowMetricsSLADefinitionVersionCacheModel.userName = getUserName();

		String userName =
			workflowMetricsSLADefinitionVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			workflowMetricsSLADefinitionVersionCacheModel.createDate =
				createDate.getTime();
		}
		else {
			workflowMetricsSLADefinitionVersionCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			workflowMetricsSLADefinitionVersionCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			workflowMetricsSLADefinitionVersionCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		workflowMetricsSLADefinitionVersionCacheModel.active = isActive();

		workflowMetricsSLADefinitionVersionCacheModel.calendarKey =
			getCalendarKey();

		String calendarKey =
			workflowMetricsSLADefinitionVersionCacheModel.calendarKey;

		if ((calendarKey != null) && (calendarKey.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.calendarKey = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.description =
			getDescription();

		String description =
			workflowMetricsSLADefinitionVersionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.description = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.duration = getDuration();

		workflowMetricsSLADefinitionVersionCacheModel.name = getName();

		String name = workflowMetricsSLADefinitionVersionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.name = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.pauseNodeKeys =
			getPauseNodeKeys();

		String pauseNodeKeys =
			workflowMetricsSLADefinitionVersionCacheModel.pauseNodeKeys;

		if ((pauseNodeKeys != null) && (pauseNodeKeys.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.pauseNodeKeys = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.processId =
			getProcessId();

		workflowMetricsSLADefinitionVersionCacheModel.processVersion =
			getProcessVersion();

		String processVersion =
			workflowMetricsSLADefinitionVersionCacheModel.processVersion;

		if ((processVersion != null) && (processVersion.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.processVersion = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.startNodeKeys =
			getStartNodeKeys();

		String startNodeKeys =
			workflowMetricsSLADefinitionVersionCacheModel.startNodeKeys;

		if ((startNodeKeys != null) && (startNodeKeys.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.startNodeKeys = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.stopNodeKeys =
			getStopNodeKeys();

		String stopNodeKeys =
			workflowMetricsSLADefinitionVersionCacheModel.stopNodeKeys;

		if ((stopNodeKeys != null) && (stopNodeKeys.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.stopNodeKeys = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.version = getVersion();

		String version = workflowMetricsSLADefinitionVersionCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.version = null;
		}

		workflowMetricsSLADefinitionVersionCacheModel.
			workflowMetricsSLADefinitionId =
				getWorkflowMetricsSLADefinitionId();

		workflowMetricsSLADefinitionVersionCacheModel.status = getStatus();

		workflowMetricsSLADefinitionVersionCacheModel.statusByUserId =
			getStatusByUserId();

		workflowMetricsSLADefinitionVersionCacheModel.statusByUserName =
			getStatusByUserName();

		String statusByUserName =
			workflowMetricsSLADefinitionVersionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			workflowMetricsSLADefinitionVersionCacheModel.statusByUserName =
				null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			workflowMetricsSLADefinitionVersionCacheModel.statusDate =
				statusDate.getTime();
		}
		else {
			workflowMetricsSLADefinitionVersionCacheModel.statusDate =
				Long.MIN_VALUE;
		}

		return workflowMetricsSLADefinitionVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry
				<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WorkflowMetricsSLADefinitionVersion, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(WorkflowMetricsSLADefinitionVersion)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry
				<String, Function<WorkflowMetricsSLADefinitionVersion, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WorkflowMetricsSLADefinitionVersion, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(WorkflowMetricsSLADefinitionVersion)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, WorkflowMetricsSLADefinitionVersion>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						WorkflowMetricsSLADefinitionVersion.class,
						ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _originalUuid;
	private long _workflowMetricsSLADefinitionVersionId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private boolean _active;
	private String _calendarKey;
	private String _description;
	private long _duration;
	private String _name;
	private String _pauseNodeKeys;
	private long _processId;
	private String _processVersion;
	private String _startNodeKeys;
	private String _stopNodeKeys;
	private String _version;
	private String _originalVersion;
	private long _workflowMetricsSLADefinitionId;
	private long _originalWorkflowMetricsSLADefinitionId;
	private boolean _setOriginalWorkflowMetricsSLADefinitionId;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private WorkflowMetricsSLADefinitionVersion _escapedModel;

}