/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.workflow.metrics.internal.search.index.name;

import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Rafael Praxedes
 */
@Component(
	immediate = true, property = "workflow.metrics.index.entity.name=instance",
	service = WorkflowMetricsIndexNameBuilder.class
)
public class InstanceWorkflowMetricsIndexNameBuilder
	implements WorkflowMetricsIndexNameBuilder {

	@Override
	public String getIndexName(long companyId) {
		return indexNameBuilder.getIndexName(companyId) +
			"-workflow-metrics-instances";
	}

	@Reference
	protected IndexNameBuilder indexNameBuilder;

}