/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.theme.builder.maven;

import com.liferay.portal.tools.theme.builder.ThemeBuilder;
import com.liferay.portal.tools.theme.builder.ThemeBuilderArgs;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class BuildThemeMojo
extends AbstractMojo {
    private PluginDescriptor _pluginDescriptor;
    private MavenProject _project;
    private RepositorySystem _repositorySystem;
    private RepositorySystemSession _repositorySystemSession;
    private final ThemeBuilderArgs _themeBuilderArgs = new ThemeBuilderArgs();

    public void execute() throws MojoExecutionException {
        boolean themeStyledArtifactPresent = false;
        boolean themeUnstyledArtifactPresent = false;
        try {
            Artifact artifact;
            String artifactId;
            for (Dependency dependency : this._project.getDependencies()) {
                artifactId = dependency.getArtifactId();
                if (artifactId.equals("com.liferay.frontend.theme.styled") && this._themeBuilderArgs.getParentDir() == null && "_styled".equals(this._themeBuilderArgs.getParentName())) {
                    artifact = this._resolveArtifact(dependency);
                    if (artifact != null) {
                        this._themeBuilderArgs.setParentDir(artifact.getFile());
                    }
                    themeStyledArtifactPresent = true;
                    continue;
                }
                if (!artifactId.equals("com.liferay.frontend.theme.unstyled") || this._themeBuilderArgs.getUnstyledDir() != null) continue;
                artifact = this._resolveArtifact(dependency);
                if (artifact != null) {
                    this._themeBuilderArgs.setUnstyledDir(artifact.getFile());
                }
                themeUnstyledArtifactPresent = true;
            }
            if (!themeStyledArtifactPresent && this._themeBuilderArgs.getParentDir() == null) {
                for (ComponentDependency componentDependency : this._pluginDescriptor.getDependencies()) {
                    artifactId = componentDependency.getArtifactId();
                    if (!artifactId.equals("com.liferay.frontend.theme.styled") || !"_styled".equals(this._themeBuilderArgs.getParentName()) || (artifact = this._resolveArtifact(componentDependency)) == null) continue;
                    this._themeBuilderArgs.setParentDir(artifact.getFile());
                    break;
                }
            }
            if (!themeUnstyledArtifactPresent && this._themeBuilderArgs.getUnstyledDir() == null) {
                for (ComponentDependency componentDependency : this._pluginDescriptor.getDependencies()) {
                    artifactId = componentDependency.getArtifactId();
                    if (!artifactId.equals("com.liferay.frontend.theme.unstyled") || (artifact = this._resolveArtifact(componentDependency)) == null) continue;
                    this._themeBuilderArgs.setUnstyledDir(artifact.getFile());
                    break;
                }
            }
            ThemeBuilder themeBuilder = new ThemeBuilder(this._themeBuilderArgs);
            themeBuilder.build();
        }
        catch (Exception exception) {
            throw new MojoExecutionException(exception.getMessage(), exception);
        }
    }

    public void setDiffsDir(File diffsDir) {
        this._themeBuilderArgs.setDiffsDir(diffsDir);
    }

    public void setName(String name) {
        this._themeBuilderArgs.setName(name);
    }

    public void setOutputDir(File outputDir) {
        this._themeBuilderArgs.setOutputDir(outputDir);
    }

    public void setParentDir(File parentDir) {
        this._themeBuilderArgs.setParentDir(parentDir);
    }

    public void setParentName(String parentName) {
        this._themeBuilderArgs.setParentName(parentName);
    }

    public void setTemplateExtension(String templateExtension) {
        this._themeBuilderArgs.setTemplateExtension(templateExtension);
    }

    public void setThumbnailHeight(int thumbnailHeight) {
        this._themeBuilderArgs.setThumbnailHeight(thumbnailHeight);
    }

    public void setThumbnailWidth(int thumbnailWidth) {
        this._themeBuilderArgs.setThumbnailWidth(thumbnailWidth);
    }

    public void setUnstyledDir(File unstyledDir) {
        this._themeBuilderArgs.setUnstyledDir(unstyledDir);
    }

    private Artifact _resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        ArrayList repositories = new ArrayList();
        repositories.addAll(this._project.getRemotePluginRepositories());
        repositories.addAll(this._project.getRemoteProjectRepositories());
        artifactRequest.setRepositories(repositories);
        ArtifactResult artifactResult = this._repositorySystem.resolveArtifact(this._repositorySystemSession, artifactRequest);
        return artifactResult.getArtifact();
    }

    private Artifact _resolveArtifact(ComponentDependency componentDependency) throws ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(componentDependency.getGroupId(), componentDependency.getArtifactId(), componentDependency.getType(), componentDependency.getVersion());
        return this._resolveArtifact((Artifact)artifact);
    }

    private Artifact _resolveArtifact(Dependency dependency) throws ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getVersion());
        return this._resolveArtifact((Artifact)artifact);
    }
}

