/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.java.parser.JavaParser;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class FileUtil {
    public static void delete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        Files.delete(file.toPath());
        System.out.println("Deleting " + file.getCanonicalPath());
    }

    public static void deleteFiles(String dirName, List<File> files) throws Exception {
        Path path = Paths.get(dirName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        final HashSet<String> canonicalPaths = new HashSet<String>();
        for (File file : files) {
            canonicalPaths.add(file.getCanonicalPath());
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                File file = path.toFile();
                if (canonicalPaths.contains(file.getCanonicalPath())) {
                    return FileVisitResult.CONTINUE;
                }
                String content = FileUtil.read(file);
                if (StringUtil.endsWith(file.getName(), ".java") && !content.contains("@generated")) {
                    return FileVisitResult.CONTINUE;
                }
                if (StringUtil.endsWith(file.getName(), ".properties") && !content.contains("# This is a generated file.")) {
                    return FileVisitResult.CONTINUE;
                }
                FileUtil.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String getCopyrightYear(File file) throws Exception {
        String content;
        int x;
        if (file.exists() && (x = (content = FileUtil.read(file)).indexOf("/**\n * SPDX-FileCopyrightText: (c) ")) != -1) {
            return content.substring(x + 35, x + 39);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return format.format((Object)new Date());
    }

    public static File[] getFiles(File dir, final String prefix, final String suffix) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String name = file.getName();
                return name.startsWith(prefix) && name.endsWith(suffix);
            }
        });
    }

    public static String read(File file) throws IOException {
        if (!file.exists()) {
            return "";
        }
        String s = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        return StringUtil.replace(s, "\r\n", "\n");
    }

    public static void write(File file, String content) throws Exception {
        if (!file.exists()) {
            Path path = file.toPath();
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        String oldContent = FileUtil.read(file);
        Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        if (!oldContent.equals(FileUtil._format(file))) {
            System.out.println("Writing " + file.getCanonicalPath());
        }
    }

    private static String _format(File file) throws Exception {
        if (StringUtil.endsWith(file.getName(), ".java")) {
            JavaParser.parse(file, 80);
        }
        return FileUtil.read(file);
    }
}

