/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.typescript;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.StringUtil_IW;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.FreeMarkerTool;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodSignature;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.ResourceOpenAPIParser;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.util.OpenAPIParserUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.util.FreeMarkerUtil;
import com.liferay.portal.tools.rest.builder.internal.util.FileUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.Application;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.ConfigYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Components;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Content;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Discriminator;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Info;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Items;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Operation;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Parameter;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.PathItem;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.RequestBody;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Response;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.ResponseCode;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TypeScriptClientUtil {
    public static void generateTypeScriptClient(File configDir, ConfigYAML configYAML, File copyrightFile, String yamlString) throws Exception {
        File baseClientDir = new File(StringUtil.removeLast(configDir.getPath(), "-impl") + "-client-js");
        ArrayList<File> files = new ArrayList<File>();
        TypeScriptClientUtil._createBuildGradleFile(baseClientDir, files);
        TypeScriptClientUtil._createNodeScriptsConfigFile(baseClientDir, files);
        TypeScriptClientUtil._createPackageJSONFile(baseClientDir, files);
        OpenAPIYAML openAPIYAML = OpenAPIParserUtil.loadOpenAPIYAML(TypeScriptClientUtil._addAutogeneratedVulcanSchemas(configYAML, yamlString));
        Map<String, Map<String, Object>> apiContexts = TypeScriptClientUtil._buildAPIContexts(configYAML, openAPIYAML);
        for (Map.Entry<String, Map<String, Object>> entry : apiContexts.entrySet()) {
            TypeScriptClientUtil._createFile(entry.getValue(), configYAML, copyrightFile, files, "typescript/api", StringBundler.concat(baseClientDir.getPath(), "/src/node/api/", StringUtil.lowerCaseFirstLetter(entry.getKey()), "Api.ts"));
        }
        TypeScriptClientUtil._createFile(null, configYAML, copyrightFile, files, "typescript/api_global", baseClientDir.getPath() + "/src/node/api.ts");
        TypeScriptClientUtil._createFile(Collections.singletonMap("apiContexts", apiContexts.values()), configYAML, copyrightFile, files, "typescript/apis", baseClientDir.getPath() + "/src/node/api/apis.ts");
        Components components = openAPIYAML.getComponents();
        Map<String, Schema> schemas = components.getSchemas();
        if (schemas != null) {
            HashSet<String> processedRelatedSchemaModels = new HashSet<String>();
            for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
                TypeScriptClientUtil._createFile(TypeScriptClientUtil._buildModelContext(entry.getKey(), entry.getValue()), configYAML, copyrightFile, files, "typescript/model", StringBundler.concat(baseClientDir.getPath(), "/src/node/model/", StringUtil.lowerCaseFirstLetter(entry.getKey()), ".ts"));
                TypeScriptClientUtil._createRelatedSchemaModels(baseClientDir, configYAML, copyrightFile, files, "", processedRelatedSchemaModels, entry.getValue());
            }
        }
        TypeScriptClientUtil._createFile(Collections.singletonMap("schemaMap", schemas), configYAML, copyrightFile, files, "typescript/models", baseClientDir.getPath() + "/src/node/model/models.ts");
        FileUtil.deleteFiles(baseClientDir.getPath(), files);
    }

    private static String _addAutogeneratedVulcanSchemas(ConfigYAML configYAML, String yamlString) throws Exception {
        OpenAPIYAML openAPIYAML = OpenAPIParserUtil.loadOpenAPIYAML(yamlString);
        HashSet<String> processedSchemaNames = new HashSet<String>();
        FreeMarkerTool freeMarkerTool = FreeMarkerTool.getInstance();
        Map<String, Schema> schemas = freeMarkerTool.getSchemas(openAPIYAML);
        for (String schemaName : schemas.keySet()) {
            List<JavaMethodSignature> javaMethodSignatures = freeMarkerTool.getResourceJavaMethodSignatures(configYAML, openAPIYAML, schemaName);
            for (JavaMethodSignature javaMethodSignature : ResourceOpenAPIParser.getResourceGetPageJavaMethodSignatures(javaMethodSignatures)) {
                String returnType = StringUtil.removeSubstrings(javaMethodSignature.getReturnType(), "com.liferay.portal.vulcan.pagination.Page<", ">");
                String returnSchemaName = StringUtil.extractLast(returnType, ".");
                if (processedSchemaNames.add(returnSchemaName)) {
                    if (processedSchemaNames.add("Facet")) {
                        yamlString = TypeScriptClientUtil._addSchema(FreeMarkerUtil.processTemplate(null, null, "facet_yaml", null), yamlString);
                    }
                    yamlString = TypeScriptClientUtil._addSchema(FreeMarkerUtil.processTemplate(null, null, "page_yaml", HashMapBuilder.put("schemaName", returnSchemaName).build()), yamlString);
                    if (StringUtil.equals("com.liferay.portal.vulcan.permission.Permission", returnType)) {
                        yamlString = TypeScriptClientUtil._addSchema(FreeMarkerUtil.processTemplate(null, null, "permission_yaml", null), yamlString);
                    }
                }
                int index = StringUtil.indexOfAny(yamlString, new String[]{"\"" + javaMethodSignature.getPath() + "\":", " " + javaMethodSignature.getPath() + ":"});
                String httpMethod = OpenAPIParserUtil.getHTTPMethod(javaMethodSignature.getOperation());
                index = yamlString.indexOf(httpMethod + ":", index);
                String oldYAMLString = yamlString.substring(index, yamlString.indexOf("tags:", index));
                String newYAMLString = oldYAMLString.replaceAll(StringBundler.concat("schema:\n([ \t]+)items:\n[ \t]+", "\\$ref: \"#/components/schemas/", returnSchemaName, "\"\n[ \t]+type: array"), StringBundler.concat("schema:\n$1\\$ref: \"#/components/schemas/Page", returnSchemaName, "\""));
                yamlString = StringUtil.replace(yamlString, oldYAMLString, newYAMLString);
            }
        }
        return yamlString;
    }

    private static String _addSchema(String schemaYAMLString, String yamlString) {
        schemaYAMLString = StringUtil.replace(schemaYAMLString, new String[]{"$", "\t", "\n"}, new String[]{"\\$", "$1", "\n$1$1"});
        return yamlString.replaceAll("([ \\t]+)schemas:", "$1schemas:\n$1$1" + schemaYAMLString);
    }

    private static Map<String, Map<String, Object>> _buildAPIContexts(ConfigYAML configYAML, OpenAPIYAML openAPIYAML) {
        HashMap<String, Map<String, Object>> apiContexts = new HashMap<String, Map<String, Object>>();
        HashMap<String, Set> importsMap = new HashMap<String, Set>();
        HashMap<String, List> operationDatasMap = new HashMap<String, List>();
        Map<String, PathItem> pathItems = openAPIYAML.getPathItems();
        for (Map.Entry<String, PathItem> entry : pathItems.entrySet()) {
            for (Operation operation : OpenAPIParserUtil.getOperations(entry.getValue())) {
                List<String> tags = operation.getTags();
                List operationDatas = operationDatasMap.computeIfAbsent(tags.get(0), tag -> new ArrayList());
                operationDatas.add(TypeScriptClientUtil._buildOperationData(configYAML, importsMap.computeIfAbsent(tags.get(0), tag -> new HashSet()), openAPIYAML, operation, entry.getKey()));
            }
        }
        for (Map.Entry<String, PathItem> entry : operationDatasMap.entrySet()) {
            apiContexts.put(entry.getKey(), HashMapBuilder.put("className", entry.getKey() + "Api").put("importClasses", (String)((Object)importsMap.getOrDefault(entry.getKey(), new HashSet()))).put("operationsData", entry.getValue()).build());
        }
        return apiContexts;
    }

    private static Map<String, Object> _buildModelContext(String modelName, Schema schema) {
        Map<String, Schema> propertySchemas;
        List<Schema> allOfSchemas;
        Schema parentSchema;
        HashSet<String> importClasses = new HashSet<String>();
        String parentClass = null;
        ArrayList properties = new ArrayList();
        if (schema.getAllOfSchemas() != null && (parentSchema = (allOfSchemas = schema.getAllOfSchemas()).get(0)).getReference() != null) {
            String parentSchemaReference = parentSchema.getReference();
            parentClass = parentSchemaReference.substring(parentSchemaReference.lastIndexOf(47) + 1);
            importClasses.add(parentClass);
            for (Schema curSchema : schema.getAllOfSchemas()) {
                if (curSchema.getPropertySchemas() == null) continue;
                Map<String, Schema> propertySchemas2 = curSchema.getPropertySchemas();
                propertySchemas2.forEach((name, propertySchema) -> properties.add(HashMapBuilder.put("dataType", TypeScriptClientUtil._getDataType(importClasses, propertySchema)).put("name", StringUtil.replace(name, '-', '_')).build()));
            }
        }
        if ((propertySchemas = schema.getPropertySchemas()) != null) {
            propertySchemas.forEach((name, propertySchema) -> properties.add(HashMapBuilder.put("dataType", TypeScriptClientUtil._getDataType(importClasses, propertySchema)).put("name", StringUtil.replace(name, '-', '_')).build()));
        }
        return HashMapBuilder.put("description", schema.getDescription()).put("discriminator", (String)((Object)((BaseMapBuilder.UnsafeSupplier)() -> {
            Discriminator discriminator = schema.getDiscriminator();
            if (discriminator == null) {
                return null;
            }
            String propertyName = discriminator.getPropertyName();
            if (Validator.isNull(propertyName)) {
                return null;
            }
            return propertyName;
        }))).put("importClasses", importClasses).put("modelName", modelName).put("parentClass", parentClass).put("properties", (String)((Object)properties)).build();
    }

    private static Map<String, Object> _buildOperationData(ConfigYAML configYAML, Set<String> importClasses, OpenAPIYAML openAPIYAML, Operation operation, String path) {
        Map<ResponseCode, Response> responses = operation.getResponses();
        return HashMapBuilder.put("description", operation.getDescription()).put("httpMethod", StringUtil.toUpperCase(OpenAPIParserUtil.getHTTPMethod(operation))).put("operationId", operation.getOperationId()).put("parameters", (String)((Object)TypeScriptClientUtil._getParameterDatas(operation, importClasses))).put("path", (List<Map<String, Object>>)((Object)((BaseMapBuilder.UnsafeSupplier)() -> {
            Application application = configYAML.getApplication();
            Info info = openAPIYAML.getInfo();
            return StringBundler.concat(application.getBaseURI(), "/", info.getVersion(), path);
        }))).put("responseContentTypes", () -> {
            if (responses == null) {
                return null;
            }
            LinkedHashSet<String> responseContentTypes = new LinkedHashSet<String>();
            for (Response response : responses.values()) {
                Map<String, Content> content = response.getContent();
                if (content == null) continue;
                responseContentTypes.addAll(content.keySet());
            }
            if (responseContentTypes.isEmpty()) {
                return null;
            }
            return responseContentTypes;
        }).put("returnDataType", () -> {
            if (responses == null) {
                return null;
            }
            for (Map.Entry entry : responses.entrySet()) {
                Collection<Content> contents;
                Iterator<Content> iterator;
                Content content;
                Response response;
                Map<String, Content> contentsMap;
                ResponseCode responseCode = (ResponseCode)entry.getKey();
                if (!Objects.equals(responseCode.getHttpCode(), 200) || (contentsMap = (response = (Response)entry.getValue()).getContent()) == null || contentsMap.isEmpty() || (content = (iterator = (contents = contentsMap.values()).iterator()).next()) == null || content.getSchema() == null) continue;
                return TypeScriptClientUtil._getDataType(importClasses, content.getSchema());
            }
            return null;
        }).build();
    }

    private static void _createBuildGradleFile(File baseClientDir, List<File> files) throws Exception {
        File file = new File(baseClientDir, "build.gradle");
        files.add(file);
        FileUtil.write(file, "");
    }

    private static void _createFile(Map<String, Object> context, ConfigYAML configYAML, File copyrightFile, List<File> files, String name, String path) throws Exception {
        File file = new File(path);
        files.add(file);
        context = context != null ? HashMapBuilder.putAll(context).put("configYAML", (Object)configYAML).put("stringUtil", (Object)StringUtil_IW.getInstance()).build() : Collections.singletonMap("configYAML", configYAML);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(copyrightFile, FileUtil.getCopyrightYear(file), name, context));
    }

    private static void _createNodeScriptsConfigFile(File basePath, List<File> files) throws Exception {
        File file = new File(basePath, "node-scripts.config.js");
        files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(null, null, "typescript/node_scripts_config_js", null));
    }

    private static void _createPackageJSONFile(File basePath, List<File> files) throws Exception {
        File file = new File(basePath, "package.json");
        files.add(file);
        FileUtil.write(file, FreeMarkerUtil.processTemplate(null, null, "typescript/package_json", HashMapBuilder.put("clientName", basePath.getName()).build()));
    }

    private static void _createRelatedSchemaModels(File baseClientDir, ConfigYAML configYAML, File copyrightFile, List<File> files, String parentYAMLPath, Set<String> processedReferences, Schema schema) throws Exception {
        Map<String, Schema> propertySchemas = schema.getPropertySchemas();
        if (propertySchemas == null) {
            return;
        }
        for (Schema propertySchema : propertySchemas.values()) {
            Schema itemsSchema;
            Items items;
            ArrayList<String> references = new ArrayList<String>();
            if (propertySchema.getReference() != null) {
                references.add(propertySchema.getReference());
            }
            if ((items = propertySchema.getItems()) != null && (itemsSchema = items.toSchema()).getReference() != null) {
                references.add(itemsSchema.getReference());
            }
            for (String reference : references) {
                boolean local = reference.startsWith("#");
                if (local && Validator.isNull(parentYAMLPath) || !processedReferences.add(reference)) continue;
                String referencedSchemaName = null;
                if (local) {
                    referencedSchemaName = reference.substring(reference.lastIndexOf("/") + 1);
                } else {
                    referencedSchemaName = reference.split("#")[1];
                    referencedSchemaName = referencedSchemaName.substring(referencedSchemaName.lastIndexOf("/") + 1);
                }
                File referencedYAMLFile = null;
                if (local) {
                    referencedYAMLFile = new File(parentYAMLPath);
                } else {
                    String referencedYAMLFileName = parentYAMLPath.substring(0, parentYAMLPath.lastIndexOf("/") + 1);
                    referencedYAMLFileName = referencedYAMLFileName + reference.split("#")[0];
                    referencedYAMLFile = new File(referencedYAMLFileName);
                }
                files.add(referencedYAMLFile);
                OpenAPIYAML referencedOpenAPIYAML = OpenAPIParserUtil.loadOpenAPIYAML(FileUtil.read(referencedYAMLFile));
                Components referencedComponents = referencedOpenAPIYAML.getComponents();
                Map<String, Schema> referencedSchemas = referencedComponents.getSchemas();
                Schema referencedSchema = referencedSchemas.get(referencedSchemaName);
                TypeScriptClientUtil._createFile(TypeScriptClientUtil._buildModelContext(referencedSchemaName, referencedSchema), configYAML, copyrightFile, files, "typescript/model", StringBundler.concat(baseClientDir.getPath(), "/src/node/model/", StringUtil.lowerCaseFirstLetter(referencedSchemaName), ".ts"));
                TypeScriptClientUtil._createRelatedSchemaModels(baseClientDir, configYAML, copyrightFile, files, referencedYAMLFile.getAbsolutePath(), processedReferences, referencedSchema);
            }
        }
    }

    private static String _getDataType(Set<String> importClasses, Schema schema) {
        if (schema == null) {
            return "any";
        }
        if (schema.getReference() != null) {
            String dataType = null;
            String schemaReference = schema.getReference();
            dataType = schemaReference.startsWith("#") ? schemaReference.substring(schemaReference.lastIndexOf(47) + 1) : schemaReference.substring(schemaReference.lastIndexOf(35) + 1);
            importClasses.add(dataType);
            return dataType;
        }
        String type = schema.getType();
        if (type.equals("array")) {
            Items items = schema.getItems();
            return "Array<" + TypeScriptClientUtil._getDataType(importClasses, items.toSchema()) + ">";
        }
        if (type.equals("boolean")) {
            return "boolean";
        }
        if (type.equals("integer") || type.equals("number")) {
            return "number";
        }
        if (type.equals("object")) {
            Schema additionalPropertySchema = schema.getAdditionalPropertySchema();
            if (additionalPropertySchema == null) {
                return "object";
            }
            if (additionalPropertySchema.getAdditionalPropertySchema() != null) {
                String dataType = TypeScriptClientUtil._getDataType(importClasses, additionalPropertySchema.getAdditionalPropertySchema());
                return "{[key: string]: {[key: string]: " + dataType + ";};}";
            }
            return "{[key: string]: " + TypeScriptClientUtil._getDataType(importClasses, additionalPropertySchema) + ";}";
        }
        if (type.equals("permission")) {
            importClasses.add("Permission");
            return "Permission";
        }
        if (type.equals("string")) {
            List<String> values = schema.getEnumValues();
            if (ListUtil.isNotNull(values)) {
                StringBuilder sb = new StringBuilder();
                for (String value : values) {
                    if (sb.length() > 0) {
                        sb.append(" | ");
                    }
                    sb.append("'");
                    sb.append(value);
                    sb.append("'");
                }
                return sb.toString();
            }
            String schemaFormat = schema.getFormat();
            if (Validator.isNotNull(schemaFormat) && (schemaFormat.equals("date") || schemaFormat.equals("date-time"))) {
                return "Date";
            }
            return "string";
        }
        return "any";
    }

    private static List<Map<String, Object>> _getParameterDatas(Operation operation, Set<String> importClasses) {
        RequestBody requestBody;
        ArrayList<Map<String, Object>> parameterDatas = new ArrayList<Map<String, Object>>();
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                parameterDatas.add(HashMapBuilder.put("dataType", TypeScriptClientUtil._getDataType(importClasses, parameter.getSchema())).put("name", StringUtil.replace(parameter.getName(), '-', "_")).put("required", (String)((Object)Boolean.valueOf(Validator.isNotNull(parameter.isRequired()) && parameter.isRequired()))).put("type", parameter.getIn()).build());
            }
        }
        if ((requestBody = operation.getRequestBody()) == null) {
            return parameterDatas;
        }
        Map<String, Content> content = requestBody.getContent();
        if (content == null || content.isEmpty()) {
            return parameterDatas;
        }
        Collection<Content> contents = content.values();
        Iterator<Content> iterator = contents.iterator();
        Content firstBodyContent = iterator.next();
        if (firstBodyContent == null) {
            return parameterDatas;
        }
        Schema schema = firstBodyContent.getSchema();
        if (schema == null) {
            return parameterDatas;
        }
        String dataType = TypeScriptClientUtil._getDataType(importClasses, schema);
        parameterDatas.add(HashMapBuilder.put("dataType", dataType).put("name", StringUtil.replace(Validator.isNull(schema.getReference()) ? "body" : dataType, '-', '_')).put("required", (String)((Object)Boolean.valueOf(false))).put("type", "body").build());
        return parameterDatas;
    }
}

