/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.parser.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodParameter;
import com.liferay.portal.tools.rest.builder.internal.freemarker.tool.java.JavaMethodSignature;
import com.liferay.portal.tools.rest.builder.internal.freemarker.util.ConfigUtil;
import com.liferay.portal.tools.rest.builder.internal.freemarker.util.OpenAPIUtil;
import com.liferay.portal.tools.rest.builder.internal.util.FileUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.YAMLUtil;
import com.liferay.portal.tools.rest.builder.internal.yaml.config.ConfigYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Components;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Content;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Info;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Items;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Operation;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.PathItem;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.RequestBody;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Response;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.ResponseCode;
import com.liferay.portal.tools.rest.builder.internal.yaml.openapi.Schema;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class OpenAPIParserUtil {
    private static final Map<Map.Entry<String, String>, String> _openAPIDataTypeMap = new HashMap<Map.Entry<String, String>, String>(){
        {
            this.put(new AbstractMap.SimpleImmutableEntry<String, Object>("boolean", null), Boolean.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("integer", "int32"), Integer.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("integer", "int64"), Long.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("number", "float"), Float.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("number", "double"), Double.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, Object>("object", null), Object.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, Object>("permission", null), "com.liferay.portal.vulcan.permission.Permission");
            this.put(new AbstractMap.SimpleImmutableEntry<String, Object>("string", null), String.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("string", "byte"), String.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("string", "binary"), String.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("string", "date"), Date.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("string", "date-time"), Date.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("string", "password"), String.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, Object>("?", null), "?");
            this.put(new AbstractMap.SimpleImmutableEntry<String, Object>("integer", null), Integer.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, Object>("number", null), Number.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("number", "bigdecimal"), BigDecimal.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("string", "email"), String.class.getName());
            this.put(new AbstractMap.SimpleImmutableEntry<String, String>("string", "uri"), String.class.getName());
        }
    };

    public static Map<String, Schema> getAllOfPropertySchemas(ConfigYAML configYAML, Schema schema, Map<String, Schema> schemas) {
        List<Schema> allOfSchemas = schema.getAllOfSchemas();
        if (allOfSchemas.size() == 1) {
            return schema.getPropertySchemas();
        }
        HashMap<String, Schema> propertySchemas = new HashMap<String, Schema>();
        for (Schema allOfSchema : allOfSchemas) {
            if (allOfSchema.getReference() != null) {
                Schema referenceSchema = schemas.get(OpenAPIParserUtil.getReferenceName(allOfSchema.getReference()));
                if (referenceSchema.getDiscriminator() != null) continue;
                if (allOfSchema.isMergeProperties() && ConfigUtil.isVersionCompatible(configYAML, 4)) {
                    propertySchemas.putAll(referenceSchema.getPropertySchemas());
                    continue;
                }
                Schema itemSchema = new Schema();
                String reference = allOfSchema.getReference();
                itemSchema.setReference(reference);
                propertySchemas.put(StringUtil.lowerCaseFirstLetter(OpenAPIParserUtil.getReferenceName(reference)), itemSchema);
                continue;
            }
            propertySchemas.putAll(allOfSchema.getPropertySchemas());
        }
        return propertySchemas;
    }

    public static String getArguments(List<JavaMethodParameter> javaMethodParameters) {
        StringBuilder sb = new StringBuilder();
        for (JavaMethodParameter javaMethodParameter : javaMethodParameters) {
            sb.append(javaMethodParameter.getParameterName());
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getArrayClassName(String name) {
        if (name.equals(Boolean.TYPE.getName())) {
            return "[Z";
        }
        if (name.equals(Double.TYPE.getName())) {
            return "[D";
        }
        if (name.equals(Float.TYPE.getName())) {
            return "[F";
        }
        if (name.equals(Integer.TYPE.getName())) {
            return "[I";
        }
        if (name.equals(Long.TYPE.getName())) {
            return "[J";
        }
        return "[L" + name + ";";
    }

    public static String getElementClassName(String name) {
        if (name.equals("[Z")) {
            return Boolean.TYPE.getName();
        }
        if (name.equals("[D")) {
            return Double.TYPE.getName();
        }
        if (name.equals("[F")) {
            return Float.TYPE.getName();
        }
        if (name.equals("[I")) {
            return Integer.TYPE.getName();
        }
        if (name.equals("[J")) {
            return Long.TYPE.getName();
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            return name.substring(2, name.length() - 1);
        }
        if (name.startsWith("[[")) {
            return OpenAPIParserUtil.getElementClassName(name.substring(1)) + "[]";
        }
        return name;
    }

    public static List<String> getExternalReferences(OpenAPIYAML openAPIYAML) {
        HashSet<String> externalReferences = new HashSet<String>();
        Map<String, PathItem> pathItems = openAPIYAML.getPathItems();
        HashMap<String, Schema> schemas = new HashMap();
        Components components = openAPIYAML.getComponents();
        if (components != null && components.getSchemas() != null) {
            schemas = components.getSchemas();
        }
        if (pathItems != null) {
            for (PathItem pathItem : pathItems.values()) {
                List<Operation> operations = OpenAPIParserUtil.getOperations(pathItem);
                for (Operation operation : operations) {
                    RequestBody requestBody = operation.getRequestBody();
                    if (requestBody != null) {
                        OpenAPIParserUtil._addExternalReferences(requestBody.getContent(), externalReferences, schemas);
                    }
                    Map<ResponseCode, Response> responses = operation.getResponses();
                    for (Response response : responses.values()) {
                        if (response == null) continue;
                        OpenAPIParserUtil._addExternalReferences(response.getContent(), externalReferences, schemas);
                    }
                }
            }
        }
        for (Schema schema : schemas.values()) {
            Map<String, Schema> propertySchemas = schema.getPropertySchemas();
            if (propertySchemas == null) continue;
            for (Schema propertySchema : propertySchemas.values()) {
                OpenAPIParserUtil._addExternalReferences(externalReferences, propertySchema, schemas);
            }
        }
        return new ArrayList<String>(externalReferences);
    }

    public static Map<String, Schema> getExternalSchemas(ConfigYAML configYAML, OpenAPIYAML openAPIYAML) throws Exception {
        HashMap<String, Schema> externalReferencesMap = new HashMap<String, Schema>();
        String externalReference = null;
        HashSet<String> visitedPaths = new HashSet<String>();
        LinkedList<String> queue = new LinkedList<String>(OpenAPIParserUtil.getExternalReferences(openAPIYAML));
        while ((externalReference = (String)queue.poll()) != null) {
            String path = externalReference.substring(0, externalReference.indexOf("#"));
            if (visitedPaths.contains(path)) continue;
            visitedPaths.add(path);
            openAPIYAML = YAMLUtil.loadOpenAPIYAML(FileUtil.read(new File(path)));
            externalReferencesMap.putAll(OpenAPIUtil.getAllSchemas(configYAML, openAPIYAML));
            for (String curExternalReference : OpenAPIParserUtil.getExternalReferences(openAPIYAML)) {
                queue.add(path.substring(0, path.lastIndexOf("/") + 1) + curExternalReference);
            }
        }
        return externalReferencesMap;
    }

    public static String getHTTPMethod(Operation operation) {
        Class<?> clazz = operation.getClass();
        return StringUtil.lowerCase(clazz.getSimpleName());
    }

    public static String getJavaDataType(Map<String, String> javaDataTypeMap, Schema schema) {
        if (schema.getAllOfSchemas() != null) {
            for (Schema allOfSchema : schema.getAllOfSchemas()) {
                if (!Validator.isNotNull(allOfSchema.getReference())) continue;
                return javaDataTypeMap.get(OpenAPIParserUtil.getReferenceName(allOfSchema.getReference()));
            }
        }
        if (schema.getAnyOfSchemas() != null || schema.getOneOfSchemas() != null) {
            return Object.class.getName();
        }
        if (schema.getItems() != null) {
            return OpenAPIParserUtil._getItemsDataType(javaDataTypeMap, schema.getItems());
        }
        if (Objects.equals(schema.getType(), "object")) {
            return OpenAPIParserUtil._getMapType(javaDataTypeMap, schema.getAdditionalPropertySchema());
        }
        if (schema.getReference() != null) {
            return javaDataTypeMap.get(OpenAPIParserUtil.getReferenceName(schema.getReference()));
        }
        String type = _openAPIDataTypeMap.get(new AbstractMap.SimpleImmutableEntry<String, String>(schema.getType(), schema.getFormat()));
        if (type == null) {
            throw new RuntimeException(StringBundler.concat("Unsupported combination of type/format: ", schema.getType(), "/", schema.getFormat()));
        }
        return type;
    }

    public static Map<String, String> getJavaDataTypeMap(ConfigYAML configYAML, OpenAPIYAML openAPIYAML) {
        HashMap<String, String> javaDataTypeMap = new HashMap<String, String>();
        HashSet<String> visitedPaths = new HashSet<String>();
        try {
            for (String string : OpenAPIParserUtil.getExternalReferences(openAPIYAML)) {
                String path = string.substring(0, string.indexOf("#"));
                if (visitedPaths.contains(path)) continue;
                visitedPaths.add(path);
                String configPath = StringUtil.replace(path, "rest-openapi.yaml", "rest-config.yaml");
                ConfigYAML externalConfigYAML = YAMLUtil.loadConfigYAML(FileUtil.read(new File(configPath)));
                OpenAPIYAML externalOpenAPIYAML = YAMLUtil.loadOpenAPIYAML(FileUtil.read(new File(path)));
                if (externalConfigYAML == null || externalOpenAPIYAML == null) continue;
                Map<String, String> externalJavaDataTypeMap = OpenAPIParserUtil.getJavaDataTypeMap(externalConfigYAML, externalOpenAPIYAML);
                javaDataTypeMap.putAll(externalJavaDataTypeMap);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        Map<String, Schema> allSchemas = OpenAPIUtil.getAllSchemas(configYAML, openAPIYAML);
        for (String schemaName : allSchemas.keySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(configYAML.getApiPackagePath());
            sb.append(".dto.");
            sb.append(OpenAPIUtil.escapeVersion(openAPIYAML));
            sb.append('.');
            sb.append(schemaName);
            javaDataTypeMap.put(schemaName, sb.toString());
            sb.setLength(0);
            sb.append(configYAML.getApiPackagePath());
            sb.append(".resource.");
            sb.append(OpenAPIUtil.escapeVersion(openAPIYAML));
            sb.append('.');
            sb.append(schemaName);
            sb.append("Resource");
            javaDataTypeMap.put(schemaName + "Resource", sb.toString());
            sb.setLength(0);
            sb.append(configYAML.getApiPackagePath());
            sb.append(".internal.resource.");
            sb.append(OpenAPIUtil.escapeVersion(openAPIYAML));
            sb.append('.');
            sb.append(schemaName);
            sb.append("ResourceImpl");
            javaDataTypeMap.put(schemaName + "ResourceImpl", sb.toString());
        }
        Map<String, Schema> map = OpenAPIUtil.getGlobalEnumSchemas(configYAML, allSchemas);
        for (String schemaName : map.keySet()) {
            javaDataTypeMap.put(schemaName, StringBundler.concat(configYAML.getApiPackagePath(), ".constant.", OpenAPIUtil.escapeVersion(openAPIYAML), Character.valueOf('.'), schemaName));
        }
        return javaDataTypeMap;
    }

    public static List<Operation> getOperations(PathItem pathItem) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (pathItem.getDelete() != null) {
            operations.add(pathItem.getDelete());
        }
        if (pathItem.getGet() != null) {
            operations.add(pathItem.getGet());
        }
        if (pathItem.getHead() != null) {
            operations.add(pathItem.getHead());
        }
        if (pathItem.getOptions() != null) {
            operations.add(pathItem.getOptions());
        }
        if (pathItem.getPatch() != null) {
            operations.add(pathItem.getPatch());
        }
        if (pathItem.getPost() != null) {
            operations.add(pathItem.getPost());
        }
        if (pathItem.getPut() != null) {
            operations.add(pathItem.getPut());
        }
        return operations;
    }

    public static String getParameter(JavaMethodParameter javaMethodParameter, String parameterAnnotation) {
        String parameterType;
        StringBundler sb = new StringBundler(6);
        if (Validator.isNotNull(parameterAnnotation)) {
            sb.append(parameterAnnotation);
            sb.append(' ');
        }
        if ((parameterType = javaMethodParameter.getParameterType()).startsWith("[")) {
            sb.append(OpenAPIParserUtil.getElementClassName(parameterType));
            sb.append("[]");
        } else {
            sb.append(parameterType);
        }
        sb.append(' ');
        sb.append(javaMethodParameter.getParameterName());
        return sb.toString();
    }

    public static String getReferenceName(String reference) {
        if (!reference.contains("#/components/parameters") && !reference.contains("#/components/schemas")) {
            return reference.substring(reference.lastIndexOf("#") + 1);
        }
        int index = reference.lastIndexOf(47);
        if (index == -1) {
            return reference;
        }
        return reference.substring(index + 1);
    }

    public static Set<String> getSchemaNames(List<JavaMethodSignature> javaMethodSignatures) {
        TreeSet<String> schemaNames = new TreeSet<String>();
        for (JavaMethodSignature javaMethodSignature : javaMethodSignatures) {
            schemaNames.add(javaMethodSignature.getSchemaName());
        }
        return schemaNames;
    }

    public static String getSchemaVarName(String schemaName) {
        return TextFormatter.format(schemaName, 8);
    }

    public static String getVersion(OpenAPIYAML openAPIYAML) {
        Info info = openAPIYAML.getInfo();
        return info.getVersion();
    }

    public static boolean hasHTTPMethod(JavaMethodSignature javaMethodSignature, String ... httpMethods) {
        Operation operation = javaMethodSignature.getOperation();
        for (String httpMethod : httpMethods) {
            if (!Objects.equals(httpMethod, OpenAPIParserUtil.getHTTPMethod(operation))) continue;
            return true;
        }
        return false;
    }

    private static void _addExternalReferences(Map<String, Content> contents, Set<String> externalReferences, Map<String, Schema> schemas) {
        if (contents == null) {
            return;
        }
        for (Content content : contents.values()) {
            OpenAPIParserUtil._addExternalReferences(externalReferences, content.getSchema(), schemas);
        }
    }

    private static void _addExternalReferences(Set<String> externalReferences, Schema schema, Map<String, Schema> schemas) {
        if (schema == null) {
            return;
        }
        LinkedList<Map<String, Schema>> queue = new LinkedList<Map<String, Schema>>();
        queue.add(Collections.singletonMap("content", schema));
        Map map = null;
        HashSet<String> visited = new HashSet<String>();
        while ((map = (Map)queue.poll()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (visited.contains(entry.getKey())) continue;
                Schema currentSchema = (Schema)entry.getValue();
                String reference = OpenAPIParserUtil._getReference(currentSchema);
                if (reference != null) {
                    if (reference.contains("#/components/schemas/")) {
                        String referenceName = OpenAPIParserUtil.getReferenceName(reference);
                        Schema referenceSchema = schemas.get(referenceName);
                        if (referenceSchema == null) continue;
                        queue.add(Collections.singletonMap(referenceName, referenceSchema));
                        visited.add((String)entry.getKey());
                        continue;
                    }
                    externalReferences.add(reference);
                    continue;
                }
                if (currentSchema.getAllOfSchemas() != null) {
                    List<Schema> allOfSchemas = currentSchema.getAllOfSchemas();
                    queue.add(Collections.singletonMap("allOf" + (String)entry.getKey(), allOfSchemas.get(0)));
                    visited.add((String)entry.getKey());
                    continue;
                }
                if (currentSchema.getPropertySchemas() == null) continue;
                queue.add(currentSchema.getPropertySchemas());
                visited.add((String)entry.getKey());
            }
        }
    }

    private static String _getItemsDataType(Map<String, String> javaDataTypeMap, Items items) {
        Items childItems;
        String type = items.getType();
        if (StringUtil.equals(type, "array") && (childItems = items.getItems()) != null) {
            return "[" + OpenAPIParserUtil._getItemsDataType(javaDataTypeMap, childItems);
        }
        String javaDataType = _openAPIDataTypeMap.get(new AbstractMap.SimpleImmutableEntry<String, String>(type, items.getFormat()));
        if (items.getAdditionalPropertySchema() != null) {
            javaDataType = Map.class.getName();
        }
        if (items.getReference() != null) {
            javaDataType = javaDataTypeMap.get(OpenAPIParserUtil.getReferenceName(items.getReference()));
        }
        return OpenAPIParserUtil.getArrayClassName(javaDataType);
    }

    private static String _getMapType(Map<String, String> javaDataTypeMap, Schema schema) {
        if (schema != null) {
            if (schema.getReference() != null) {
                String referenceType = javaDataTypeMap.get(OpenAPIParserUtil.getReferenceName(schema.getReference()));
                return "Map<String, " + referenceType + ">";
            }
            AbstractMap.SimpleImmutableEntry<String, String> key = new AbstractMap.SimpleImmutableEntry<String, String>(schema.getType(), schema.getFormat());
            if (_openAPIDataTypeMap.containsKey(key)) {
                String additionalJavaDataType = OpenAPIParserUtil.getJavaDataType(javaDataTypeMap, schema);
                return "Map<String, " + additionalJavaDataType + ">";
            }
        }
        return Object.class.getName();
    }

    private static String _getReference(Schema schema) {
        if (schema.getReference() != null) {
            return schema.getReference();
        }
        Items items = schema.getItems();
        if (items != null) {
            return items.getReference();
        }
        return null;
    }
}

