/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.internal.util;

import com.liferay.portal.tools.bundle.support.util.StreamLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    public static String createToken(URI uri, String userName, String password) throws IOException {
        try (CloseableHttpClient closeableHttpClient = HttpUtil._getHttpClient(uri, userName, password, -1);){
            String string;
            block12: {
                HttpPost httpPost = new HttpPost(uri);
                InetAddress inetAddress = InetAddress.getLocalHost();
                BasicNameValuePair deviceNameValuePair = new BasicNameValuePair("device", "portal-tools-bundle-support-" + inetAddress.getHostName());
                httpPost.setEntity(new UrlEncodedFormEntity(Collections.singleton(deviceNameValuePair)));
                CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpPost);
                try {
                    HttpUtil._checkResponseStatus(closeableHttpResponse);
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    String json = EntityUtils.toString(httpEntity, StandardCharsets.UTF_8);
                    int start = json.indexOf("token\":") + 7;
                    start = json.indexOf(34, start) + 1;
                    int end = json.indexOf(34, start);
                    string = json.substring(start, end);
                    if (closeableHttpResponse == null) break block12;
                }
                catch (Throwable throwable) {
                    if (closeableHttpResponse != null) {
                        try {
                            closeableHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                closeableHttpResponse.close();
            }
            return string;
        }
    }

    public static Path downloadFile(URI uri, String token, Path cacheDirPath, StreamLogger streamLogger) throws Exception {
        return HttpUtil.downloadFile(uri, token, cacheDirPath, streamLogger, -1);
    }

    public static Path downloadFile(URI uri, String token, Path cacheDirPath, StreamLogger streamLogger, int connectionTimeout) throws Exception {
        Path path;
        try (CloseableHttpClient closeableHttpClient = HttpUtil._getHttpClient(uri, token, connectionTimeout);){
            path = HttpUtil._downloadFile(closeableHttpClient, uri, cacheDirPath, streamLogger);
        }
        return path;
    }

    public static Path downloadFile(URI uri, String userName, String password, Path cacheDirPath, StreamLogger streamLogger) throws Exception {
        return HttpUtil.downloadFile(uri, userName, password, cacheDirPath, streamLogger, -1);
    }

    public static Path downloadFile(URI uri, String userName, String password, Path cacheDirPath, StreamLogger streamLogger, int connectionTimeout) throws Exception {
        Path path;
        try (CloseableHttpClient closeableHttpClient = HttpUtil._getHttpClient(uri, userName, password, connectionTimeout);){
            path = HttpUtil._downloadFile(closeableHttpClient, uri, cacheDirPath, streamLogger);
        }
        return path;
    }

    private static void _checkResponseStatus(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException(statusLine.getReasonPhrase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path _downloadFile(CloseableHttpClient closeableHttpClient, URI uri, Path cacheDirPath, StreamLogger streamLogger) throws Exception {
        Path path;
        Date lastModifiedDate;
        HttpHead httpHead = new HttpHead(uri);
        BasicHttpContext httpContext = new BasicHttpContext();
        String fileName = null;
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpHead, httpContext);){
            HttpUtil._checkResponseStatus(closeableHttpResponse);
            Header dispositionHeader = closeableHttpResponse.getFirstHeader("Content-Disposition");
            if (dispositionHeader != null) {
                String dispositionValue = dispositionHeader.getValue();
                int index = dispositionValue.indexOf("filename=");
                if (index > 0) {
                    fileName = dispositionValue.substring(index + "filename=".length());
                }
            } else {
                RedirectLocations redirectLocations = (RedirectLocations)httpContext.getAttribute("http.protocol.redirect-locations");
                if (redirectLocations != null) {
                    uri = redirectLocations.get(redirectLocations.size() - 1);
                }
            }
            Header lastModifiedHeader = closeableHttpResponse.getFirstHeader("Last-Modified");
            lastModifiedDate = lastModifiedHeader != null ? DateUtils.parseDate(lastModifiedHeader.getValue()) : new Date();
        }
        if (fileName == null) {
            String uriPath = uri.getPath();
            fileName = uriPath.substring(uriPath.lastIndexOf(47) + 1);
        }
        if (cacheDirPath == null) {
            cacheDirPath = Files.createTempDirectory(null, new FileAttribute[0]);
        }
        if (Files.exists(path = cacheDirPath.resolve(fileName), new LinkOption[0])) {
            FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            if (fileTime.toMillis() == lastModifiedDate.getTime()) {
                return path;
            }
            Files.delete(path);
        }
        Files.createDirectories(cacheDirPath, new FileAttribute[0]);
        HttpGet httpGet = new HttpGet(uri);
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpGet);){
            HttpUtil._checkResponseStatus(closeableHttpResponse);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            long length = httpEntity.getContentLength();
            streamLogger.onStarted();
            try (InputStream inputStream = httpEntity.getContent();
                 OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                byte[] buffer = new byte[10240];
                int completed = 0;
                int read = -1;
                while ((read = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, read);
                    streamLogger.onProgress(completed += read, length);
                }
            }
            finally {
                streamLogger.onCompleted();
            }
        }
        Files.setLastModifiedTime(path, FileTime.fromMillis(lastModifiedDate.getTime()));
        return path;
    }

    private static CloseableHttpClient _getHttpClient(URI uri, String token, int connectionTimeout) {
        HttpClientBuilder httpClientBuilder = HttpUtil._getHttpClientBuilder(uri, null, null, connectionTimeout);
        BasicHeader header = new BasicHeader("Authorization", "Bearer " + token);
        httpClientBuilder.setDefaultHeaders(Collections.singleton(header));
        return httpClientBuilder.build();
    }

    private static CloseableHttpClient _getHttpClient(URI uri, String userName, String password, int connectionTimeout) {
        HttpClientBuilder httpClientBuilder = HttpUtil._getHttpClientBuilder(uri, userName, password, connectionTimeout);
        return httpClientBuilder.build();
    }

    private static HttpClientBuilder _getHttpClientBuilder(URI uri, String userName, String password, int connectionTimeout) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(connectionTimeout);
        requestConfigBuilder.setCookieSpec("standard");
        requestConfigBuilder.setRedirectsEnabled(true);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        if (userName != null && password != null) {
            credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), new UsernamePasswordCredentials(userName, password));
        }
        String scheme = uri.getScheme();
        String proxyHost = System.getProperty(scheme + ".proxyHost");
        String proxyPort = System.getProperty(scheme + ".proxyPort");
        String proxyUser = System.getProperty(scheme + ".proxyUser");
        String proxyPassword = System.getProperty(scheme + ".proxyPassword");
        if (proxyHost != null && proxyPort != null && proxyUser != null && proxyPassword != null) {
            credentialsProvider.setCredentials(new AuthScope(proxyHost, Integer.parseInt(proxyPort)), new UsernamePasswordCredentials(proxyUser, proxyPassword));
        }
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder;
    }
}

