/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.wedeploy.auth.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.security.wedeploy.auth.configuration.WeDeployAuthWebConfiguration;
import com.liferay.portal.security.wedeploy.auth.exception.WeDeployAuthTokenExpiredException;
import com.liferay.portal.security.wedeploy.auth.model.WeDeployAuthToken;
import com.liferay.portal.security.wedeploy.auth.service.base.WeDeployAuthTokenLocalServiceBaseImpl;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.security.wedeploy.auth.configuration.WeDeployAuthWebConfiguration"}, property={"model.class.name=com.liferay.portal.security.wedeploy.auth.model.WeDeployAuthToken"}, service={AopService.class})
public class WeDeployAuthTokenLocalServiceImpl
extends WeDeployAuthTokenLocalServiceBaseImpl {
    private volatile WeDeployAuthWebConfiguration _weDeployAuthWebConfiguration;

    public WeDeployAuthToken addAccessWeDeployAuthToken(String redirectURI, String clientId, String clientSecret, String authorizationToken, int type, ServiceContext serviceContext) throws PortalException {
        this.validateAccess(redirectURI, clientId, clientSecret);
        WeDeployAuthToken weDeployAuthToken = this.weDeployAuthTokenPersistence.removeByCI_T_T(clientId, authorizationToken, type);
        Date date = weDeployAuthToken.getCreateDate();
        long authorizationTokenExpirationTime = this._weDeployAuthWebConfiguration.authorizationTokenExpirationTime();
        long expirationTime = date.getTime() + authorizationTokenExpirationTime;
        if (System.currentTimeMillis() > expirationTime) {
            throw new WeDeployAuthTokenExpiredException();
        }
        String token = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{clientId.concat(authorizationToken), PwdGenerator.getPassword()});
        return this.addWeDeployAuthToken(weDeployAuthToken.getUserId(), clientId, token, 2, serviceContext);
    }

    public WeDeployAuthToken addAuthorizationWeDeployAuthToken(long userId, String redirectURI, String clientId, ServiceContext serviceContext) throws PortalException {
        this.validateAuthorization(redirectURI, clientId);
        String token = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{clientId, PwdGenerator.getPassword()});
        return this.addWeDeployAuthToken(userId, clientId, token, 1, new ServiceContext());
    }

    public WeDeployAuthToken addWeDeployAuthToken(long userId, String clientId, String token, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.fetchUserById(userId);
        Date date = new Date();
        long weDeployAuthTokenId = this.counterLocalService.increment();
        WeDeployAuthToken weDeployAuthToken = this.weDeployAuthTokenPersistence.create(weDeployAuthTokenId);
        weDeployAuthToken.setCompanyId(user.getCompanyId());
        weDeployAuthToken.setUserId(user.getUserId());
        weDeployAuthToken.setUserName(user.getFullName());
        weDeployAuthToken.setCreateDate(serviceContext.getCreateDate(date));
        weDeployAuthToken.setModifiedDate(serviceContext.getModifiedDate(date));
        weDeployAuthToken.setClientId(clientId);
        weDeployAuthToken.setToken(token);
        weDeployAuthToken.setType(type);
        weDeployAuthToken = (WeDeployAuthToken)this.weDeployAuthTokenPersistence.update((BaseModel)weDeployAuthToken);
        this.resourceLocalService.addModelResources((AuditedModel)weDeployAuthToken, serviceContext);
        return weDeployAuthToken;
    }

    public WeDeployAuthToken getWeDeployAuthToken(String token, int type) throws PortalException {
        return this.weDeployAuthTokenPersistence.findByT_T(token, type);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._weDeployAuthWebConfiguration = (WeDeployAuthWebConfiguration)ConfigurableUtil.createConfigurable(WeDeployAuthWebConfiguration.class, properties);
    }

    protected void validateAccess(String redirectURI, String clientId, String clientSecret) throws PortalException {
        this.weDeployAuthAppPersistence.findByRU_CI(redirectURI, clientId);
        this.weDeployAuthAppPersistence.findByCI_CS(clientId, clientSecret);
    }

    protected void validateAuthorization(String redirectURI, String clientId) throws PortalException {
        this.weDeployAuthAppPersistence.findByRU_CI(redirectURI, clientId);
    }
}

