/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.security.wedeploy.auth.model.impl;

import com.liferay.portal.security.wedeploy.auth.model.WeDeployAuthToken;
import com.liferay.portal.security.wedeploy.auth.service.WeDeployAuthTokenLocalServiceUtil;

/**
 * The extended model base implementation for the WeDeployAuthToken service. Represents a row in the &quot;WeDeployAuth_WeDeployAuthToken&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WeDeployAuthTokenImpl}.
 * </p>
 *
 * @author Supritha Sundaram
 * @see WeDeployAuthTokenImpl
 * @see WeDeployAuthToken
 * @generated
 */
public abstract class WeDeployAuthTokenBaseImpl
	extends WeDeployAuthTokenModelImpl implements WeDeployAuthToken {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a we deploy auth token model instance should use the <code>WeDeployAuthToken</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			WeDeployAuthTokenLocalServiceUtil.addWeDeployAuthToken(this);
		}
		else {
			WeDeployAuthTokenLocalServiceUtil.updateWeDeployAuthToken(this);
		}
	}

}