/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.security.wedeploy.auth.model.impl;

import com.liferay.portal.security.wedeploy.auth.model.WeDeployAuthApp;
import com.liferay.portal.security.wedeploy.auth.service.WeDeployAuthAppLocalServiceUtil;

/**
 * The extended model base implementation for the WeDeployAuthApp service. Represents a row in the &quot;WeDeployAuth_WeDeployAuthApp&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WeDeployAuthAppImpl}.
 * </p>
 *
 * @author Supritha Sundaram
 * @see WeDeployAuthAppImpl
 * @see WeDeployAuthApp
 * @generated
 */
public abstract class WeDeployAuthAppBaseImpl
	extends WeDeployAuthAppModelImpl implements WeDeployAuthApp {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a we deploy auth app model instance should use the <code>WeDeployAuthApp</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			WeDeployAuthAppLocalServiceUtil.addWeDeployAuthApp(this);
		}
		else {
			WeDeployAuthAppLocalServiceUtil.updateWeDeployAuthApp(this);
		}
	}

}