/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.tunnel;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.tunnel.TunnelAuthenticationManagerUtil;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicy;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(service={AuthVerifier.class})
public class TunnelAuthVerifier
implements AuthVerifier {
    private static final Log _log = LogFactoryUtil.getLog(TunnelAuthVerifier.class);

    public String getAuthType() {
        return "BASIC";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        try {
            String[] credentials = this.verify(accessControlContext.getRequest());
            if (credentials != null) {
                authVerifierResult.setPassword(credentials[1]);
                authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
                authVerifierResult.setUserId(Long.valueOf(credentials[0]).longValue());
                String serviceAccessPolicyName = (String)properties.get("service.access.policy.name");
                Map settings = authVerifierResult.getSettings();
                List serviceAccessPolicyNames = (List)settings.computeIfAbsent(ServiceAccessPolicy.SERVICE_ACCESS_POLICY_NAMES, value -> new ArrayList());
                serviceAccessPolicyNames.add(serviceAccessPolicyName);
            }
        }
        catch (AuthException authException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)authException);
            }
            HttpServletResponse httpServletResponse = accessControlContext.getResponse();
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());){
                objectOutputStream.writeObject((Object)authException);
                authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
                throw authException;
            }
        }
        return authVerifierResult;
    }

    protected String[] verify(HttpServletRequest httpServletRequest) throws AuthException {
        String authorization = httpServletRequest.getHeader("Authorization");
        if (authorization == null) {
            return null;
        }
        String[] credentials = new String[]{String.valueOf(TunnelAuthenticationManagerUtil.getUserId((HttpServletRequest)httpServletRequest)), ""};
        return credentials;
    }
}

