/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.digest.authentication;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.security.auth.http.HttpAuthManagerUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Deprecated
@Component(service={AuthVerifier.class})
public class DigestAuthenticationAuthVerifier
implements AuthVerifier {
    public String getAuthType() {
        return "DIGEST";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties configuration) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            HttpServletRequest httpServletRequest = accessControlContext.getRequest();
            long userId = HttpAuthManagerUtil.getDigestUserId((HttpServletRequest)httpServletRequest);
            if (userId == 0L) {
                boolean forcedDigestAuth = MapUtil.getBoolean((Map)accessControlContext.getSettings(), (String)"digest_auth");
                if (!forcedDigestAuth) {
                    forcedDigestAuth = GetterUtil.getBoolean((String)configuration.getProperty("digest_auth"));
                }
                if (forcedDigestAuth) {
                    HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Digest");
                    HttpAuthManagerUtil.generateChallenge((HttpServletRequest)httpServletRequest, (HttpServletResponse)accessControlContext.getResponse(), (HttpAuthorizationHeader)httpAuthorizationHeader);
                    authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
                }
                return authVerifierResult;
            }
            authVerifierResult.setPasswordBasedAuthentication(true);
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(userId);
            return authVerifierResult;
        }
        catch (PortalException portalException) {
            throw new AuthException((Throwable)portalException);
        }
        catch (SystemException systemException) {
            throw new AuthException((Throwable)systemException);
        }
    }
}

