/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.basic.auth.header;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.security.auth.http.HttpAuthManagerUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuthVerifier.class})
public class BasicAuthHeaderAuthVerifier
implements AuthVerifier {
    private static final Log _log = LogFactoryUtil.getLog(BasicAuthHeaderAuthVerifier.class);
    @Reference(target="(&(private.auto.login=true)(type=basic.auth.header))")
    private AutoLogin _autoLogin;

    public String getAuthType() {
        return "BASIC";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            String[] credentials = this._autoLogin.login(accessControlContext.getRequest(), accessControlContext.getResponse());
            if (credentials != null) {
                authVerifierResult.setPassword(credentials[1]);
                authVerifierResult.setPasswordBasedAuthentication(true);
                authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
                authVerifierResult.setUserId(Long.valueOf(credentials[0]).longValue());
            } else if (this._isBasicAuth(accessControlContext, properties)) {
                return this._generateChallenge(accessControlContext);
            }
            return authVerifierResult;
        }
        catch (AutoLoginException autoLoginException) {
            if (this._isBasicAuth(accessControlContext, properties)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)autoLoginException);
                }
                return this._generateChallenge(accessControlContext);
            }
            throw new AuthException((Throwable)autoLoginException);
        }
    }

    private AuthVerifierResult _generateChallenge(AccessControlContext accessControlContext) {
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
        HttpAuthManagerUtil.generateChallenge((HttpServletRequest)accessControlContext.getRequest(), (HttpServletResponse)accessControlContext.getResponse(), (HttpAuthorizationHeader)httpAuthorizationHeader);
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
        return authVerifierResult;
    }

    private boolean _isBasicAuth(AccessControlContext accessControlContext, Properties properties) {
        boolean basicAuth = MapUtil.getBoolean((Map)accessControlContext.getSettings(), (String)"basic_auth");
        if (!basicAuth) {
            basicAuth = GetterUtil.getBoolean((String)properties.getProperty("basic_auth"));
        }
        return basicAuth;
    }
}

