/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.process;

import com.liferay.petra.string.StringUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;

public class ClassPathUtil {
    public static URL[] getClassPathURLs(String classPath) throws MalformedURLException {
        List paths = StringUtil.split((String)classPath, (char)File.pathSeparatorChar);
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (String path : paths) {
            File file = new File(path);
            URI uri = file.toURI();
            urls.add(uri.toURL());
        }
        return urls.toArray(new URL[0]);
    }

    public static String getJVMClassPath(boolean includeBootClassPath) {
        String bootClassPath;
        String jvmClassPath = System.getProperty("java.class.path");
        if (includeBootClassPath && (bootClassPath = System.getProperty("sun.boot.class.path")) != null) {
            jvmClassPath = jvmClassPath.concat(File.pathSeparator).concat(bootClassPath);
        }
        return jvmClassPath;
    }
}

