/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.function.transform;

import com.liferay.petra.function.UnsafeFunction;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransformUtil {
    public static <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransform(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <R, E extends Throwable> R[] transform(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction, Class<? extends R> clazz) {
        try {
            return TransformUtil.unsafeTransform(array, unsafeFunction, clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <R, E extends Throwable> R[] transform(long[] array, UnsafeFunction<Long, R, E> unsafeFunction, Class<? extends R> clazz) {
        try {
            return TransformUtil.unsafeTransform(array, unsafeFunction, clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        try {
            return TransformUtil.unsafeTransform(array, unsafeFunction, clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        try {
            return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> boolean[] transformToBooleanArray(Collection<T> collection, UnsafeFunction<T, Boolean, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToBooleanArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> boolean[] transformToBooleanArray(T[] array, UnsafeFunction<T, Boolean, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToBooleanArray(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> byte[] transformToByteArray(Collection<T> collection, UnsafeFunction<T, Byte, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToByteArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> byte[] transformToByteArray(T[] array, UnsafeFunction<T, Byte, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToByteArray(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> double[] transformToDoubleArray(Collection<T> collection, UnsafeFunction<T, Double, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToDoubleArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> double[] transformToDoubleArray(T[] array, UnsafeFunction<T, Double, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToDoubleArray(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> float[] transformToFloatArray(Collection<T> collection, UnsafeFunction<T, Float, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToFloatArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> float[] transformToFloatArray(T[] array, UnsafeFunction<T, Float, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToFloatArray(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> int[] transformToIntArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToIntArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> int[] transformToIntArray(T[] array, UnsafeFunction<T, Integer, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToIntArray(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <R, E extends Throwable> List<R> transformToList(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToList(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <R, E extends Throwable> List<R> transformToList(long[] array, UnsafeFunction<Long, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToList(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToList(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> long[] transformToLongArray(T[] array, UnsafeFunction<T, Long, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToLongArray(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> short[] transformToShortArray(Collection<T> collection, UnsafeFunction<T, Short, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToShortArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, E extends Throwable> short[] transformToShortArray(T[] array, UnsafeFunction<T, Short, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToShortArray(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        if (collection == null) {
            return new ArrayList();
        }
        ArrayList<R> list = new ArrayList<R>(collection.size());
        for (T item : collection) {
            R newItem = unsafeFunction.apply(item);
            if (newItem == null) continue;
            list.add(newItem);
        }
        return list;
    }

    public static <R, E extends Throwable> R[] unsafeTransform(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        List<R> list = TransformUtil.unsafeTransformToList(array, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <R, E extends Throwable> R[] unsafeTransform(long[] array, UnsafeFunction<Long, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        List<R> list = TransformUtil.unsafeTransformToList(array, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        List<R> list = TransformUtil.unsafeTransformToList(array, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        List<R> list = TransformUtil.unsafeTransform(collection, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T, E extends Throwable> boolean[] unsafeTransformToBooleanArray(Collection<T> collection, UnsafeFunction<T, Boolean, E> unsafeFunction) throws E {
        return (boolean[])TransformUtil._unsafeTransformToPrimitiveArray(collection, unsafeFunction, boolean[].class);
    }

    public static <T, E extends Throwable> boolean[] unsafeTransformToBooleanArray(T[] array, UnsafeFunction<T, Boolean, E> unsafeFunction) throws E {
        return (boolean[])TransformUtil._unsafeTransformToPrimitiveArray(array, unsafeFunction, boolean[].class);
    }

    public static <T, E extends Throwable> byte[] unsafeTransformToByteArray(Collection<T> collection, UnsafeFunction<T, Byte, E> unsafeFunction) throws E {
        return (byte[])TransformUtil._unsafeTransformToPrimitiveArray(collection, unsafeFunction, byte[].class);
    }

    public static <T, E extends Throwable> byte[] unsafeTransformToByteArray(T[] array, UnsafeFunction<T, Byte, E> unsafeFunction) throws E {
        return (byte[])TransformUtil._unsafeTransformToPrimitiveArray(array, unsafeFunction, byte[].class);
    }

    public static <T, E extends Throwable> double[] unsafeTransformToDoubleArray(Collection<T> collection, UnsafeFunction<T, Double, E> unsafeFunction) throws E {
        return (double[])TransformUtil._unsafeTransformToPrimitiveArray(collection, unsafeFunction, double[].class);
    }

    public static <T, E extends Throwable> double[] unsafeTransformToDoubleArray(T[] array, UnsafeFunction<T, Double, E> unsafeFunction) throws E {
        return (double[])TransformUtil._unsafeTransformToPrimitiveArray(array, unsafeFunction, double[].class);
    }

    public static <T, E extends Throwable> float[] unsafeTransformToFloatArray(Collection<T> collection, UnsafeFunction<T, Float, E> unsafeFunction) throws E {
        return (float[])TransformUtil._unsafeTransformToPrimitiveArray(collection, unsafeFunction, float[].class);
    }

    public static <T, E extends Throwable> float[] unsafeTransformToFloatArray(T[] array, UnsafeFunction<T, Float, E> unsafeFunction) throws E {
        return (float[])TransformUtil._unsafeTransformToPrimitiveArray(array, unsafeFunction, float[].class);
    }

    public static <T, R, E extends Throwable> int[] unsafeTransformToIntArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return (int[])TransformUtil._unsafeTransformToPrimitiveArray(collection, unsafeFunction, int[].class);
    }

    public static <T, E extends Throwable> int[] unsafeTransformToIntArray(T[] array, UnsafeFunction<T, Integer, E> unsafeFunction) throws E {
        return (int[])TransformUtil._unsafeTransformToPrimitiveArray(array, unsafeFunction, int[].class);
    }

    public static <R, E extends Throwable> List<R> unsafeTransformToList(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction) throws E {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<R> list = new ArrayList<R>(array.length);
        int[] nArray = array;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer item = nArray[i];
            R newItem = unsafeFunction.apply(item);
            if (newItem == null) continue;
            list.add(newItem);
        }
        return list;
    }

    public static <R, E extends Throwable> List<R> unsafeTransformToList(long[] array, UnsafeFunction<Long, R, E> unsafeFunction) throws E {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<R> list = new ArrayList<R>(array.length);
        long[] lArray = array;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long item = lArray[i];
            R newItem = unsafeFunction.apply(item);
            if (newItem == null) continue;
            list.add(newItem);
        }
        return list;
    }

    public static <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<R> list = new ArrayList<R>(array.length);
        for (T item : array) {
            R newItem = unsafeFunction.apply(item);
            if (newItem == null) continue;
            list.add(newItem);
        }
        return list;
    }

    public static <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return (long[])TransformUtil._unsafeTransformToPrimitiveArray(collection, unsafeFunction, long[].class);
    }

    public static <T, E extends Throwable> long[] unsafeTransformToLongArray(T[] array, UnsafeFunction<T, Long, E> unsafeFunction) throws E {
        return (long[])TransformUtil._unsafeTransformToPrimitiveArray(array, unsafeFunction, long[].class);
    }

    public static <T, E extends Throwable> short[] unsafeTransformToShortArray(Collection<T> collection, UnsafeFunction<T, Short, E> unsafeFunction) throws E {
        return (short[])TransformUtil._unsafeTransformToPrimitiveArray(collection, unsafeFunction, short[].class);
    }

    public static <T, E extends Throwable> short[] unsafeTransformToShortArray(T[] array, UnsafeFunction<T, Short, E> unsafeFunction) throws E {
        return (short[])TransformUtil._unsafeTransformToPrimitiveArray(array, unsafeFunction, short[].class);
    }

    private static <T, R, E extends Throwable> Object _unsafeTransformToPrimitiveArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        List<R> list = TransformUtil.unsafeTransform(collection, unsafeFunction);
        Object array = clazz.cast(Array.newInstance(clazz.getComponentType(), list.size()));
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    private static <T, R, E extends Throwable> Object _unsafeTransformToPrimitiveArray(T[] array1, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        Object array2 = clazz.cast(Array.newInstance(clazz.getComponentType(), array1.length));
        for (int i = 0; i < array1.length; ++i) {
            Array.set(array2, i, unsafeFunction.apply(array1[i]));
        }
        return array2;
    }
}

