/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.concurrent;

import com.liferay.petra.concurrent.BaseNoticeableExecutorService;
import com.liferay.petra.concurrent.DefaultNoticeableFuture;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NoticeableThreadPoolExecutor
extends BaseNoticeableExecutorService {
    private final ThreadPoolExecutor _dispatcherThreadPoolExecutor;
    private final List<Runnable> _shutdownTasks = new ArrayList<Runnable>();
    private final DefaultNoticeableFuture<Void> _terminationDefaultNoticeableFuture;
    private final ThreadPoolExecutor _workerThreadPoolExecutor;

    public NoticeableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler, final ThreadPoolHandler threadPoolHandler) {
        if (corePoolSize < 1) {
            throw new IllegalArgumentException("To ensure FIFO, core pool size must be 1 or greater");
        }
        final AtomicInteger terminationCounter = new AtomicInteger(2);
        this._terminationDefaultNoticeableFuture = new DefaultNoticeableFuture<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }
        };
        this._terminationDefaultNoticeableFuture.addFutureListener(future -> threadPoolHandler.terminated());
        this._workerThreadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, new SynchronousQueue(), threadFactory, (runnable, threadPoolExecutor) -> {
            if (threadPoolExecutor.isShutdown()) {
                rejectedExecutionHandler.rejectedExecution(runnable, threadPoolExecutor);
                return;
            }
            BlockingQueue<Runnable> taskQueue = threadPoolExecutor.getQueue();
            try {
                taskQueue.put(runnable);
            }
            catch (InterruptedException interruptedException) {
                rejectedExecutionHandler.rejectedExecution(runnable, threadPoolExecutor);
            }
        }){

            @Override
            protected void afterExecute(Runnable runnable, Throwable throwable) {
                threadPoolHandler.afterExecute(runnable, throwable);
            }

            @Override
            protected void beforeExecute(Thread thread, Runnable runnable) {
                threadPoolHandler.beforeExecute(thread, runnable);
            }

            @Override
            protected void terminated() {
                if (terminationCounter.decrementAndGet() == 0) {
                    NoticeableThreadPoolExecutor.this._terminationDefaultNoticeableFuture.run();
                }
            }
        };
        this._dispatcherThreadPoolExecutor = new ThreadPoolExecutor(1, 1, keepAliveTime, timeUnit, blockingQueue, runnable -> {
            Thread thread = threadFactory.newThread(runnable);
            thread.setName(thread.getName() + "-dispatcher");
            return thread;
        }, (runnable, threadPoolExecutor) -> {
            DispatchRunnable dispatchRunnable = (DispatchRunnable)runnable;
            rejectedExecutionHandler.rejectedExecution(dispatchRunnable.getRunnable(), threadPoolExecutor);
        }){

            @Override
            public void execute(Runnable runnable) {
                super.execute(new DispatchRunnable(NoticeableThreadPoolExecutor.this._workerThreadPoolExecutor, runnable));
            }

            @Override
            protected void terminated() {
                if (terminationCounter.decrementAndGet() == 0) {
                    NoticeableThreadPoolExecutor.this._terminationDefaultNoticeableFuture.run();
                }
            }
        };
        this._dispatcherThreadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        if (!this._dispatcherThreadPoolExecutor.awaitTermination(timeout, timeUnit)) {
            return false;
        }
        return this._workerThreadPoolExecutor.awaitTermination(timeout -= timeUnit.convert(System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS), timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("Runnable is null");
        }
        this._dispatcherThreadPoolExecutor.execute(runnable);
    }

    public int getActiveCount() {
        return this._workerThreadPoolExecutor.getActiveCount();
    }

    public long getCompletedTaskCount() {
        return this._workerThreadPoolExecutor.getCompletedTaskCount();
    }

    public int getCorePoolSize() {
        return this._workerThreadPoolExecutor.getCorePoolSize();
    }

    public int getLargestPoolSize() {
        return this._workerThreadPoolExecutor.getLargestPoolSize();
    }

    public int getMaximumPoolSize() {
        return this._workerThreadPoolExecutor.getMaximumPoolSize();
    }

    public int getPendingTaskCount() {
        BlockingQueue<Runnable> dispatcherBlockingQueue = this._dispatcherThreadPoolExecutor.getQueue();
        return dispatcherBlockingQueue.size();
    }

    public int getPoolSize() {
        return this._workerThreadPoolExecutor.getPoolSize();
    }

    @Override
    public boolean isShutdown() {
        return this._dispatcherThreadPoolExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this._dispatcherThreadPoolExecutor.isTerminated() || this._workerThreadPoolExecutor.isTerminated();
    }

    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 1) {
            throw new IllegalArgumentException("To ensure FIFO, core pool size must be 1 or greater");
        }
        this._workerThreadPoolExecutor.setCorePoolSize(corePoolSize);
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this._workerThreadPoolExecutor.setMaximumPoolSize(maximumPoolSize);
    }

    @Override
    public synchronized void shutdown() {
        this._shutdownTasks.addAll(this._dispatcherThreadPoolExecutor.shutdownNow());
        this._workerThreadPoolExecutor.shutdown();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this._shutdownTasks.addAll(this._dispatcherThreadPoolExecutor.shutdownNow());
        this._workerThreadPoolExecutor.shutdownNow();
        ArrayList<Runnable> shutdownTasks = new ArrayList<Runnable>(this._shutdownTasks);
        this._shutdownTasks.clear();
        return shutdownTasks;
    }

    @Override
    public NoticeableFuture<Void> terminationNoticeableFuture() {
        return this._terminationDefaultNoticeableFuture;
    }

    private static class DispatchRunnable
    implements Runnable {
        private final Runnable _runnable;
        private final ThreadPoolExecutor _workerThreadPoolExecutor;

        public Runnable getRunnable() {
            return this._runnable;
        }

        @Override
        public void run() {
            this._workerThreadPoolExecutor.execute(this._runnable);
        }

        private DispatchRunnable(ThreadPoolExecutor workerThreadPoolExecutor, Runnable runnable) {
            this._workerThreadPoolExecutor = workerThreadPoolExecutor;
            this._runnable = runnable;
        }
    }
}

