/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osb.spring.boot.client.zendesk.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZendeskTicket {
    public static final String STATUS_CLOSED = "closed";
    private final Map<Long, String> _customFields;
    private final long _requesterId;
    private final String _status;
    private final String _subject;
    private final Set<String> _tags;
    private final long _zendeskOrganizationId;
    private final long _zendeskTicketId;
    private final String _zendeskURL;

    public ZendeskTicket(JSONObject jsonObject, String zendeskURL) {
        this._zendeskURL = zendeskURL;
        HashMap<Long, String> customFields = new HashMap<Long, String>();
        JSONArray customFieldsJSONArray = jsonObject.getJSONArray("custom_fields");
        if (customFieldsJSONArray != null) {
            for (int i = 0; i < customFieldsJSONArray.length(); ++i) {
                JSONObject customFieldJSONObject = customFieldsJSONArray.getJSONObject(i);
                customFields.put(customFieldJSONObject.getLong("id"), customFieldJSONObject.optString("value"));
            }
        }
        this._customFields = customFields;
        this._requesterId = jsonObject.getLong("requester_id");
        this._status = jsonObject.getString("status");
        this._subject = jsonObject.getString("subject");
        HashSet<String> tags = new HashSet<String>();
        JSONArray tagsJSONArray = jsonObject.getJSONArray("tags");
        if (tagsJSONArray != null) {
            for (int i = 0; i < tagsJSONArray.length(); ++i) {
                tags.add(tagsJSONArray.getString(i));
            }
        }
        this._tags = tags;
        this._zendeskOrganizationId = jsonObject.getLong("organization_id");
        this._zendeskTicketId = jsonObject.getLong("id");
    }

    public Map<Long, String> getCustomFields() {
        return this._customFields;
    }

    public long getRequesterId() {
        return this._requesterId;
    }

    public String getStatus() {
        return this._status;
    }

    public String getSubject() {
        return this._subject;
    }

    public Set<String> getTags() {
        return this._tags;
    }

    public long getZendeskOrganizationId() {
        return this._zendeskOrganizationId;
    }

    public long getZendeskTicketId() {
        return this._zendeskTicketId;
    }

    public boolean isClosed() {
        return this._status.equals(STATUS_CLOSED);
    }

    public JSONObject toJSONObject() {
        return new JSONObject().put("link", (Object)(this._zendeskURL + "/requests/" + this._zendeskTicketId)).put("status", (Object)this._status).put("subject", (Object)this._subject).put("ticketId", this._zendeskTicketId);
    }
}

