/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectView;
import com.liferay.object.model.ObjectViewColumn;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.model.ObjectViewSortColumn;
import com.liferay.object.service.base.ObjectViewServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectView"}, service={AopService.class})
public class ObjectViewServiceImpl
extends ObjectViewServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;

    public ObjectView addObjectView(long objectDefinitionId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns, List<ObjectViewFilterColumn> objectViewFilterColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinition.getObjectDefinitionId(), "UPDATE");
        return this.objectViewLocalService.addObjectView(this.getUserId(), objectDefinitionId, defaultObjectView, nameMap, objectViewColumns, objectViewFilterColumns, objectViewSortColumns);
    }

    public ObjectView deleteObjectView(long objectViewId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectView.getObjectDefinitionId(), "DELETE");
        return this.objectViewLocalService.deleteObjectView(objectViewId);
    }

    public ObjectView getObjectView(long objectViewId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectView.getObjectDefinitionId(), "VIEW");
        return this.objectViewLocalService.getObjectView(objectViewId);
    }

    public ObjectView updateObjectView(long objectViewId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns, List<ObjectViewFilterColumn> objectViewFilterColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectView.getObjectDefinitionId(), "UPDATE");
        return this.objectViewLocalService.updateObjectView(objectViewId, defaultObjectView, nameMap, objectViewColumns, objectViewFilterColumns, objectViewSortColumns);
    }
}

