/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectFolder;
import com.liferay.object.service.base.ObjectFolderServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectFolder"}, service={AopService.class})
public class ObjectFolderServiceImpl
extends ObjectFolderServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectFolder)")
    private ModelResourcePermission<ObjectFolder> _objectFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.object)")
    private PortletResourcePermission _portletResourcePermission;

    public ObjectFolder addObjectFolder(String externalReferenceCode, Map<Locale, String> labelMap, String name) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_OBJECT_FOLDER");
        return this.objectFolderLocalService.addObjectFolder(externalReferenceCode, this.getUserId(), labelMap, name);
    }

    public ObjectFolder deleteObjectFolder(long objectFolderId) throws PortalException {
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "DELETE");
        return this.objectFolderLocalService.deleteObjectFolder(objectFolderId);
    }

    public ObjectFolder getObjectFolder(long objectFolderId) throws PortalException {
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "VIEW");
        return this.objectFolderLocalService.getObjectFolder(objectFolderId);
    }

    public ObjectFolder getObjectFolderByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        ObjectFolder objectFolder = this.objectFolderLocalService.getObjectFolderByExternalReferenceCode(externalReferenceCode, companyId);
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)objectFolder, "VIEW");
        return objectFolder;
    }

    public ObjectFolder updateObjectFolder(String externalReferenceCode, long objectFolderId, Map<Locale, String> labelMap) throws PortalException {
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "UPDATE");
        return this.objectFolderLocalService.updateObjectFolder(externalReferenceCode, objectFolderId, labelMap);
    }
}

