/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.base.ObjectActionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectAction"}, service={AopService.class})
public class ObjectActionServiceImpl
extends ObjectActionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;

    public ObjectAction addObjectAction(String externalReferenceCode, long objectDefinitionId, boolean active, String conditionExpression, String description, Map<Locale, String> errorMessageMap, Map<Locale, String> labelMap, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties, boolean system) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "UPDATE");
        return this.objectActionLocalService.addObjectAction(externalReferenceCode, this.getUserId(), objectDefinitionId, active, conditionExpression, description, errorMessageMap, labelMap, name, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties, system);
    }

    public ObjectAction deleteObjectAction(long objectActionId) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectAction.getObjectDefinitionId(), "UPDATE");
        return this.objectActionLocalService.deleteObjectAction(objectAction);
    }

    public ObjectAction getObjectAction(long objectActionId) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectAction.getObjectDefinitionId(), "VIEW");
        return this.objectActionLocalService.getObjectAction(objectActionId);
    }

    public ObjectAction updateObjectAction(String externalReferenceCode, long objectActionId, boolean active, String conditionExpression, String description, Map<Locale, String> errorMessageMap, Map<Locale, String> labelMap, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectAction.getObjectDefinitionId(), "UPDATE");
        return this.objectActionLocalService.updateObjectAction(externalReferenceCode, objectActionId, active, conditionExpression, description, errorMessageMap, labelMap, name, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
    }
}

