/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v3_9_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.Map;

public class ObjectViewColumnUpgradeProcess
extends UpgradeProcess {
    private final Map<String, String> _labelKeys = HashMapBuilder.put((Object)"creator", (Object)"author").put((Object)"dateCreated", (Object)"created-date").put((Object)"dateModified", (Object)"modified-date").put((Object)"id", (Object)"id").put((Object)"status", (Object)"workflow-status[object]").build();

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select objectViewColumnId, companyId, objectFieldName from ObjectViewColumn where label is null");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update ObjectViewColumn set label = ? where objectViewColumnId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId));
                String key = this._labelKeys.get(resultSet.getString("objectFieldName"));
                preparedStatement2.setString(1, LocalizationUtil.updateLocalization((Map)HashMapBuilder.put((Object)defaultLocale, (Object)LanguageUtil.get((Locale)defaultLocale, (String)key)).build(), (String)"", (String)"Label", (String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId)));
                preparedStatement2.setLong(2, resultSet.getLong("objectViewColumnId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

