/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.system.info.item.provider;

import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.ERCInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.provider.BaseInfoItemObjectProvider;
import com.liferay.object.entry.util.ObjectEntryDTOConverterUtil;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import java.util.Collections;
import java.util.Map;

public class SystemObjectEntryInfoItemObjectProvider
extends BaseInfoItemObjectProvider<SystemObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(SystemObjectEntryInfoItemObjectProvider.class);
    private final DTOConverterRegistry _dtoConverterRegistry;
    private final SystemObjectDefinitionManager _systemObjectDefinitionManager;

    public SystemObjectEntryInfoItemObjectProvider(DTOConverterRegistry dtoConverterRegistry, SystemObjectDefinitionManager systemObjectDefinitionManager) {
        this._dtoConverterRegistry = dtoConverterRegistry;
        this._systemObjectDefinitionManager = systemObjectDefinitionManager;
    }

    protected SystemObjectEntry doGetInfoItem(long groupId, InfoItemIdentifier infoItemIdentifier) throws NoSuchInfoItemException {
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier) && !(infoItemIdentifier instanceof ERCInfoItemIdentifier)) {
            throw new NoSuchInfoItemException("Unsupported info item identifier " + String.valueOf(infoItemIdentifier));
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (infoItemIdentifier instanceof ClassPKInfoItemIdentifier) {
            ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
            try {
                if (themeDisplay == null) {
                    return new SystemObjectEntry(classPKInfoItemIdentifier.getClassPK(), "", Collections.emptyMap());
                }
                DTOConverter dtoConverter = ObjectEntryDTOConverterUtil.getDTOConverter((DTOConverterRegistry)this._dtoConverterRegistry, (SystemObjectDefinitionManager)this._systemObjectDefinitionManager);
                Object dto = dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(false, Collections.emptyMap(), this._dtoConverterRegistry, (Object)classPKInfoItemIdentifier.getClassPK(), themeDisplay.getLocale(), null, themeDisplay.getUser()));
                if (dto == null) {
                    return new SystemObjectEntry(classPKInfoItemIdentifier.getClassPK(), "", Collections.emptyMap());
                }
                return new SystemObjectEntry(classPKInfoItemIdentifier.getClassPK(), "", (Map)ObjectMapperUtil.readValue(Map.class, (String)dto.toString()));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                throw new NoSuchInfoItemException("Unable to get info item for " + classPKInfoItemIdentifier.getClassPK());
            }
        }
        ERCInfoItemIdentifier ercInfoItemIdentifier = (ERCInfoItemIdentifier)infoItemIdentifier;
        try {
            Object dto = ObjectEntryDTOConverterUtil.toDTO((BaseModel)this._systemObjectDefinitionManager.getBaseModelByExternalReferenceCode(ercInfoItemIdentifier.getExternalReferenceCode(), serviceContext.getCompanyId()), (DTOConverterRegistry)this._dtoConverterRegistry, (SystemObjectDefinitionManager)this._systemObjectDefinitionManager, (User)themeDisplay.getUser());
            return new SystemObjectEntry(0L, ercInfoItemIdentifier.getExternalReferenceCode(), (Map)ObjectMapperUtil.readValue(Map.class, (String)dto.toString()));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new NoSuchInfoItemException(StringBundler.concat((Object[])new Object[]{"No info item found with company ID ", serviceContext.getCompanyId(), " and external reference code ", ercInfoItemIdentifier.getExternalReferenceCode()}), (Throwable)exception);
        }
    }
}

