/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectDefinitionTable;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldTable;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.model.ObjectFolderTable;
import com.liferay.object.model.bag.ObjectFieldBag;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.ReindexCacheThreadLocal;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.IndexerWriterMode;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectEntryModelIndexerWriterContributor
implements ModelIndexerWriterContributor<ObjectEntry> {
    private final long _companyId;
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    private final Long _objectDefinitionId;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectFolderLocalService _objectFolderLocalService;

    public ObjectEntryModelIndexerWriterContributor(DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectFolderLocalService objectFolderLocalService) {
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectFolderLocalService = objectFolderLocalService;
        this._companyId = objectDefinition.getCompanyId();
        this._objectDefinitionId = objectDefinition.getObjectDefinitionId();
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property objectDefinitionIdProperty = PropertyFactoryUtil.forName((String)"objectDefinitionId");
            dynamicQuery.add(objectDefinitionIdProperty.eq((Object)this._objectDefinitionId));
        });
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(this._objectDefinitionId.longValue());
        this._initObjectDefinition(objectDefinition);
        batchIndexingActionable.setPerformActionMethod(objectEntry -> {
            objectEntry.setObjectDefinition(objectDefinition);
            batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)objectEntry)});
        });
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._objectEntryLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(ObjectEntry objectEntry) {
        return objectEntry.getCompanyId();
    }

    public IndexerWriterMode getIndexerWriterMode(ObjectEntry objectEntry) {
        return IndexerWriterMode.UPDATE;
    }

    public boolean shouldRun(long companyId) {
        return this._companyId == companyId;
    }

    private void _initObjectDefinition(ObjectDefinition objectDefinition) {
        Map objectFieldsMap;
        Map objectFolders = (Map)ReindexCacheThreadLocal.getGlobalReindexCache(() -> -1, (String)(ObjectEntryModelIndexerWriterContributor.class.getName() + "#ObjectFolder"), count -> {
            HashMap<Long, ObjectFolder> localObjectFolders = new HashMap<Long, ObjectFolder>();
            for (ObjectFolder objectFolder : (List)this._objectFolderLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)ObjectFolderTable.INSTANCE).from((Table)ObjectFolderTable.INSTANCE).innerJoinON((Table)ObjectDefinitionTable.INSTANCE, ObjectFolderTable.INSTANCE.objectFolderId.eq((Expression)ObjectDefinitionTable.INSTANCE.objectFolderId)), false)) {
                localObjectFolders.put(objectFolder.getObjectFolderId(), objectFolder);
            }
            return localObjectFolders;
        });
        if (objectFolders != null) {
            objectDefinition.setObjectFolder((ObjectFolder)objectFolders.get(objectDefinition.getObjectFolderId()));
        }
        if ((objectFieldsMap = (Map)ReindexCacheThreadLocal.getGlobalReindexCache(() -> -1, (String)(ObjectEntryModelIndexerWriterContributor.class.getName() + "#ObjectFields"), count -> {
            HashMap<Long, List> localObjectFieldsMap = new HashMap<Long, List>();
            for (ObjectField objectField : (List)this._objectFieldLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)ObjectFieldTable.INSTANCE).from((Table)ObjectFieldTable.INSTANCE), false)) {
                List objectFields = localObjectFieldsMap.computeIfAbsent(objectField.getObjectDefinitionId(), key -> new ArrayList());
                objectFields.add(objectField);
            }
            return localObjectFieldsMap;
        })) != null) {
            objectDefinition.setObjectFieldBag(new ObjectFieldBag(objectFieldsMap.getOrDefault(objectDefinition.getObjectDefinitionId(), Collections.emptyList())));
        }
    }
}

