/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.model.AccountEntryOrganizationRelTable;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryTable;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.model.bag.ObjectFieldBag;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.base.BaseTable;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.kernel.search.ReindexCacheThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParserUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.ml.embedding.text.TextEmbeddingDocumentContributor;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class ObjectEntryModelDocumentContributor
implements ModelDocumentContributor<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelDocumentContributor.class);
    private static final Format _format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    private final TextEmbeddingDocumentContributor _textEmbeddingDocumentContributor;

    public ObjectEntryModelDocumentContributor(AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, DLFileEntryLocalService dlFileEntryLocalService, ObjectEntryFolderLocalService objectEntryFolderLocalService, TextEmbeddingDocumentContributor textEmbeddingDocumentContributor) {
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._objectEntryFolderLocalService = objectEntryFolderLocalService;
        this._textEmbeddingDocumentContributor = textEmbeddingDocumentContributor;
    }

    public void contribute(Document document, ObjectEntry objectEntry) {
        block2: {
            try {
                this._contribute(document, objectEntry);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to index object entry " + objectEntry.getObjectEntryId()), (Throwable)exception);
            }
        }
    }

    private void _addField(FieldArray fieldArray, String fieldName, String valueFieldName, String value) {
        Field field = new Field("");
        field.addField(new Field("fieldName", fieldName));
        field.addField(new Field("valueFieldName", valueFieldName));
        field.addField(new Field(valueFieldName, value));
        fieldArray.addField(field);
    }

    private void _appendToContent(ObjectContentHelper objectContentHelper, String locale, String objectFieldName, String valueString) {
        StringBundler sb = new StringBundler(4);
        sb.append(objectFieldName);
        sb.append(": ");
        sb.append(valueString);
        sb.append(", ");
        if (locale != null) {
            objectContentHelper.contributeToLocale(locale, sb);
        } else {
            objectContentHelper.contributeToAll(sb);
        }
    }

    private void _contribute(Document document, FieldArray fieldArray, String fieldName, Object fieldValue, String locale, ObjectContentHelper objectContentHelper, ObjectDefinition objectDefinition, ObjectEntry objectEntry, ObjectField objectField) {
        if (!objectField.isIndexed()) {
            return;
        }
        if (fieldValue == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Object entry ", objectEntry.getObjectEntryId(), " has object field \"", objectField.getName(), "\" with a null value"}));
            }
            return;
        }
        if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Attachment")) {
            fieldValue = this._getFileName(GetterUtil.getLong((Object)fieldValue), objectDefinition);
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"RichText")) {
            fieldValue = HtmlParserUtil.extractText((String)GetterUtil.getString((Object)fieldValue));
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"MultiselectPicklist") && fieldValue instanceof List) {
            fieldValue = ListUtil.toString((List)((List)fieldValue), (String)null, (String)", ");
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Picklist") && fieldValue instanceof ListEntry) {
            ListEntry listEntry = (ListEntry)fieldValue;
            fieldValue = listEntry.getKey();
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"PrecisionDecimal")) {
            fieldValue = BigDecimalUtil.stripTrailingZeros((BigDecimal)((BigDecimal)fieldValue));
        } else if (Objects.equals(objectDefinition.getAccountEntryRestrictedObjectFieldId(), objectField.getObjectFieldId())) {
            Long accountEntryId = (Long)fieldValue;
            document.addKeyword("accountEntryRestrictedObjectFieldValue", accountEntryId);
            document.addKeyword("accountEntryRestrictedOrganizationIds", this._getOrganizationIds(accountEntryId));
        }
        String valueString = String.valueOf(fieldValue);
        if (objectField.isIndexedAsKeyword()) {
            this._addField(fieldArray, fieldName, "value_keyword", StringUtil.lowerCase((String)valueString));
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof BigDecimal) {
            this._addField(fieldArray, fieldName, "value_double", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Boolean) {
            this._addField(fieldArray, fieldName, "value_boolean", valueString);
            this._addField(fieldArray, fieldName, "value_keyword", this._translate((Boolean)fieldValue));
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Date) {
            this._addField(fieldArray, fieldName, "value_date", this._getDateString(fieldValue));
            this._appendToContent(objectContentHelper, locale, fieldName, this._getDateString(fieldValue));
        } else if (fieldValue instanceof Double) {
            this._addField(fieldArray, fieldName, "value_double", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Integer) {
            this._addField(fieldArray, fieldName, "value_integer", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Long) {
            this._addField(fieldArray, fieldName, "value_long", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof String) {
            if (Validator.isBlank((String)objectField.getIndexedLanguageId())) {
                this._addField(fieldArray, fieldName, "value_text", valueString);
            } else if (objectField.isLocalized()) {
                this._addField(fieldArray, fieldName, "value_" + locale, valueString);
            } else {
                this._addField(fieldArray, fieldName, "value_" + objectField.getIndexedLanguageId(), valueString);
            }
            this._addField(fieldArray, fieldName, "value_keyword_lowercase", this._getSortableValue(valueString));
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof byte[]) {
            this._addField(fieldArray, fieldName, "value_binary", Base64.encode((byte[])((byte[])fieldValue)));
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Object entry ", objectEntry.getObjectEntryId(), " has object field \"", fieldName, "\" with unsupported value ", fieldValue}));
        }
    }

    private void _contribute(Document document, ObjectEntry objectEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + String.valueOf(document)));
            _log.debug((Object)("Object entry " + String.valueOf(objectEntry)));
        }
        document.add(new Field(Field.getSortableFieldName((String)"entryClassPK"), document.get("entryClassPK")));
        FieldArray fieldArray = (FieldArray)document.getField("nestedFieldArray");
        if (fieldArray == null) {
            fieldArray = new FieldArray("nestedFieldArray");
            document.add((Field)fieldArray);
        }
        document.addKeyword("objectDefinitionId", objectEntry.getObjectDefinitionId());
        ObjectDefinition objectDefinition = objectEntry.getObjectDefinition();
        document.addKeyword("objectDefinitionName", objectDefinition.getShortName());
        ObjectFieldBag objectFieldBag = objectDefinition.getObjectFieldBag();
        List objectFields = null;
        objectFields = objectDefinition.isModifiableAndSystem() ? ListUtil.filter((List)objectFieldBag.getIndexedObjectFields(), objectField -> !objectField.isMetadata()) : objectFieldBag.getNonsystemIndexedObjectFields();
        ObjectContentHelper objectContentHelper = null;
        Map values = null;
        if (!objectFields.isEmpty()) {
            values = objectEntry.getIndexedValues();
            objectContentHelper = new ObjectContentHelper(objectEntry, objectFields, this._textEmbeddingDocumentContributor);
            for (ObjectField objectField2 : objectFields) {
                if (objectField2.isLocalized()) {
                    Map localizedValues = (Map)values.get(objectField2.getI18nObjectFieldName());
                    if (MapUtil.isEmpty((Map)localizedValues)) continue;
                    for (Map.Entry entry : localizedValues.entrySet()) {
                        this._contribute(document, fieldArray, objectField2.getName(), entry.getValue(), (String)entry.getKey(), objectContentHelper, objectDefinition, objectEntry, objectField2);
                    }
                    continue;
                }
                this._contribute(document, fieldArray, objectField2.getName(), values.get(objectField2.getName()), null, objectContentHelper, objectDefinition, objectEntry, objectField2);
            }
            objectContentHelper.trim();
            document.add(new Field("objectEntryContent", objectContentHelper.getContent()));
        }
        document.addKeyword("objectEntryId", objectEntry.getObjectEntryId());
        document.add(new Field("objectEntryTitle", objectEntry.getTitleValue()));
        ObjectFolder objectFolder = objectDefinition.getObjectFolder();
        document.addKeyword("objectFolderExternalReferenceCode", objectFolder.getExternalReferenceCode(), true);
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPD-17564")) {
            long fileEntryId;
            this._contributeObjectEntryFolder(document, objectEntry.getObjectEntryFolderId());
            if (values == null) {
                values = objectEntry.getIndexedValues();
            }
            if ((fileEntryId = GetterUtil.getLong(values.get("file"))) != 0L) {
                this._contributeFile(document, fileEntryId);
            }
        }
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPS-122920")) {
            this._contributeTextEmbeddings(document, objectContentHelper, objectEntry);
        }
    }

    private void _contributeFile(Document document, long fileEntryId) {
        DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.fetchDLFileEntry((long)fileEntryId);
        if (fileEntry != null) {
            document.addKeyword("extension", fileEntry.getExtension());
        }
    }

    private void _contributeObjectEntryFolder(Document document, long objectEntryFolderId) {
        document.addKeyword("folderId", objectEntryFolderId);
        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.fetchObjectEntryFolder(objectEntryFolderId);
        if (objectEntryFolder == null) {
            return;
        }
        ObjectEntryFolder rootObjectEntryFolder = this._getRootObjectEntryFolder(objectEntryFolder);
        if (rootObjectEntryFolder == null) {
            return;
        }
        String cmsSection = this._getCMSSection(rootObjectEntryFolder.getExternalReferenceCode());
        if (cmsSection == null) {
            return;
        }
        document.addKeyword("cms_kind", "object");
        document.addKeyword("cms_root", rootObjectEntryFolder.getObjectEntryFolderId() == objectEntryFolderId);
        document.addKeyword("cms_section", cmsSection);
    }

    private void _contributeTextEmbeddings(Document document, ObjectContentHelper objectContentHelper, ObjectEntry objectEntry) {
        if (objectContentHelper == null) {
            return;
        }
        Map<String, String> localizedContentMap = objectContentHelper.getLocalizedContentMap();
        for (Map.Entry<String, String> localizedContent : localizedContentMap.entrySet()) {
            this._textEmbeddingDocumentContributor.contribute(document, localizedContent.getKey(), (BaseModel)objectEntry, localizedContent.getValue());
        }
    }

    private String _getCMSSection(String externalReferenceCode) {
        if (externalReferenceCode.equals("L_CONTENTS")) {
            return "contents";
        }
        if (externalReferenceCode.equals("L_FILES")) {
            return "files";
        }
        return null;
    }

    private String _getDateString(Object value) {
        return _format.format(value);
    }

    private String _getFileName(long dlFileEntryId, ObjectDefinition objectDefinition) {
        if (dlFileEntryId == 0L) {
            return "";
        }
        Map fileNames = (Map)ReindexCacheThreadLocal.getScopeReindexCache((String)(ObjectEntryModelDocumentContributor.class.getName() + "#_getFileName"), (String)String.valueOf(objectDefinition.getObjectDefinitionId()), () -> -1, () -> -1, count -> {
            HashMap<Long, String> localFileNames = new HashMap<Long, String>();
            ObjectFieldBag objectFieldBag = objectDefinition.getObjectFieldBag();
            for (ObjectField objectField2 : ListUtil.filter((List)objectFieldBag.getIndexedObjectFields(), objectField -> objectField.compareBusinessType("Attachment"))) {
                ObjectFieldTable objectFieldTable = new ObjectFieldTable(objectField2);
                for (Object[] values : (List)this._dlFileEntryLocalService.dslQuery(objectFieldTable.buildDSLQuery(), false)) {
                    localFileNames.put((Long)values[0], (String)values[1]);
                }
            }
            return localFileNames;
        });
        if (fileNames == null) {
            DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchDLFileEntry((long)dlFileEntryId);
            if (dlFileEntry != null) {
                return dlFileEntry.getFileName();
            }
            return "";
        }
        return fileNames.getOrDefault(dlFileEntryId, "");
    }

    private long[] _getOrganizationIds(Long accountEntryId) {
        Map organizationIdsMap = (Map)ReindexCacheThreadLocal.getGlobalReindexCache(() -> -1, (String)(ObjectEntryModelDocumentContributor.class.getName() + "#_getOrganizationIds"), count -> {
            HashMap<Long, List> organizationIdListMap = new HashMap<Long, List>();
            for (Object[] values : (List)this._accountEntryOrganizationRelLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{AccountEntryOrganizationRelTable.INSTANCE.accountEntryId, AccountEntryOrganizationRelTable.INSTANCE.organizationId}).from((Table)AccountEntryOrganizationRelTable.INSTANCE), false)) {
                List organizationIds = organizationIdListMap.computeIfAbsent((Long)values[0], key -> new ArrayList());
                organizationIds.add((Long)values[1]);
            }
            HashMap<Long, long[]> localOrganizationIdsMap = new HashMap<Long, long[]>();
            for (Map.Entry entry : organizationIdListMap.entrySet()) {
                localOrganizationIdsMap.put((Long)entry.getKey(), ArrayUtil.toLongArray((Collection)((Collection)entry.getValue())));
            }
            return localOrganizationIdsMap;
        });
        if (organizationIdsMap == null) {
            return ListUtil.toLongArray((List)this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId.longValue()), AccountEntryOrganizationRelModel::getOrganizationId);
        }
        return (long[])organizationIdsMap.get(accountEntryId);
    }

    private ObjectEntryFolder _getRootObjectEntryFolder(ObjectEntryFolder objectEntryFolder) {
        if (objectEntryFolder == null) {
            return null;
        }
        if (Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_CONTENTS") || Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_FILES")) {
            return objectEntryFolder;
        }
        String[] parts = StringUtil.split((String)objectEntryFolder.getTreePath(), (char)'/');
        if (parts.length <= 2) {
            return null;
        }
        return this._objectEntryFolderLocalService.fetchObjectEntryFolder(GetterUtil.getLong((String)parts[1]));
    }

    private String _getSortableValue(String value) {
        if (value.length() > 256) {
            return value.substring(0, 256);
        }
        return value;
    }

    private String _translate(Boolean value) {
        if (value.booleanValue()) {
            return "yes";
        }
        return "no";
    }

    private static class ObjectContentHelper {
        private final StringBundler _contentSB;
        private final Map<String, StringBundler> _localizedContentSBMap = new TreeMap<String, StringBundler>();

        public void contributeToAll(StringBundler sb) {
            this._contentSB.append(sb);
            for (StringBundler localizedContentSB : this._localizedContentSBMap.values()) {
                localizedContentSB.append(sb);
            }
        }

        public void contributeToLocale(String locale, StringBundler sb) {
            this._contentSB.append(sb);
            StringBundler localizedContentSB = this._localizedContentSBMap.get(locale);
            if (localizedContentSB != null) {
                localizedContentSB.append(sb);
            }
        }

        public String getContent() {
            return this._contentSB.toString();
        }

        public Map<String, String> getLocalizedContentMap() {
            if (this._localizedContentSBMap.isEmpty()) {
                return Collections.emptyMap();
            }
            TreeMap<String, String> localizedContentMap = new TreeMap<String, String>();
            for (Map.Entry<String, StringBundler> localizedContentEntry : this._localizedContentSBMap.entrySet()) {
                StringBundler sb = localizedContentEntry.getValue();
                if (sb.index() <= 0) continue;
                localizedContentMap.put(localizedContentEntry.getKey(), sb.toString());
            }
            return localizedContentMap;
        }

        public void trim() {
            if (this._contentSB.index() > 0) {
                this._contentSB.setIndex(this._contentSB.index() - 1);
            }
            for (StringBundler localizedContentSB : this._localizedContentSBMap.values()) {
                if (localizedContentSB.index() <= 0) continue;
                localizedContentSB.setIndex(localizedContentSB.index() - 1);
            }
        }

        private ObjectContentHelper(ObjectEntry objectEntry, List<ObjectField> objectFields, TextEmbeddingDocumentContributor textEmbeddingDocumentContributor) {
            this._contentSB = new StringBundler(objectFields.size());
            if (!FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPS-122920")) {
                return;
            }
            for (String languageId : textEmbeddingDocumentContributor.getLanguageIds((BaseModel)objectEntry)) {
                this._localizedContentSBMap.put(languageId, new StringBundler(objectFields.size() * 4));
            }
        }
    }

    private static class ObjectFieldTable
    extends BaseTable<ObjectFieldTable> {
        private final Column<ObjectFieldTable, Long> _column;

        public DSLQuery buildDSLQuery() {
            return DSLQueryFactoryUtil.select((Expression[])new Expression[]{DLFileEntryTable.INSTANCE.fileEntryId, DLFileEntryTable.INSTANCE.fileName}).from((Table)DLFileEntryTable.INSTANCE).innerJoinON((Table)this, DLFileEntryTable.INSTANCE.fileEntryId.eq(this._column));
        }

        private ObjectFieldTable(ObjectField objectField) {
            super(objectField.getDBTableName(), () -> null);
            this._column = this.createColumn(objectField.getDBColumnName(), Long.class, -5, 0);
        }
    }
}

