/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.instance.lifecycle;

import com.liferay.asset.list.model.AssetListEntryTable;
import com.liferay.fragment.model.FragmentCompositionTable;
import com.liferay.fragment.model.FragmentEntryLinkTable;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRelTable;
import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.model.ClassNameTable;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.PortletPreferencesTable;
import com.liferay.portal.kernel.model.PortletTable;
import com.liferay.portal.kernel.model.ResourceActionTable;
import com.liferay.portal.kernel.model.ResourcePermissionTable;
import com.liferay.portal.kernel.model.UserNotificationEventTable;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceTable;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceTokenTable;
import com.liferay.portal.workflow.kaleo.model.KaleoLogTable;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceTokenTable;
import com.liferay.site.navigation.model.SiteNavigationMenuItemTable;
import com.liferay.template.model.TemplateEntryTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class CompanyObjectDefinitionPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private final Map<String, String> _classNameColumnNamesMap;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private PLOEntryLocalService _ploEntryLocalService;
    private final Map<String, String> _portletIdColumnNamesMap;

    public CompanyObjectDefinitionPortalInstanceLifecycleListener() {
        this._classNameColumnNamesMap = HashMapBuilder.put((Object)AssetListEntryTable.INSTANCE.getTableName(), (Object)AssetListEntryTable.INSTANCE.assetEntryType.getName()).put((Object)ClassNameTable.INSTANCE.getTableName(), (Object)ClassNameTable.INSTANCE.value.getName()).put((Object)FragmentCompositionTable.INSTANCE.getTableName(), (Object)FragmentCompositionTable.INSTANCE.data.getName()).put((Object)FragmentEntryLinkTable.INSTANCE.getTableName(), (Object)FragmentEntryLinkTable.INSTANCE.editableValues.getName()).put((Object)KaleoInstanceTable.INSTANCE.getTableName(), (Object)(KaleoInstanceTable.INSTANCE.className.getName() + "," + KaleoInstanceTable.INSTANCE.workflowContext.getName())).put((Object)KaleoInstanceTokenTable.INSTANCE.getTableName(), (Object)KaleoInstanceTokenTable.INSTANCE.className.getName()).put((Object)KaleoLogTable.INSTANCE.getTableName(), (Object)KaleoLogTable.INSTANCE.workflowContext.getName()).put((Object)KaleoTaskInstanceTokenTable.INSTANCE.getTableName(), (Object)(KaleoTaskInstanceTokenTable.INSTANCE.className.getName() + "," + KaleoTaskInstanceTokenTable.INSTANCE.workflowContext.getName())).put((Object)LayoutPageTemplateStructureRelTable.INSTANCE.getTableName(), (Object)LayoutPageTemplateStructureRelTable.INSTANCE.data.getName()).put((Object)ResourceActionTable.INSTANCE.getTableName(), (Object)ResourceActionTable.INSTANCE.name.getName()).put((Object)ResourcePermissionTable.INSTANCE.getTableName(), (Object)(ResourcePermissionTable.INSTANCE.name.getName() + "," + ResourcePermissionTable.INSTANCE.primKey.getName())).put((Object)SiteNavigationMenuItemTable.INSTANCE.getTableName(), (Object)(SiteNavigationMenuItemTable.INSTANCE.type.getName() + "," + SiteNavigationMenuItemTable.INSTANCE.typeSettings.getName())).put((Object)TemplateEntryTable.INSTANCE.getTableName(), (Object)TemplateEntryTable.INSTANCE.infoItemClassName.getName()).put((Object)UserNotificationEventTable.INSTANCE.getTableName(), (Object)UserNotificationEventTable.INSTANCE.payload.getName()).put((Object)"Configuration_", (Object)"dictionary").build();
        this._portletIdColumnNamesMap = HashMapBuilder.put((Object)FragmentCompositionTable.INSTANCE.getTableName(), (Object)FragmentCompositionTable.INSTANCE.data.getName()).put((Object)FragmentEntryLinkTable.INSTANCE.getTableName(), (Object)FragmentEntryLinkTable.INSTANCE.editableValues.getName()).put((Object)LayoutPageTemplateStructureRelTable.INSTANCE.getTableName(), (Object)LayoutPageTemplateStructureRelTable.INSTANCE.data.getName()).put((Object)PortletTable.INSTANCE.getTableName(), (Object)PortletTable.INSTANCE.portletId.getName()).put((Object)PortletPreferencesTable.INSTANCE.getTableName(), (Object)PortletPreferencesTable.INSTANCE.portletId.getName()).put((Object)ResourceActionTable.INSTANCE.getTableName(), (Object)ResourceActionTable.INSTANCE.name.getName()).put((Object)ResourcePermissionTable.INSTANCE.getTableName(), (Object)(ResourcePermissionTable.INSTANCE.name.getName() + "," + ResourcePermissionTable.INSTANCE.primKey.getName())).build();
    }

    public void portalInstancePreregistered(Company company) throws Exception {
        if (!PropsValues.DATABASE_PARTITION_ENABLED || !PortalInstances.isCompanyInCopyProcess()) {
            return;
        }
        Connection connection = this._currentConnection.getConnection(InfrastructureUtil.getDataSource());
        for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getObjectDefinitions(company.getCompanyId(), 0)) {
            if (objectDefinition.isUnmodifiableSystemObject()) continue;
            String className = objectDefinition.getClassName();
            if (StringUtil.equals((String)(objectDefinition = this._objectDefinitionLocalService.updateClassName(objectDefinition.getObjectDefinitionId())).getClassName(), (String)className)) continue;
            try (AutoCloseable autoCloseable = this._disableAutoCommit(connection);){
                this._executeUpdates(this._classNameColumnNamesMap, company.getCompanyId(), connection, objectDefinition.getClassName(), className);
                this._executeUpdates(this._portletIdColumnNamesMap, company.getCompanyId(), connection, ObjectDefinitionUtil.getPortletId((String)objectDefinition.getClassName()), ObjectDefinitionUtil.getPortletId((String)className));
                connection.commit();
            }
            this._ploEntryLocalService.deletePLOEntries(company.getCompanyId(), "model.resource." + className);
            this._objectDefinitionLocalService.addOrUpdateObjectDefinitionPLOEntries(objectDefinition);
        }
    }

    public void portalInstancePreunregistered(Company company) throws Exception {
        if (!PropsValues.DATABASE_PARTITION_ENABLED) {
            return;
        }
        List objectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(company.getCompanyId(), 0);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this._objectDefinitionLocalService.undeployObjectDefinition(objectDefinition);
        }
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!PropsValues.DATABASE_PARTITION_ENABLED || !PortalInstances.isCompanyInCopyProcess()) {
            return;
        }
        List objectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(company.getCompanyId(), 0);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            if (objectDefinition.isActive()) {
                this._objectDefinitionLocalService.deployObjectDefinition(objectDefinition);
                continue;
            }
            this._objectDefinitionLocalService.deployInactiveObjectDefinition(objectDefinition);
        }
    }

    private AutoCloseable _disableAutoCommit(Connection connection) throws Exception {
        boolean autoCommit = connection.getAutoCommit();
        connection.setAutoCommit(false);
        return () -> connection.setAutoCommit(autoCommit);
    }

    private void _executeUpdates(Map<String, String> columnNamesMap, long companyId, Connection connection, String newData, String oldData) throws Exception {
        for (Map.Entry<String, String> entry : columnNamesMap.entrySet()) {
            String[] columnNames = StringUtil.split((String)entry.getValue());
            PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)this._getUpdateSQL(columnNames, companyId, entry.getKey())));
            try {
                int i;
                int parameterIndex = 1;
                for (i = 0; i < columnNames.length; ++i) {
                    preparedStatement.setString(parameterIndex++, oldData);
                    preparedStatement.setString(parameterIndex++, newData);
                }
                for (i = 0; i < columnNames.length; ++i) {
                    preparedStatement.setString(parameterIndex++, "%" + oldData + "%");
                }
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement == null) continue;
                preparedStatement.close();
            }
        }
    }

    private String _getUpdateSQL(String[] columnNames, long companyId, String tableName) {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("update ");
        sb.append(PropsValues.DATABASE_PARTITION_SCHEMA_NAME_PREFIX);
        sb.append(companyId);
        sb.append(".");
        sb.append(tableName);
        sb.append(" set ");
        for (i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(columnNames[i]);
            sb.append(" = replace(");
            sb.append(columnNames[i]);
            sb.append(", ?, ?)");
        }
        sb.append(" where ");
        for (i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                sb.append(" or ");
            }
            sb.append(columnNames[i]);
            sb.append(" like ?");
        }
        return sb.toString();
    }
}

