/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.db;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.impl.ObjectRelationshipImpl;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTableFactory;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.DBResourceProvider;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DBResourceProvider.class})
public class ObjectDBResourceProvider
implements DBResourceProvider {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDBResourceProvider.class);
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;

    public List<String> getTableNames(long companyId) throws PortalException {
        Map<String, String[]> tablesPrimaryKeyColumnNames = this.getTablesPrimaryKeyColumnNames(companyId);
        return new ArrayList<String>(tablesPrimaryKeyColumnNames.keySet());
    }

    public Map<String, String[]> getTablesPrimaryKeyColumnNames(long companyId) throws PortalException {
        try {
            return this._getTablesPrimaryKeyColumnNames(companyId);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<ObjectRelationship> _getAllObjectRelationships(Connection connection, ObjectDefinition objectDefinition) throws PortalException {
        try {
            return this._objectRelationshipLocalService.getAllObjectRelationships(objectDefinition.getObjectDefinitionId());
        }
        catch (Exception exception1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception1);
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select dbTableName, objectDefinitionId1, ", "objectDefinitionId2, objectRelationshipId, type_ ", "from ObjectRelationship where companyId = ? and ", "(objectDefinitionId1 = ? or objectDefinitionId2 ", "= ?) and reverse = ?"}));){
                ArrayList<ObjectRelationship> arrayList;
                block18: {
                    preparedStatement.setLong(1, objectDefinition.getCompanyId());
                    preparedStatement.setLong(2, objectDefinition.getObjectDefinitionId());
                    preparedStatement.setLong(3, objectDefinition.getObjectDefinitionId());
                    preparedStatement.setBoolean(4, false);
                    final ResultSet resultSet = preparedStatement.executeQuery();
                    try {
                        ArrayList<ObjectRelationship> objectRelationships = new ArrayList<ObjectRelationship>();
                        while (resultSet.next()) {
                            ObjectRelationshipImpl objectRelationship = new ObjectRelationshipImpl(){
                                {
                                    this.setDBTableName(resultSet.getString("dbTableName"));
                                    this.setObjectDefinitionId1(resultSet.getLong("objectDefinitionId1"));
                                    this.setObjectDefinitionId2(resultSet.getLong("objectDefinitionId2"));
                                    this.setObjectRelationshipId(resultSet.getLong("objectRelationshipId"));
                                    this.setReverse(false);
                                    this.setType(resultSet.getString("type_"));
                                }
                            };
                            objectRelationships.add(objectRelationship);
                        }
                        arrayList = objectRelationships;
                        if (resultSet == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return arrayList;
            }
            catch (Exception exception2) {
                throw new PortalException((Throwable)exception2);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Map<Long, ObjectDefinition> _getObjectDefinitions(long companyId) throws PortalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String[]> _getObjectLocalizationTablePrimaryKeyColumnNames(DBInspector dbInspector, ObjectDefinition objectDefinition) throws Exception {
        block4: {
            try {
                DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this._objectFieldLocalService);
                if (dynamicObjectDefinitionLocalizationTable != null) {
                    return Collections.singletonMap(objectDefinition.getLocalizationDBTableName(), dynamicObjectDefinitionLocalizationTable.getPrimaryKeyColumnNames());
                }
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                if (!dbInspector.hasTable(objectDefinition.getLocalizationDBTableName())) break block4;
                return Collections.singletonMap(objectDefinition.getLocalizationDBTableName(), new String[]{objectDefinition.getPKObjectFieldDBColumnName(), "languageId"});
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, String[]> _getObjectRelationshipTablesPrimaryKeyColumnNames(Connection connection, ObjectDefinition objectDefinition, Map<Long, ObjectDefinition> objectDefinitions) throws PortalException {
        HashMap<String, String[]> objectRelationshipTablesPrimaryKeyColumnNames = new HashMap<String, String[]>();
        List<ObjectRelationship> objectRelationships = this._getAllObjectRelationships(connection, objectDefinition);
        for (ObjectRelationship objectRelationship : objectRelationships) {
            if (!StringUtil.equalsIgnoreCase((String)objectRelationship.getType(), (String)"manyToMany")) continue;
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinitions.get(objectRelationship.getObjectDefinitionId1()), (ObjectDefinition)objectDefinitions.get(objectRelationship.getObjectDefinitionId2()), (boolean)false);
            String pkObjectFieldDBColumnName1 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1");
            String pkObjectFieldDBColumnName2 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2");
            objectRelationshipTablesPrimaryKeyColumnNames.put(objectRelationship.getDBTableName(), new String[]{pkObjectFieldDBColumnName1, pkObjectFieldDBColumnName2});
        }
        return objectRelationshipTablesPrimaryKeyColumnNames;
    }

    private Map<String, String[]> _getTablesPrimaryKeyColumnNames(long companyId) throws Exception {
        HashMap<String, String[]> tablesPrimaryKeyColumnNames = new HashMap<String, String[]>();
        try (Connection connection = DataAccess.getConnection();){
            DBInspector dbInspector = new DBInspector(connection);
            Map<Long, ObjectDefinition> objectDefinitions = this._getObjectDefinitions(companyId);
            for (ObjectDefinition objectDefinition : objectDefinitions.values()) {
                if (!objectDefinition.isUnmodifiableSystemObject()) {
                    tablesPrimaryKeyColumnNames.put(objectDefinition.getDBTableName(), new String[]{objectDefinition.getPKObjectFieldDBColumnName()});
                }
                tablesPrimaryKeyColumnNames.put(objectDefinition.getExtensionDBTableName(), new String[]{objectDefinition.getPKObjectFieldDBColumnName()});
                tablesPrimaryKeyColumnNames.putAll(this._getObjectLocalizationTablePrimaryKeyColumnNames(dbInspector, objectDefinition));
                tablesPrimaryKeyColumnNames.putAll(this._getObjectRelationshipTablesPrimaryKeyColumnNames(connection, objectDefinition, objectDefinitions));
            }
        }
        return tablesPrimaryKeyColumnNames;
    }
}

