/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.depot.model.DepotEntry;
import com.liferay.object.internal.entry.folder.util.ObjectEntryFolderUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.PermissionService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=permission.object"}, service={BulkSelectionAction.class})
public class PermissionObjectBulkSelectionAction
implements BulkSelectionAction<Object> {
    private static final Log _log = LogFactoryUtil.getLog(PermissionObjectBulkSelectionAction.class);
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private PermissionService _permissionService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(User user, BulkSelection<Object> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        long bulkActionTaskId = GetterUtil.getLong((Object)inputMap.get("bulkActionTaskId"));
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(bulkActionTaskId);
        Map values = objectEntry.getValues();
        values.put("numberOfItems", bulkSelection.getSize());
        String executionStatus = "completed";
        AtomicInteger numberOfFailedItems = new AtomicInteger(0);
        AtomicInteger numberOfSuccessfulItems = new AtomicInteger(0);
        try {
            values.put("executionStatus", "started");
            objectEntry = this._partialUpdateObjectEntry(objectEntry, values);
            values = objectEntry.getValues();
            long companyId = objectEntry.getCompanyId();
            bulkSelection.forEach(object -> {
                long objectDefinitionId = this._getObjectDefinitionId(companyId);
                String status = "completed";
                try {
                    String className = null;
                    long groupId = 0L;
                    long resourceId = 0L;
                    String resourceName = null;
                    if (object instanceof DepotEntry) {
                        DepotEntry depotEntry = (DepotEntry)object;
                        className = depotEntry.getModelClassName();
                        groupId = depotEntry.getGroupId();
                        resourceId = depotEntry.getDepotEntryId();
                        resourceName = depotEntry.getModelClassName();
                    } else if (object instanceof ObjectEntry) {
                        ObjectEntry objectObjectEntry = (ObjectEntry)object;
                        long rootObjectEntryFolderId = ObjectEntryFolderUtil.getRootObjectEntryFolderId(objectObjectEntry.getObjectEntryFolderId());
                        if (rootObjectEntryFolderId == 0L) {
                            return;
                        }
                        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.getObjectEntryFolder(rootObjectEntryFolderId);
                        className = objectEntryFolder.getExternalReferenceCode();
                        groupId = objectObjectEntry.getGroupId();
                        resourceId = objectObjectEntry.getObjectEntryId();
                        resourceName = objectObjectEntry.getModelClassName();
                    } else {
                        ObjectEntryFolder objectEntryFolder = (ObjectEntryFolder)object;
                        className = objectEntryFolder.getModelClassName();
                        groupId = objectEntryFolder.getGroupId();
                        resourceId = objectEntryFolder.getObjectEntryFolderId();
                        resourceName = objectEntryFolder.getModelClassName();
                    }
                    this._permissionService.checkPermission(groupId, resourceName, resourceId);
                    ModelPermissions modelPermissions = ModelPermissionsUtil.toModelPermissions((long)companyId, (Permission[])this._getPermissions((Map)inputMap.get("permissions"), className), (long)resourceId, (String)resourceName, (ResourceActionLocalService)this._resourceActionLocalService, (ResourcePermissionLocalService)this._resourcePermissionLocalService, (RoleLocalService)this._roleLocalService);
                    String roleKey = (String)inputMap.get("roleKey");
                    if (Validator.isBlank((String)roleKey)) {
                        Collection roleNames = modelPermissions.getRoleNames();
                        for (ResourcePermission resourcePermission : this._resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId))) {
                            Role role = this._roleLocalService.fetchRole(resourcePermission.getRoleId());
                            if (role == null || roleNames.contains(role.getName())) continue;
                            for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(resourceName)) {
                                this._resourcePermissionLocalService.removeResourcePermission(companyId, resourceName, 4, String.valueOf(resourceId), role.getRoleId(), resourceAction.getActionId());
                            }
                        }
                        this._resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, resourceName, String.valueOf(resourceId), modelPermissions);
                    } else {
                        Role role = this._roleLocalService.fetchRole(companyId, roleKey);
                        if (role != null) {
                            this._resourcePermissionLocalService.setResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId), role.getRoleId(), modelPermissions.getActionIds(role.getName()));
                        }
                    }
                    numberOfSuccessfulItems.getAndIncrement();
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)portalException);
                    }
                    numberOfFailedItems.getAndIncrement();
                }
                finally {
                    this._objectEntryLocalService.addObjectEntry(0L, user.getUserId(), objectDefinitionId, 0L, null, (Map)HashMapBuilder.put((Object)"bulkActionTaskId", (Object)bulkActionTaskId).put((Object)"executionStatus", (Object)status).put((Object)"r_cmsBATaskToCMSBATaskItems_c_cmsBulkActionTaskId", (Object)bulkActionTaskId).put((Object)"type", (Object)"ObjectEntryFolder").build(), new ServiceContext());
                }
            });
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            executionStatus = "failed";
        }
        finally {
            values.put("completionDate", new Date());
            values.put("executionStatus", executionStatus);
            values.put("numberOfFailedItems", numberOfFailedItems.get());
            values.put("numberOfSuccessfulItems", numberOfSuccessfulItems.get());
            this._partialUpdateObjectEntry(objectEntry, values);
        }
    }

    private long _getObjectDefinitionId(long companyId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_CMS_BULK_ACTION_TASK_ITEM", companyId);
        return objectDefinition.getObjectDefinitionId();
    }

    private Permission[] _getPermissions(Map<String, Serializable> map, String key) {
        return (Permission[])map.getOrDefault(key, (Serializable)new Permission[0]);
    }

    private ObjectEntry _partialUpdateObjectEntry(ObjectEntry objectEntry, Map<String, Serializable> values) throws PortalException {
        return this._objectEntryLocalService.partialUpdateObjectEntry(objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectEntry.getObjectEntryFolderId(), values, new ServiceContext());
    }
}

