/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.util;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryOrganizationRelLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class ObjectEntryPermissionUtil {
    public static boolean hasAccountEntryPermission(AccountEntry accountEntry, String actionId, String name, PermissionChecker permissionChecker) throws PortalException {
        if (permissionChecker.hasPermission(accountEntry.getAccountEntryGroupId(), name, 0L, actionId)) {
            return true;
        }
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : AccountEntryOrganizationRelLocalServiceUtil.getAccountEntryOrganizationRels((long)accountEntry.getAccountEntryId())) {
            Organization organization = accountEntryOrganizationRel.getOrganization();
            if (permissionChecker.hasPermission(organization.getGroupId(), name, 0L, actionId)) {
                return true;
            }
            for (Organization ancestorOrganization : organization.getAncestors()) {
                if (!permissionChecker.hasPermission(ancestorOrganization.getGroupId(), name, 0L, actionId)) continue;
                return true;
            }
        }
        return false;
    }
}

