/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.instance.lifecycle;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.util.PortalInstances;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class CompanyObjectDefinitionPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;

    public void portalInstancePreunregistered(Company company) throws Exception {
        if (!PropsValues.DATABASE_PARTITION_ENABLED) {
            return;
        }
        List objectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(company.getCompanyId(), 0);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this._objectDefinitionLocalService.undeployObjectDefinition(objectDefinition);
        }
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!PropsValues.DATABASE_PARTITION_ENABLED || !PortalInstances.isCompanyInCopyProcess()) {
            return;
        }
        List objectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(company.getCompanyId(), 0);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            if (objectDefinition.isActive()) {
                this._objectDefinitionLocalService.deployObjectDefinition(objectDefinition);
                continue;
            }
            this._objectDefinitionLocalService.deployInactiveObjectDefinition(objectDefinition);
        }
    }
}

