/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectEntryValuesException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=RichText"}, service={ObjectFieldBusinessType.class})
public class RichTextObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;

    public String getDBType() {
        return "Clob";
    }

    public String getDDMFormFieldTypeName() {
        return "rich_text";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "create-rich-text-content");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "rich-text");
    }

    public Map<String, Object> getLocalizedValues(ObjectField objectField, Long userId, Map<String, Object> values) throws PortalException {
        Map localizedValues = super.getLocalizedValues(objectField, userId, values);
        if (localizedValues == null) {
            return null;
        }
        for (Map.Entry entry : localizedValues.entrySet()) {
            localizedValues.put((String)entry.getKey(), this._getValue(objectField, entry.getValue()));
        }
        return localizedValues;
    }

    public String getName() {
        return "RichText";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Object getValue(Long groupId, ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        Object value = super.getValue(groupId, objectField, userId, values);
        return this._getValue(objectField, value);
    }

    private Object _getValue(ObjectField objectField, Object value) throws PortalException {
        if (Validator.isNull((Object)value)) {
            return value;
        }
        if (!FeatureFlagManagerUtil.isEnabled((long)objectField.getCompanyId(), (String)"LPD-11235") && !FeatureFlagManagerUtil.isEnabled((long)objectField.getCompanyId(), (String)"LPD-31212")) {
            ObjectDefinition objectDefinition = objectField.getObjectDefinition();
            try {
                value = SanitizerUtil.sanitize((long)objectField.getCompanyId(), (long)0L, (long)objectField.getUserId(), (String)objectDefinition.getClassName(), (long)0L, (String)"text/html", (String)"ALL", (String)String.valueOf(value), null);
            }
            catch (SanitizerException sanitizerException) {
                Throwable throwable = sanitizerException.getCause();
                throw new ObjectEntryValuesException.InvalidValue(throwable.getMessage(), objectField.getName());
            }
        } else {
            value = this._htmlParser.extractText(HtmlUtil.escape((String)String.valueOf(value)));
        }
        return value;
    }
}

