/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.permission;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.search.configuration.SearchPermissionCheckerConfiguration;
import com.liferay.portal.search.spi.model.permission.contributor.SearchPermissionFilterContributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.SearchPermissionCheckerConfiguration"}, service={SearchPermissionFilterContributor.class})
public class ObjectEntrySearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntrySearchPermissionFilterContributor.class);
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    private volatile SearchPermissionCheckerConfiguration _searchPermissionCheckerConfiguration;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        int permissionTermsLimit;
        if (!className.startsWith(ObjectDefinition.class.getName())) {
            return;
        }
        ArrayList<Long> accountEntryIds = new ArrayList<Long>();
        for (AccountEntryUserRel accountEntryUserRel : this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(permissionChecker.getUserId())) {
            try {
                AccountEntry accountEntry = accountEntryUserRel.getAccountEntry();
                if (accountEntry.isInactive()) continue;
                accountEntryIds.add(accountEntry.getAccountEntryId());
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        List organizations = this._organizationLocalService.getUserOrganizations(permissionChecker.getUserId());
        int termsCount = accountEntryIds.size() + organizations.size();
        if (termsCount > (permissionTermsLimit = this._searchPermissionCheckerConfiguration.permissionTermsLimit())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping presearch account restriction checking due ", "to too many account entries and organizations: ", termsCount, " > ", permissionTermsLimit}));
            }
            return;
        }
        this._contributeAccountEntryRestrictedObjectFieldValue(accountEntryIds, booleanFilter);
        this._contributeAccountEntryRestrictedOrganizationIds(booleanFilter, organizations);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._searchPermissionCheckerConfiguration = (SearchPermissionCheckerConfiguration)ConfigurableUtil.createConfigurable(SearchPermissionCheckerConfiguration.class, properties);
    }

    private void _contributeAccountEntryRestrictedObjectFieldValue(List<Long> accountEntryIds, BooleanFilter booleanFilter) {
        if (accountEntryIds.isEmpty()) {
            return;
        }
        TermsFilter termsFilter = new TermsFilter("accountEntryRestrictedObjectFieldValue");
        for (long accountEntryId : accountEntryIds) {
            termsFilter.addValue(String.valueOf(accountEntryId));
        }
        booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
    }

    private void _contributeAccountEntryRestrictedOrganizationIds(BooleanFilter booleanFilter, List<Organization> organizations) {
        if (organizations.isEmpty()) {
            return;
        }
        TermsFilter termsFilter = new TermsFilter("accountEntryRestrictedOrganizationIds");
        for (Organization organization : organizations) {
            termsFilter.addValue(String.valueOf(organization.getOrganizationId()));
            for (Organization descendantOrganization : organization.getDescendants()) {
                termsFilter.addValue(String.valueOf(descendantOrganization.getOrganizationId()));
            }
        }
        booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
    }
}

