/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.deployer;

import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationCategory;
import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationEntry;
import com.liferay.notification.handler.NotificationHandler;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.definition.security.permission.resource.util.ObjectDefinitionResourcePermissionUtil;
import com.liferay.object.definition.tree.util.ObjectDefinitionTreeUtil;
import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.internal.layout.tab.screen.navigation.category.ObjectLayoutTabScreenNavigationCategory;
import com.liferay.object.internal.notification.handler.ObjectDefinitionNotificationHandler;
import com.liferay.object.internal.notification.term.contributor.ObjectDefinitionNotificationTermEvaluator;
import com.liferay.object.internal.related.models.ObjectEntry1to1ObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.related.models.ObjectEntry1toMObjectRelatedModelsPredicateProviderImpl;
import com.liferay.object.internal.related.models.ObjectEntry1toMObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.related.models.ObjectEntryMtoMObjectRelatedModelsPredicateProviderImpl;
import com.liferay.object.internal.related.models.ObjectEntryMtoMObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.rest.context.path.RESTContextPathResolverImpl;
import com.liferay.object.internal.search.spi.model.index.contributor.ObjectEntryModelDocumentContributor;
import com.liferay.object.internal.search.spi.model.index.contributor.ObjectEntryModelIndexerWriterContributor;
import com.liferay.object.internal.search.spi.model.query.contributor.ObjectEntryKeywordQueryContributor;
import com.liferay.object.internal.search.spi.model.query.contributor.ObjectEntryModelPreFilterContributor;
import com.liferay.object.internal.search.spi.model.result.contributor.ObjectEntryModelSummaryContributor;
import com.liferay.object.internal.security.permission.ObjectEntrySharingPermissionChecker;
import com.liferay.object.internal.security.permission.resource.ObjectEntryModelResourcePermission;
import com.liferay.object.internal.security.permission.resource.ObjectEntryPortletResourcePermissionLogic;
import com.liferay.object.internal.trash.ObjectEntryTrashHandler;
import com.liferay.object.internal.uad.anonymizer.ObjectEntryUADAnonymizer;
import com.liferay.object.internal.uad.display.ObjectEntryUADDisplay;
import com.liferay.object.internal.uad.exporter.ObjectEntryUADExporter;
import com.liferay.object.internal.workflow.ObjectEntryWorkflowHandler;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectLayout;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsPredicateProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistryUtil;
import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectDefinitionSettingLocalService;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.object.service.ObjectLayoutLocalService;
import com.liferay.object.service.ObjectLayoutTabLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.tree.Node;
import com.liferay.object.tree.ObjectDefinitionTreeFactory;
import com.liferay.object.tree.Tree;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.ml.embedding.text.TextEmbeddingDocumentContributor;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchConfigurator;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.sharing.security.permission.SharingPermissionChecker;
import com.liferay.sharing.security.permission.resource.SharingModelResourcePermissionConfigurator;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.exporter.UADExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ObjectDefinitionDeployerImpl
implements ObjectDefinitionDeployer {
    private final AccountEntryLocalService _accountEntryLocalService;
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final AssetEntryLocalService _assetEntryLocalService;
    private final BundleContext _bundleContext;
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    private final GroupLocalService _groupLocalService;
    private final KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    private final Language _language;
    private final ListTypeLocalService _listTypeLocalService;
    private final ObjectActionLocalService _objectActionLocalService;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectDefinitionSettingLocalService _objectDefinitionSettingLocalService;
    private final ObjectDefinitionTreeFactory _objectDefinitionTreeFactory;
    private final ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectEntryService _objectEntryService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectFolderLocalService _objectFolderLocalService;
    private final ObjectLayoutLocalService _objectLayoutLocalService;
    private final ObjectLayoutTabLocalService _objectLayoutTabLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    private final ObjectViewLocalService _objectViewLocalService;
    private final OrganizationLocalService _organizationLocalService;
    private final PLOEntryLocalService _ploEntryLocalService;
    private final Portal _portal;
    private final PortletLocalService _portletLocalService;
    private final ResourceActions _resourceActions;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final SearchLocalizationHelper _searchLocalizationHelper;
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private final SharingModelResourcePermissionConfigurator _sharingModelResourcePermissionConfigurator;
    private final SystemEventLocalService _systemEventLocalService;
    private final TextEmbeddingDocumentContributor _textEmbeddingDocumentContributor;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final UserLocalService _userLocalService;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    private final ModelPreFilterContributor _workflowStatusModelPreFilterContributor;

    public ObjectDefinitionDeployerImpl(AccountEntryLocalService accountEntryLocalService, AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, AssetEntryLocalService assetEntryLocalService, BundleContext bundleContext, DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory, GroupLocalService groupLocalService, KaleoDefinitionLocalService kaleoDefinitionLocalService, Language language, ListTypeLocalService listTypeLocalService, ObjectActionLocalService objectActionLocalService, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectDefinitionSettingLocalService objectDefinitionSettingLocalService, ObjectEntryFolderLocalService objectEntryFolderLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectEntryService objectEntryService, ObjectFieldLocalService objectFieldLocalService, ObjectFolderLocalService objectFolderLocalService, ObjectLayoutLocalService objectLayoutLocalService, ObjectLayoutTabLocalService objectLayoutTabLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, ObjectScopeProviderRegistry objectScopeProviderRegistry, ObjectViewLocalService objectViewLocalService, OrganizationLocalService organizationLocalService, PLOEntryLocalService ploEntryLocalService, Portal portal, PortletLocalService portletLocalService, ResourceActions resourceActions, UserLocalService userLocalService, ResourcePermissionLocalService resourcePermissionLocalService, SearchLocalizationHelper searchLocalizationHelper, SharingModelResourcePermissionConfigurator sharingModelResourcePermissionConfigurator, SystemEventLocalService systemEventLocalService, TextEmbeddingDocumentContributor textEmbeddingDocumentContributor, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService, ModelPreFilterContributor workflowStatusModelPreFilterContributor, UserGroupRoleLocalService userGroupRoleLocalService) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._bundleContext = bundleContext;
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
        this._groupLocalService = groupLocalService;
        this._kaleoDefinitionLocalService = kaleoDefinitionLocalService;
        this._language = language;
        this._listTypeLocalService = listTypeLocalService;
        this._objectActionLocalService = objectActionLocalService;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectDefinitionSettingLocalService = objectDefinitionSettingLocalService;
        this._objectEntryFolderLocalService = objectEntryFolderLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectEntryService = objectEntryService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectFolderLocalService = objectFolderLocalService;
        this._objectLayoutLocalService = objectLayoutLocalService;
        this._objectLayoutTabLocalService = objectLayoutTabLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._objectScopeProviderRegistry = objectScopeProviderRegistry;
        this._objectViewLocalService = objectViewLocalService;
        this._organizationLocalService = organizationLocalService;
        this._ploEntryLocalService = ploEntryLocalService;
        this._portal = portal;
        this._portletLocalService = portletLocalService;
        this._resourceActions = resourceActions;
        this._userLocalService = userLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._searchLocalizationHelper = searchLocalizationHelper;
        this._sharingModelResourcePermissionConfigurator = sharingModelResourcePermissionConfigurator;
        this._systemEventLocalService = systemEventLocalService;
        this._textEmbeddingDocumentContributor = textEmbeddingDocumentContributor;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
        this._workflowStatusModelPreFilterContributor = workflowStatusModelPreFilterContributor;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._objectDefinitionTreeFactory = new ObjectDefinitionTreeFactory(this._objectDefinitionLocalService, this._objectRelationshipLocalService);
    }

    public Map<String, List<ServiceRegistration<?>>> deploy(long companyId, List<ObjectDefinition> objectDefinitions) {
        ConcurrentHashMap serviceRegistrationsMap = new ConcurrentHashMap();
        if (FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-34594")) {
            ObjectDefinitionTreeUtil.populateRootObjectDefinitionIds(objectDefinitions, (Map)this._objectDefinitionSettingLocalService.getObjectDefinitionSettingsMap(companyId, "rootObjectDefinitionIds"));
        }
        Map objectActionsMap = this._objectActionLocalService.getObjectActionsMap(companyId, true, "standalone");
        Map objectFieldsMap = this._objectFieldLocalService.getObjectFieldsMap(companyId, "Attachment");
        Map objectLayoutsMap = this._objectLayoutLocalService.getObjectLayoutsMap(companyId);
        Map objectRelationshipsMap = this._objectRelationshipLocalService.getObjectRelationshipsMap(companyId);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            long objectDefinitionId = objectDefinition.getObjectDefinitionId();
            serviceRegistrationsMap.put(DBPartitionUtil.getPartitionKey((Object)objectDefinitionId), this._deploy(objectActionsMap.getOrDefault(objectDefinitionId, Collections.emptyList()), objectDefinition, objectFieldsMap.getOrDefault(objectDefinitionId, Collections.emptyList()), objectLayoutsMap.getOrDefault(objectDefinitionId, Collections.emptyList()), objectRelationshipsMap));
        }
        return serviceRegistrationsMap;
    }

    public List<ServiceRegistration<?>> deploy(ObjectDefinition objectDefinition) {
        return this._deploy(null, objectDefinition, null, null, null);
    }

    public synchronized void undeploy(ObjectDefinition objectDefinition) {
        this._unregister(this._getServiceRegistrationKey(objectDefinition, null));
        for (String serviceRegistrationKey : this._serviceRegistrations.keySet()) {
            if (!serviceRegistrationKey.startsWith(this._getServiceRegistrationKey(objectDefinition, null) + "#")) continue;
            this._unregister(serviceRegistrationKey);
        }
    }

    private List<ServiceRegistration<?>> _deploy(List<ObjectAction> objectActions, final ObjectDefinition objectDefinition, List<ObjectField> objectFields, List<ObjectLayout> objectLayouts, Map<Long, List<ObjectRelationship>> objectRelationshipsMap) {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            return Collections.emptyList();
        }
        try {
            ObjectDefinitionResourcePermissionUtil.populateResourceActions((ObjectActionLocalService)this._objectActionLocalService, objectActions, (ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this._objectFieldLocalService, objectFields, (PortletLocalService)this._portletLocalService, (ResourceActions)this._resourceActions);
        }
        catch (Exception exception) {
            return (List)ReflectionUtil.throwException((Throwable)exception);
        }
        ArrayList serviceRegistrations = new ArrayList();
        if (objectDefinition.isEnableIndexSearch()) {
            final ObjectEntryModelIndexerWriterContributor objectEntryModelIndexerWriterContributor = new ObjectEntryModelIndexerWriterContributor(this._dynamicQueryBatchIndexingActionableFactory, objectDefinition.getObjectDefinitionId(), this._objectEntryLocalService);
            final ObjectEntryModelSummaryContributor objectEntryModelSummaryContributor = new ObjectEntryModelSummaryContributor();
            Collections.addAll(serviceRegistrations, this._bundleContext.registerService(KeywordQueryContributor.class, (Object)new ObjectEntryKeywordQueryContributor(objectDefinition, this._objectFieldLocalService, this._objectViewLocalService, this._searchLocalizationHelper), (Dictionary)HashMapDictionaryBuilder.put((Object)"component.name", (Object)ObjectEntryKeywordQueryContributor.class.getName()).put((Object)"indexer.class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(ModelDocumentContributor.class, (Object)new ObjectEntryModelDocumentContributor(this._accountEntryOrganizationRelLocalService, objectDefinition.getClassName(), this._objectDefinitionLocalService, this._objectEntryFolderLocalService, this._objectEntryLocalService, this._objectFieldLocalService, this._objectFolderLocalService, this._textEmbeddingDocumentContributor), (Dictionary)HashMapDictionaryBuilder.put((Object)"indexer.class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(ModelPreFilterContributor.class, (Object)new ObjectEntryModelPreFilterContributor(this._workflowStatusModelPreFilterContributor), (Dictionary)HashMapDictionaryBuilder.put((Object)"indexer.class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(ModelSearchConfigurator.class, (Object)new ModelSearchConfigurator<ObjectEntry>(){

                public String getClassName() {
                    return objectDefinition.getClassName();
                }

                public long getCompanyId() {
                    return objectDefinition.getCompanyId();
                }

                public ModelIndexerWriterContributor<ObjectEntry> getModelIndexerWriterContributor() {
                    return objectEntryModelIndexerWriterContributor;
                }

                public ModelSummaryContributor getModelSummaryContributor() {
                    return objectEntryModelSummaryContributor;
                }
            }, null));
        }
        Collections.addAll(serviceRegistrations, this._bundleContext.registerService(NotificationHandler.class, (Object)new ObjectDefinitionNotificationHandler(objectDefinition), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermEvaluator.class, (Object)new ObjectDefinitionNotificationTermEvaluator(this._listTypeLocalService, objectDefinition, this._objectDefinitionLocalService, this._objectEntryFolderLocalService, this._objectEntryLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(ObjectRelatedModelsPredicateProvider.class, (Object)new ObjectEntry1toMObjectRelatedModelsPredicateProviderImpl(objectDefinition, this._objectFieldLocalService), null), this._bundleContext.registerService(ObjectRelatedModelsPredicateProvider.class, (Object)new ObjectEntryMtoMObjectRelatedModelsPredicateProviderImpl(objectDefinition, this._objectFieldLocalService), null), this._bundleContext.registerService(PersistedModelLocalService.class, (Object)this._objectEntryLocalService, MapUtil.singletonDictionary((Object)"model.class.name", (Object)objectDefinition.getClassName())), this._bundleContext.registerService(RESTContextPathResolver.class, (Object)new RESTContextPathResolverImpl(objectDefinition, this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope()), false), (Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(UADAnonymizer.class, (Object)new ObjectEntryUADAnonymizer(this._assetEntryLocalService, objectDefinition, this._objectEntryLocalService, this._resourcePermissionLocalService), null), this._bundleContext.registerService(UADDisplay.class, (Object)new ObjectEntryUADDisplay(this._groupLocalService, objectDefinition, this._objectEntryLocalService, this._objectScopeProviderRegistry, this._portal), null), this._bundleContext.registerService(UADExporter.class, (Object)new ObjectEntryUADExporter(objectDefinition, this._objectEntryLocalService), null), ObjectRelatedModelsProviderRegistryUtil.register((BundleContext)this._bundleContext, (ObjectDefinition)objectDefinition, (ObjectRelatedModelsProvider)new ObjectEntryMtoMObjectRelatedModelsProviderImpl(objectDefinition, this._objectEntryService, this._objectRelationshipLocalService)), ObjectRelatedModelsProviderRegistryUtil.register((BundleContext)this._bundleContext, (ObjectDefinition)objectDefinition, (ObjectRelatedModelsProvider)new ObjectEntry1toMObjectRelatedModelsProviderImpl(objectDefinition, this._objectEntryService, this._objectFieldLocalService, this._objectRelationshipLocalService)), ObjectRelatedModelsProviderRegistryUtil.register((BundleContext)this._bundleContext, (ObjectDefinition)objectDefinition, (ObjectRelatedModelsProvider)new ObjectEntry1to1ObjectRelatedModelsProviderImpl(objectDefinition, this._objectEntryService, this._objectFieldLocalService, this._objectRelationshipLocalService)));
        ConsumerSupplier<ModelResourcePermissionLogic<ObjectEntry>> consumerSupplier = new ConsumerSupplier<ModelResourcePermissionLogic<ObjectEntry>>();
        PortletResourcePermission portletResourcePermission = PortletResourcePermissionFactory.create((String)objectDefinition.getResourceName(), (PortletResourcePermissionLogic[])new PortletResourcePermissionLogic[]{new ObjectEntryPortletResourcePermissionLogic(this._accountEntryLocalService, this._groupLocalService, this._objectDefinitionLocalService, this._organizationLocalService)});
        ObjectEntryModelResourcePermission modelResourcePermission = new ObjectEntryModelResourcePermission(this._accountEntryLocalService, this._accountEntryOrganizationRelLocalService, this._groupLocalService, objectDefinition.getClassName(), this._objectActionLocalService, this._objectDefinitionLocalService, this._objectEntryLocalService, consumerSupplier, this._objectFieldLocalService, portletResourcePermission, this._resourcePermissionLocalService, this._userGroupRoleLocalService);
        serviceRegistrations.add(this._bundleContext.registerService(ModelResourcePermission.class, (Object)modelResourcePermission, (Dictionary)HashMapDictionaryBuilder.put((Object)"com.liferay.object", (Object)"true").put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build()));
        serviceRegistrations.add(this._bundleContext.registerService(PortletResourcePermission.class, (Object)portletResourcePermission, (Dictionary)HashMapDictionaryBuilder.put((Object)"com.liferay.object", (Object)"true").put((Object)"resource.name", (Object)objectDefinition.getResourceName()).build()));
        this._sharingModelResourcePermissionConfigurator.configure((ModelResourcePermission)modelResourcePermission, consumerSupplier);
        serviceRegistrations.add(this._bundleContext.registerService(SharingPermissionChecker.class, (Object)new ObjectEntrySharingPermissionChecker(modelResourcePermission), (Dictionary)HashMapDictionaryBuilder.put((Object)"com.liferay.object", (Object)"true").put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build()));
        serviceRegistrations.add(this._bundleContext.registerService(TrashHandler.class, (Object)new ObjectEntryTrashHandler(objectDefinition, this._objectDefinitionLocalService, this._objectEntryService, this._systemEventLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build()));
        serviceRegistrations.add(this._bundleContext.registerService(WorkflowHandler.class, (Object)new ObjectEntryWorkflowHandler(this._kaleoDefinitionLocalService, objectDefinition, this._objectDefinitionLocalService, this._objectEntryLocalService, this._workflowDefinitionLinkLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build()));
        ObjectLayout objectLayout = null;
        if (objectLayouts == null) {
            objectLayout = this._objectLayoutLocalService.fetchDefaultObjectLayout(objectDefinition.getObjectDefinitionId());
        } else if (!objectLayouts.isEmpty()) {
            objectLayout = objectLayouts.get(0);
        }
        if (objectLayout != null) {
            this._objectLayoutTabLocalService.registerObjectLayoutTabScreenNavigationCategories(objectDefinition, objectLayout.getObjectLayoutTabs());
        }
        List objectRelationships = null;
        if (objectRelationshipsMap != null) {
            objectRelationships = objectRelationshipsMap.getOrDefault(objectDefinition.getObjectDefinitionId(), Collections.emptyList());
        }
        this._objectRelationshipLocalService.registerObjectRelationshipsRelatedInfoCollectionProviders(objectDefinition, this._objectDefinitionLocalService, objectRelationships);
        try {
            if (ArrayUtil.isNotEmpty((long[])objectDefinition.getRootObjectDefinitionIds())) {
                this._registerRootObjectLayoutTabScreenNavigationCategories(objectDefinition.getObjectDefinitionId());
            }
        }
        catch (PortalException portalException) {
            return (List)ReflectionUtil.throwException((Throwable)portalException);
        }
        return serviceRegistrations;
    }

    private String _getServiceRegistrationKey(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) {
        String serviceRegistrationKey = StringBundler.concat((Object[])new Object[]{"ROOT_OBJECT_LAYOUT_TAB#", objectDefinition.getCompanyId(), "#", objectDefinition.getObjectDefinitionId()});
        if (objectRelationship == null) {
            return serviceRegistrationKey;
        }
        return StringBundler.concat((Object[])new Object[]{serviceRegistrationKey, "#", objectRelationship.getObjectRelationshipId()});
    }

    private void _registerRootObjectLayoutTabScreenNavigationCategories(long objectDefinitionId) throws PortalException {
        Tree tree = this._objectDefinitionTreeFactory.create(false, true, objectDefinitionId);
        for (Node node : tree) {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(node.getPrimaryKey());
            List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId());
            for (ObjectRelationship objectRelationship : objectRelationships) {
                this._registerRootObjectLayoutTabScreenNavigationCategory(objectDefinition, objectRelationship);
            }
            this._registerRootObjectLayoutTabScreenNavigationCategory(objectDefinition, null);
        }
    }

    private void _registerRootObjectLayoutTabScreenNavigationCategory(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) {
        this._serviceRegistrations.computeIfAbsent(this._getServiceRegistrationKey(objectDefinition, objectRelationship), serviceRegistrationKey -> this._bundleContext.registerService(new String[]{ScreenNavigationCategory.class.getName(), ScreenNavigationEntry.class.getName()}, (Object)new ObjectLayoutTabScreenNavigationCategory(objectDefinition, null, objectRelationship), null));
    }

    private void _unregister(String serviceRegistrationKey) {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(serviceRegistrationKey);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private static class ConsumerSupplier<T>
    implements Consumer<T>,
    Supplier<T> {
        private T _t;

        private ConsumerSupplier() {
        }

        @Override
        public void accept(T t) {
            this._t = t;
        }

        @Override
        public T get() {
            return this._t;
        }
    }
}

