/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectFieldSettingModelListener
extends BaseModelListener<ObjectFieldSetting> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectFieldSetting objectFieldSetting) throws ModelListenerException {
        this._route("ADD", objectFieldSetting);
    }

    public void onBeforeRemove(ObjectFieldSetting objectFieldSetting) throws ModelListenerException {
        this._route("DELETE", objectFieldSetting);
    }

    public void onBeforeUpdate(ObjectFieldSetting originalOObjectFieldSetting, ObjectFieldSetting objectFieldSetting) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectFieldSetting.class.getName(), (long)objectFieldSetting.getObjectFieldSettingId(), this._getModifiedAttributes(originalOObjectFieldSetting, objectFieldSetting)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectFieldSetting originalObjectFieldSetting, ObjectFieldSetting objectFieldSetting) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectFieldSetting, (Object)originalObjectFieldSetting);
        attributesBuilder.add("objectFieldId");
        attributesBuilder.add("name");
        attributesBuilder.add("value");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectFieldSetting objectFieldSetting) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectFieldSetting.class.getName(), (long)objectFieldSetting.getObjectFieldSettingId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("name", objectFieldSetting.getName()).put("objectFieldId", objectFieldSetting.getObjectFieldId()).put("value", objectFieldSetting.getValue());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

