/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectEntryVersionModelListener
extends BaseModelListener<ObjectEntryVersion> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;

    public void onAfterRemove(ObjectEntryVersion objectEntryVersion) throws ModelListenerException {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntryVersion.getObjectDefinitionId());
            if (!objectDefinition.isEnableObjectEntryHistory()) {
                return;
            }
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"DELETE", (ClassedModel)objectEntryVersion, null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            JSONObject contentJSONObject = this._jsonFactory.createJSONObject(objectEntryVersion.getContent());
            JSONObject propertiesJSONObject = contentJSONObject.getJSONObject("properties");
            for (String key : propertiesJSONObject.keySet()) {
                additionalInfoJSONObject.put(key, propertiesJSONObject.get(key));
            }
            this._auditRouter.route(auditMessage);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

