/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.object.exception.DuplicateObjectRelationshipException;
import com.liferay.object.exception.DuplicateObjectRelationshipExternalReferenceCodeException;
import com.liferay.object.exception.NoSuchObjectRelationshipException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectRelationshipDeletionTypeException;
import com.liferay.object.exception.ObjectRelationshipEdgeException;
import com.liferay.object.exception.ObjectRelationshipNameException;
import com.liferay.object.exception.ObjectRelationshipParameterObjectFieldIdException;
import com.liferay.object.exception.ObjectRelationshipReverseException;
import com.liferay.object.exception.ObjectRelationshipSystemException;
import com.liferay.object.exception.ObjectRelationshipTypeException;
import com.liferay.object.internal.dao.db.ObjectDBManagerUtil;
import com.liferay.object.internal.info.collection.provider.RelatedInfoCollectionProviderFactory;
import com.liferay.object.internal.security.permission.resource.util.ObjectDefinitionResourcePermissionUtil;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectActionModel;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFolderItem;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectRelationshipTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableUtil;
import com.liferay.object.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectFolderItemLocalService;
import com.liferay.object.service.ObjectLayoutTabLocalService;
import com.liferay.object.service.base.ObjectRelationshipLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectActionPersistence;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.object.tree.Node;
import com.liferay.object.tree.ObjectDefinitionTreeFactory;
import com.liferay.object.tree.Tree;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.servlet.InitialRequestSyncUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectRelationship"}, service={AopService.class})
public class ObjectRelationshipLocalServiceImpl
extends ObjectRelationshipLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectRelationshipLocalServiceImpl.class);
    private static final Snapshot<ObjectDefinitionLocalService> _objectDefinitionLocalServiceSnapshot = new Snapshot(ObjectRelationshipLocalServiceImpl.class, ObjectDefinitionLocalService.class, null, true);
    private BundleContext _bundleContext;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private ObjectActionPersistence _objectActionPersistence;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFolderItemLocalService _objectFolderItemLocalService;
    @Reference
    private ObjectLayoutTabLocalService _objectLayoutTabLocalService;
    @Reference
    private RelatedInfoCollectionProviderFactory _relatedInfoCollectionProviderFactory;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship addObjectRelationship(String externalReferenceCode, long userId, long objectDefinitionId1, long objectDefinitionId2, long parameterObjectFieldId, String deletionType, boolean edge, Map<Locale, String> labelMap, String name, boolean system, String type, ObjectField objectField) throws PortalException {
        return this._addObjectRelationship(externalReferenceCode, userId, objectDefinitionId1, objectDefinitionId2, parameterObjectFieldId, deletionType, edge, labelMap, name, false, system, type, objectField);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship addObjectRelationship(String externalReferenceCode, long userId, long objectDefinitionId1, long objectDefinitionId2, ObjectField objectField) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validateExternalReferenceCode(externalReferenceCode, 0L, user.getCompanyId(), objectDefinitionId1);
        String objectFieldName = objectField.getName();
        return this._addObjectRelationship(externalReferenceCode, user, this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId1), this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId2), 0L, "prevent", false, (Map<Locale, String>)LocalizedMapUtil.getLocalizedMap((String)externalReferenceCode), objectFieldName.split("_")[1], false, false, "oneToMany", objectField);
    }

    public void addObjectRelationshipMappingTableValues(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2, ServiceContext serviceContext) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        this._validateObjectEntryId(objectDefinition1, primaryKey1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            if (this._hasManyToManyObjectRelationshipMappingTableValues(objectDefinition1, objectDefinition2, objectRelationship, primaryKey1, primaryKey2)) {
                return;
            }
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)objectRelationship.isReverse());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"insert into ", objectRelationship.getDBTableName(), " (", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), ", ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), ") values (", primaryKey1, ", ", primaryKey2, ")"}));
            FinderCacheUtil.clearDSLQueryCache((String)objectRelationship.getDBTableName());
            return;
        }
        ObjectField objectField2 = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        if (objectDefinition2.isUnmodifiableSystemObject()) {
            this._objectEntryLocalService.insertIntoOrUpdateExtensionTable(userId, objectRelationship.getObjectDefinitionId2(), primaryKey2, (Map)HashMapBuilder.put((Object)objectField2.getName(), (Object)primaryKey1).build());
        } else {
            this._objectEntryLocalService.partialUpdateObjectEntry(userId, primaryKey2, (Map)HashMapBuilder.put((Object)objectField2.getName(), (Object)primaryKey1).build(), serviceContext);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship createManyToManyObjectRelationshipTable(long userId, ObjectRelationship objectRelationship) throws PortalException {
        StringBuilder sb;
        ObjectRelationship existingObjectRelationship;
        if (Validator.isNotNull((String)objectRelationship.getDBTableName())) {
            return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        }
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        if (!objectDefinition1.isApproved() || !objectDefinition2.isApproved()) {
            return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        }
        String dbTableName = null;
        do {
            sb = new StringBuilder(5);
            sb.append("R_");
            sb.append(StringUtil.toUpperCase((String)StringUtil.randomId((int)1)));
            sb.append(RandomUtil.nextInt((int)10));
            sb.append(StringUtil.toUpperCase((String)StringUtil.randomId((int)1)));
            sb.append(RandomUtil.nextInt((int)10));
        } while ((existingObjectRelationship = this.objectRelationshipPersistence.fetchByDTN_R(sb.toString(), false)) != null);
        dbTableName = sb.toString();
        objectRelationship.setDBTableName(dbTableName);
        objectRelationship = this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        ObjectRelationship reverseObjectRelationship = this.fetchReverseObjectRelationship(objectRelationship, true);
        reverseObjectRelationship.setDBTableName(objectRelationship.getDBTableName());
        this.objectRelationshipLocalService.updateObjectRelationship(reverseObjectRelationship);
        Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)false);
        String pkObjectFieldDBColumnName1 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1");
        String pkObjectFieldDBColumnName2 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2");
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable(pkObjectFieldDBColumnName1, pkObjectFieldDBColumnName2, objectRelationship.getDBTableName());
        this.runSQL(dynamicObjectRelationshipMappingTable.getCreateTableSQL());
        Connection connection = this._currentConnection.getConnection(this.objectRelationshipPersistence.getDataSource());
        ObjectDBManagerUtil.createIndexMetadata(connection, objectRelationship.getDBTableName(), false, pkObjectFieldDBColumnName1);
        ObjectDBManagerUtil.createIndexMetadata(connection, objectRelationship.getDBTableName(), false, pkObjectFieldDBColumnName2);
        return objectRelationship;
    }

    @Override
    public ObjectRelationship deleteObjectRelationship(long objectRelationshipId) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        return this.objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectRelationship deleteObjectRelationship(ObjectRelationship objectRelationship) throws PortalException {
        ServiceRegistration<?> serviceRegistration;
        if (objectRelationship.isEdge()) {
            throw new ObjectRelationshipEdgeException("Edge object relationships cannot be deleted", "edge-object-relationships-cannot-be-deleted");
        }
        if (objectRelationship.isReverse()) {
            throw new ObjectRelationshipReverseException("Reverse object relationships cannot be deleted");
        }
        this._validateInvokerBundle("Only allowed bundles can delete system object relationships", objectRelationship.isSystem());
        objectRelationship = (ObjectRelationship)this.objectRelationshipPersistence.remove((BaseModel)objectRelationship);
        this._deleteObjectFields(objectRelationship.getObjectDefinitionId1(), objectRelationship);
        this._deleteObjectFields(objectRelationship.getObjectDefinitionId2(), objectRelationship);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        this._objectFolderItemLocalService.deleteObjectFolderItem(objectRelationship.getObjectDefinitionId2(), objectDefinition1.getObjectFolderId());
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        this._objectFolderItemLocalService.deleteObjectFolderItem(objectRelationship.getObjectDefinitionId1(), objectDefinition2.getObjectFolderId());
        this._objectLayoutTabLocalService.deleteObjectRelationshipObjectLayoutTabs(objectRelationship.getObjectRelationshipId());
        if (Objects.equals(objectRelationship.getType(), "oneToOne") || Objects.equals(objectRelationship.getType(), "oneToMany")) {
            this._objectFieldLocalService.deleteRelationshipTypeObjectField(objectRelationship.getObjectFieldId2());
            for (ObjectRelationship parameterObjectFieldIdObjectRelationship : this.objectRelationshipPersistence.findByParameterObjectFieldId(objectRelationship.getObjectFieldId2())) {
                this.objectRelationshipLocalService.deleteObjectRelationship(parameterObjectFieldIdObjectRelationship);
            }
        } else if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            if (Validator.isNotNull((String)objectRelationship.getDBTableName())) {
                this.runSQL("drop table " + objectRelationship.getDBTableName());
            }
            ObjectRelationship reverseObjectRelationship = this.fetchReverseObjectRelationship(objectRelationship, true);
            this._objectLayoutTabLocalService.deleteObjectRelationshipObjectLayoutTabs(reverseObjectRelationship.getObjectRelationshipId());
            this.objectRelationshipPersistence.remove(reverseObjectRelationship.getObjectRelationshipId());
            ServiceRegistration<?> serviceRegistration2 = this._serviceRegistrations.get(this._getServiceRegistrationKey(reverseObjectRelationship));
            if (serviceRegistration2 != null) {
                serviceRegistration2.unregister();
                this._serviceRegistrations.remove(this._getServiceRegistrationKey(reverseObjectRelationship));
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectRelationship.class);
            indexer.delete((Object)reverseObjectRelationship);
        }
        if ((serviceRegistration = this._serviceRegistrations.get(this._getServiceRegistrationKey(objectRelationship))) != null) {
            serviceRegistration.unregister();
            this._serviceRegistrations.remove(this._getServiceRegistrationKey(objectRelationship));
        }
        return objectRelationship;
    }

    public void deleteObjectRelationshipMappingTableValues(long objectRelationshipId, long primaryKey1) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1()), (ObjectDefinition)this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2()), (boolean)objectRelationship.isReverse());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", objectRelationship.getDBTableName(), " where ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), " = ", primaryKey1}));
            FinderCacheUtil.clearDSLQueryCache((String)objectRelationship.getDBTableName());
        }
    }

    public void deleteObjectRelationshipMappingTableValues(long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)objectRelationship.isReverse());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", objectRelationship.getDBTableName(), " where ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), " = ", primaryKey1, " and ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), " = ", primaryKey2}));
            FinderCacheUtil.clearDSLQueryCache((String)objectRelationship.getDBTableName());
        }
    }

    public void deleteObjectRelationships(long objectDefinitionId1) throws PortalException {
        for (ObjectRelationship objectRelationship : this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1)) {
            this.objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
    }

    public void deleteObjectRelationships(long objectDefinitionId1, boolean reverse) throws PortalException {
        for (ObjectRelationship objectRelationship : this.objectRelationshipPersistence.findByODI1_R(objectDefinitionId1, reverse)) {
            this.objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
    }

    public void disableEdge(long objectDefinitionId2) throws PortalException {
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId2);
        for (ObjectRelationship objectRelationship : this.getObjectRelationshipsByObjectDefinitionId2(objectDefinitionId2)) {
            ObjectDefinition objectDefinition1;
            if (!objectRelationship.isEdge() || (objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1())).getRootObjectDefinitionId() == objectDefinition2.getRootObjectDefinitionId()) continue;
            objectRelationship.setEdge(false);
            this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
        }
    }

    public ObjectRelationship fetchObjectRelationshipByExternalReferenceCode(String externalReferenceCode, long objectDefinitionId1) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId1);
        if (objectDefinition == null) {
            return null;
        }
        return this.objectRelationshipPersistence.fetchByERC_C_ODI1(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId1);
    }

    public ObjectRelationship fetchObjectRelationshipByExternalReferenceCode(String externalReferenceCode, long companyId, long objectDefinitionId1) {
        return this.objectRelationshipPersistence.fetchByERC_C_ODI1(externalReferenceCode, companyId, objectDefinitionId1);
    }

    public ObjectRelationship fetchObjectRelationshipByObjectDefinitionId(long objectDefinitionId, String name) {
        List objectRelationships = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)ObjectRelationshipTable.INSTANCE).where(Predicate.withParentheses((Predicate)ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectDefinitionId).or((Expression)ObjectRelationshipTable.INSTANCE.objectDefinitionId2.eq((Object)objectDefinitionId))).and((Expression)ObjectRelationshipTable.INSTANCE.name.eq((Object)name)).and((Expression)ObjectRelationshipTable.INSTANCE.reverse.eq((Object)false))));
        if (objectRelationships.isEmpty()) {
            return null;
        }
        return (ObjectRelationship)objectRelationships.get(0);
    }

    public ObjectRelationship fetchObjectRelationshipByObjectDefinitionId1(long objectDefinitionId1, String name) {
        return this.objectRelationshipPersistence.fetchByODI1_N_First(objectDefinitionId1, name, null);
    }

    public ObjectRelationship fetchObjectRelationshipByObjectFieldId2(long objectFieldId2) {
        return this.objectRelationshipPersistence.fetchByObjectFieldId2(objectFieldId2);
    }

    public ObjectRelationship fetchReverseObjectRelationship(ObjectRelationship objectRelationship, boolean reverse) {
        return this.objectRelationshipPersistence.fetchByODI1_ODI2_N_R_T(objectRelationship.getObjectDefinitionId2(), objectRelationship.getObjectDefinitionId1(), objectRelationship.getName(), reverse, objectRelationship.getType());
    }

    public List<ObjectRelationship> getAllObjectRelationships(long objectDefinitionId) {
        if (InitialRequestSyncUtil.isSynced()) {
            return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)ObjectRelationshipTable.INSTANCE).where(Predicate.withParentheses((Predicate)ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectDefinitionId).or((Expression)ObjectRelationshipTable.INSTANCE.objectDefinitionId2.eq((Object)objectDefinitionId))).and((Expression)ObjectRelationshipTable.INSTANCE.reverse.eq((Object)false))));
        }
        ArrayList<ObjectRelationship> objectRelationships = new ArrayList<ObjectRelationship>();
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition == null) {
            return objectRelationships;
        }
        for (ObjectRelationship objectRelationship : this.objectRelationshipPersistence.findByCompanyId(objectDefinition.getCompanyId())) {
            if (objectRelationship.getObjectDefinitionId1() != objectDefinitionId && objectRelationship.getObjectDefinitionId2() != objectDefinitionId || objectRelationship.isReverse()) continue;
            objectRelationships.add(objectRelationship);
        }
        return objectRelationships;
    }

    public ObjectRelationship getObjectRelationship(long objectDefinitionId1, String name) throws PortalException {
        try {
            return ObjectRelationshipUtil.getObjectRelationship((List)this.objectRelationshipPersistence.findByODI1_N(objectDefinitionId1, name));
        }
        catch (NoSuchObjectRelationshipException noSuchObjectRelationshipException) {
            throw new NoSuchObjectRelationshipException(String.format("No ObjectRelationship exists with the key {objectDefinitionId1=%s, name=%s}", objectDefinitionId1, name), (Throwable)noSuchObjectRelationshipException);
        }
    }

    public ObjectRelationship getObjectRelationshipByExternalReferenceCode(String externalReferenceCode, long companyId, long objectDefinitionId1) throws PortalException {
        return this.objectRelationshipPersistence.findByERC_C_ODI1(externalReferenceCode, companyId, objectDefinitionId1);
    }

    public ObjectRelationship getObjectRelationshipByObjectDefinitionId(long objectDefinitionId, String name) throws PortalException {
        List objectRelationships = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)ObjectRelationshipTable.INSTANCE).where(Predicate.withParentheses((Predicate)ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectDefinitionId).or((Expression)ObjectRelationshipTable.INSTANCE.objectDefinitionId2.eq((Object)objectDefinitionId))).and((Expression)ObjectRelationshipTable.INSTANCE.name.eq((Object)name)).and((Expression)ObjectRelationshipTable.INSTANCE.reverse.eq((Object)false))));
        if (objectRelationships.isEmpty()) {
            throw new NoSuchObjectRelationshipException("No object relationship exists with the name " + name);
        }
        return (ObjectRelationship)objectRelationships.get(0);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, boolean edge) {
        return this.objectRelationshipPersistence.findByODI1_E(objectDefinitionId1, edge);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, int start, int end) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1, start, end);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, long objectDefinition2, String type) {
        return this.objectRelationshipPersistence.findByODI1_ODI2_T(objectDefinitionId1, objectDefinition2, type);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId, String type) {
        Set objectRelationships = SetUtil.fromList((List)this.objectRelationshipPersistence.findByODI1_R_T(objectDefinitionId, false, type));
        objectRelationships.addAll(this.objectRelationshipPersistence.findByODI2_R_T(objectDefinitionId, false, type));
        return ListUtil.fromCollection((Collection)objectRelationships);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, String deletionType, boolean reverse) {
        return this.objectRelationshipPersistence.findByODI1_DT_R(objectDefinitionId1, deletionType, reverse);
    }

    public List<ObjectRelationship> getObjectRelationshipsByObjectDefinitionId2(long objectDefinitionId2) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId2(objectDefinitionId2);
    }

    public List<ObjectRelationship> getObjectRelationshipsByObjectDefinitionId2(long objectDefinitionId2, String type) {
        return this.objectRelationshipPersistence.findByODI2_R_T(objectDefinitionId2, false, type);
    }

    public Map<Long, List<ObjectRelationship>> getObjectRelationshipsMap(long companyId) {
        HashMap<Long, List<ObjectRelationship>> objectRelationshipsMap = new HashMap<Long, List<ObjectRelationship>>();
        for (ObjectRelationship objectRelationship : this.objectRelationshipPersistence.findByCompanyId(companyId)) {
            List objectRelationships = objectRelationshipsMap.computeIfAbsent(objectRelationship.getObjectDefinitionId1(), objectDefinitionId -> new ArrayList());
            objectRelationships.add(objectRelationship);
        }
        return objectRelationshipsMap;
    }

    public void registerObjectRelationshipsRelatedInfoCollectionProviders(ObjectDefinition objectDefinition1, ObjectDefinitionLocalService objectDefinitionLocalService, List<ObjectRelationship> objectRelationships) {
        if (objectRelationships == null) {
            objectRelationships = this.objectRelationshipLocalService.getObjectRelationships(objectDefinition1.getObjectDefinitionId());
        }
        for (ObjectRelationship objectRelationship : objectRelationships) {
            if (!objectRelationship.isAllowedObjectRelationshipType(objectRelationship.getType())) continue;
            try {
                ObjectDefinition objectDefinition2 = objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
                this._registerRelatedInfoItemCollectionProvider(objectDefinition1, objectDefinition2, objectRelationship);
                if (!Objects.equals(objectRelationship.getType(), "manyToMany")) continue;
                this._registerRelatedInfoItemCollectionProvider(objectDefinition2, objectDefinition1, this.objectRelationshipLocalService.getObjectRelationship(objectRelationship.getObjectDefinitionId2(), objectRelationship.getName()));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship updateObjectRelationship(String externalReferenceCode, long objectRelationshipId, long parameterObjectFieldId, String deletionType, boolean edge, Map<Locale, String> labelMap, ObjectField objectField) throws PortalException {
        ObjectRelationship objectRelationship;
        if (Validator.isNull((String)deletionType)) {
            deletionType = "prevent";
        }
        if ((objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId)).isSystem() && !ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            objectRelationship.setLabelMap(labelMap);
            return (ObjectRelationship)this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
        }
        this._validateExternalReferenceCode(externalReferenceCode, objectRelationshipId, objectRelationship.getCompanyId(), objectRelationship.getObjectDefinitionId1());
        if (objectRelationship.isReverse()) {
            objectRelationship.setExternalReferenceCode(externalReferenceCode);
            return (ObjectRelationship)this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
        }
        this._validateParameterObjectFieldId(this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1()), this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2()), parameterObjectFieldId, objectRelationship.getType());
        this._validateDeletionType(deletionType, edge, objectRelationship);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        this._validateEdge(edge, objectDefinition1, objectDefinition2, objectRelationship, objectRelationship.getType());
        if (objectRelationship.compareType("manyToMany")) {
            ObjectRelationship reverseObjectRelationship = this.fetchReverseObjectRelationship(objectRelationship, true);
            this._updateObjectRelationship(reverseObjectRelationship.getExternalReferenceCode(), parameterObjectFieldId, deletionType, labelMap, reverseObjectRelationship);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectRelationship.class);
            indexer.reindex((Object)reverseObjectRelationship);
        } else if (objectField != null && (objectRelationship.compareType("oneToOne") || objectRelationship.compareType("oneToMany"))) {
            ObjectField existingObjectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            this._objectFieldLocalService.updateObjectField(objectField.getExternalReferenceCode(), existingObjectField.getObjectFieldId(), existingObjectField.getUserId(), existingObjectField.getListTypeDefinitionId(), existingObjectField.getObjectDefinitionId(), existingObjectField.getBusinessType(), existingObjectField.getDBColumnName(), existingObjectField.getDBTableName(), existingObjectField.getDBType(), existingObjectField.isIndexed(), existingObjectField.isIndexedAsKeyword(), existingObjectField.getIndexedLanguageId(), objectField.getLabelMap(), existingObjectField.isLocalized(), existingObjectField.getName(), objectField.getReadOnly(), objectField.getReadOnlyConditionExpression(), objectField.isRequired(), existingObjectField.isState(), existingObjectField.isSystem(), existingObjectField.getObjectFieldSettings());
        }
        objectRelationship = this._updateObjectRelationship(externalReferenceCode, parameterObjectFieldId, deletionType, labelMap, objectRelationship);
        if (objectRelationship.getObjectFieldId2() != 0L && StringUtil.equals((String)deletionType, (String)"disassociate")) {
            this._objectFieldLocalService.updateRequired(objectRelationship.getObjectFieldId2(), false);
        }
        if (edge && !objectRelationship.isEdge() && FeatureFlagManagerUtil.isEnabled((long)objectRelationship.getCompanyId(), (String)"LPD-34594")) {
            this._bindObjectDefinitions(objectRelationship);
        } else if (!edge && objectRelationship.isEdge() && FeatureFlagManagerUtil.isEnabled((long)objectRelationship.getCompanyId(), (String)"LPD-34594")) {
            this._unbindObjectDefinitions(objectRelationship);
        }
        return objectRelationship;
    }

    public void updateUserId(long companyId, long oldUserId, long newUserId) throws PortalException {
        for (ObjectRelationship objectRelationship : this.objectRelationshipPersistence.findByC_U(companyId, oldUserId)) {
            objectRelationship.setUserId(newUserId);
            this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Override
    protected void runSQL(String sql) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        super.runSQL(sql);
    }

    private void _addArguments(List<Object> arguments, ObjectDefinition objectDefinition) throws PortalException {
        int incompleteWorkflowInstancesCount = 0;
        incompleteWorkflowInstancesCount = objectDefinition.isRootDescendantNode() ? this._getIncompleteWorkflowInstancesCount(this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinition.getRootObjectDefinitionId())) : this._getIncompleteWorkflowInstancesCount(objectDefinition);
        if (incompleteWorkflowInstancesCount > 0) {
            arguments.add(objectDefinition.getLabel(LocaleUtil.getSiteDefault()));
            arguments.add(incompleteWorkflowInstancesCount);
        }
    }

    private ObjectField _addObjectField(String externalReferenceCode, User user, ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, String dbColumnName, Map<Locale, String> labelMap, String name, String readOnly, String readOnlyConditionExpression, String relationshipType, boolean required, boolean system) throws PortalException {
        this._objectFieldLocalService.validateExternalReferenceCode(externalReferenceCode, 0L, objectDefinition2.getCompanyId(), objectDefinition2.getObjectDefinitionId());
        this._objectFieldLocalService.validateReadOnlyAndReadOnlyConditionExpression("Relationship", readOnly, readOnlyConditionExpression, required);
        this._objectFieldLocalService.validateRequired("Relationship", objectDefinition2.isApproved(), null, required);
        ObjectField objectField = this._objectFieldPersistence.create(this.counterLocalService.increment());
        objectField.setExternalReferenceCode(externalReferenceCode);
        objectField.setCompanyId(user.getCompanyId());
        objectField.setUserId(user.getUserId());
        objectField.setUserName(user.getFullName());
        objectField.setListTypeDefinitionId(0L);
        objectField.setObjectDefinitionId(objectDefinition2.getObjectDefinitionId());
        objectField.setBusinessType("Relationship");
        objectField.setSystem(system);
        if (Validator.isNull((String)dbColumnName)) {
            dbColumnName = ObjectRelationshipUtil.getObjectRelationshipFieldName((ObjectDefinition)objectDefinition1, (String)name);
        }
        objectField.setDBColumnName(dbColumnName);
        String dbTableName = objectDefinition2.getDBTableName();
        if (objectDefinition2.isApproved()) {
            dbTableName = objectDefinition2.getExtensionDBTableName();
        }
        objectField.setDBTableName(dbTableName);
        objectField.setDBType("Long");
        objectField.setIndexed(true);
        objectField.setIndexedAsKeyword(false);
        objectField.setIndexedLanguageId(null);
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectField.setName(dbColumnName);
        objectField.setReadOnly(readOnly);
        objectField.setReadOnlyConditionExpression(readOnlyConditionExpression);
        objectField.setRelationshipType(relationshipType);
        objectField.setRequired(required);
        objectField = this._objectFieldLocalService.updateObjectField(objectField);
        this._objectFieldSettingLocalService.addObjectFieldSetting(user.getUserId(), objectField.getObjectFieldId(), "objectDefinition1ShortName", objectDefinition1.getShortName());
        this._objectFieldSettingLocalService.addObjectFieldSetting(user.getUserId(), objectField.getObjectFieldId(), "objectRelationshipERCObjectFieldName", StringUtil.replaceLast((String)objectField.getName(), (String)"Id", (String)"ERC"));
        if (!objectDefinition2.isApproved()) {
            return objectField;
        }
        this.runSQL(DynamicObjectDefinitionTableUtil.getAlterTableAddColumnSQL((String)dbTableName, (String)objectField.getBusinessType(), (String)objectField.getDBColumnName(), (String)"Long"));
        ObjectDBManagerUtil.createIndexMetadata(this._currentConnection.getConnection(this.objectRelationshipPersistence.getDataSource()), dbTableName, false, objectField.getDBColumnName());
        ObjectDefinitionLocalService objectDefinitionLocalService = (ObjectDefinitionLocalService)_objectDefinitionLocalServiceSnapshot.get();
        if (objectDefinitionLocalService != null) {
            objectDefinitionLocalService.deployObjectDefinition(objectDefinition2);
        }
        return objectField;
    }

    private void _addObjectFolderItem(long userId, long objectDefinitionId, long objectFolderId) throws PortalException {
        ObjectFolderItem objectFolderItem = this._objectFolderItemLocalService.fetchObjectFolderItem(objectDefinitionId, objectFolderId);
        if (objectFolderItem != null) {
            return;
        }
        this._objectFolderItemLocalService.addObjectFolderItem(userId, objectDefinitionId, objectFolderId, 0, 0);
    }

    private ObjectRelationship _addObjectRelationship(String externalReferenceCode, long userId, long objectDefinitionId1, long objectDefinitionId2, long parameterObjectFieldId, String deletionType, boolean edge, Map<Locale, String> labelMap, String name, boolean reverse, boolean system, String type, ObjectField objectField) throws PortalException {
        this._validateInvokerBundle("Only allowed bundles can add system object relationships", system);
        User user = this._userLocalService.getUser(userId);
        this._validateExternalReferenceCode(externalReferenceCode, 0L, user.getCompanyId(), objectDefinitionId1);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId2);
        this._validateEdge(edge, objectDefinition1, objectDefinition2, null, type);
        this._validateName(objectDefinition1, objectDefinition2, name);
        this._validateType(objectDefinition1, objectDefinition2, name, parameterObjectFieldId, type);
        return this._addObjectRelationship(externalReferenceCode, user, objectDefinition1, objectDefinition2, parameterObjectFieldId, deletionType, edge, labelMap, name, reverse, system, type, objectField);
    }

    private ObjectRelationship _addObjectRelationship(String externalReferenceCode, User user, ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, long parameterObjectFieldId, String deletionType, boolean edge, Map<Locale, String> labelMap, String name, boolean reverse, boolean system, String type, ObjectField objectField) throws PortalException {
        this._validateScope(objectDefinition1, objectDefinition2);
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.create(this.counterLocalService.increment());
        objectRelationship.setExternalReferenceCode(externalReferenceCode);
        objectRelationship.setCompanyId(user.getCompanyId());
        objectRelationship.setUserId(user.getUserId());
        objectRelationship.setUserName(user.getFullName());
        objectRelationship.setObjectDefinitionId1(objectDefinition1.getObjectDefinitionId());
        objectRelationship.setObjectDefinitionId2(objectDefinition2.getObjectDefinitionId());
        objectRelationship.setParameterObjectFieldId(parameterObjectFieldId);
        objectRelationship.setDeletionType(GetterUtil.getString((String)deletionType, (String)"prevent"));
        objectRelationship.setEdge(edge);
        objectRelationship.setLabelMap(labelMap);
        objectRelationship.setName(name);
        objectRelationship.setReverse(reverse);
        objectRelationship.setSystem(system);
        objectRelationship.setType(type);
        this._addObjectFolderItem(user.getUserId(), objectDefinition1.getObjectDefinitionId(), objectDefinition2.getObjectFolderId());
        this._addObjectFolderItem(user.getUserId(), objectDefinition2.getObjectDefinitionId(), objectDefinition1.getObjectFolderId());
        if (Objects.equals(type, "oneToOne") || Objects.equals(type, "oneToMany")) {
            if (objectField != null) {
                Map objectFieldLabelMap = objectField.getLabelMap();
                if (objectFieldLabelMap.isEmpty()) {
                    objectFieldLabelMap = objectRelationship.getLabelMap();
                }
                objectField = this._addObjectField(objectField.getExternalReferenceCode(), user, objectDefinition1, objectDefinition2, objectField.getName(), objectFieldLabelMap, name, objectField.getReadOnly(), objectField.getReadOnlyConditionExpression(), type, objectField.isRequired(), system);
            } else {
                objectField = this._addObjectField(null, user, objectDefinition1, objectDefinition2, null, objectRelationship.getLabelMap(), name, "false", "", type, false, system);
            }
            objectRelationship.setObjectFieldId2(objectField.getObjectFieldId());
        } else if (Objects.equals(type, "manyToMany") && !reverse) {
            this._registerRelatedInfoItemCollectionProvider(objectDefinition1, objectDefinition2, objectRelationship);
            this._addObjectRelationship(null, user.getUserId(), objectDefinition2.getObjectDefinitionId(), objectDefinition1.getObjectDefinitionId(), parameterObjectFieldId, deletionType, false, labelMap, name, true, system, type, objectField);
            return this.objectRelationshipLocalService.createManyToManyObjectRelationshipTable(user.getUserId(), objectRelationship);
        }
        this._registerRelatedInfoItemCollectionProvider(objectDefinition1, objectDefinition2, objectRelationship);
        if (edge && FeatureFlagManagerUtil.isEnabled((long)objectRelationship.getCompanyId(), (String)"LPD-34594")) {
            this._bindObjectDefinitions(objectRelationship);
        }
        return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
    }

    private void _bindObjectDefinitions(ObjectRelationship objectRelationship) throws PortalException {
        ObjectDefinition rootObjectDefinition;
        objectRelationship.setDeletionType("cascade");
        objectRelationship.setEdge(true);
        objectRelationship = this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        this._objectFieldLocalService.updateRequired(objectRelationship.getObjectFieldId2(), true);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        String objectDefinition1PreviousRESTContextPath = objectDefinition1.getRESTContextPath();
        if (objectDefinition1.getRootObjectDefinitionId() == 0L) {
            objectDefinition1.setRootObjectDefinitionId(objectDefinition1.getObjectDefinitionId());
        }
        ObjectDefinitionLocalService objectDefinitionLocalService = (ObjectDefinitionLocalService)_objectDefinitionLocalServiceSnapshot.get();
        objectDefinition1 = objectDefinitionLocalService.updateObjectDefinition(objectDefinition1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        if (objectDefinition1.isApproved() == objectDefinition2.isApproved()) {
            if (objectDefinition1.isApproved()) {
                objectDefinition1.setPreviousRESTContextPath(objectDefinition1PreviousRESTContextPath);
                objectDefinitionLocalService.deployObjectDefinition(objectDefinition1);
                if (objectDefinition2.isApproved() && !objectRelationship.isNew()) {
                    this._objectEntryLocalService.updateRootObjectEntryIds(objectDefinition1, objectDefinition2, objectRelationship);
                }
            }
            ObjectDefinitionTreeFactory objectDefinitionTreeFactory = new ObjectDefinitionTreeFactory(objectDefinitionLocalService, this.objectRelationshipLocalService);
            Tree tree = objectDefinitionTreeFactory.create(objectDefinition2.getObjectDefinitionId());
            for (Node node : tree) {
                ObjectDefinition nodeObjectDefinition = objectDefinitionLocalService.fetchObjectDefinition(node.getPrimaryKey());
                String nodeObjectDefinitionPreviousRESTContextPath = nodeObjectDefinition.getRESTContextPath();
                if (!(nodeObjectDefinition = objectDefinitionLocalService.updateRootDescendantNodeObjectDefinition(nodeObjectDefinition, objectDefinition1.getRootObjectDefinitionId())).isApproved() || !objectDefinition1.isApproved()) continue;
                nodeObjectDefinition.setPreviousRESTContextPath(nodeObjectDefinitionPreviousRESTContextPath);
                objectDefinitionLocalService.deployObjectDefinition(nodeObjectDefinition);
            }
        } else {
            if (objectDefinition2.isRootNode()) {
                return;
            }
            objectDefinition2.setRootObjectDefinitionId(objectDefinition2.getObjectDefinitionId());
            objectDefinition2 = objectDefinitionLocalService.updateObjectDefinition(objectDefinition2);
            if (objectDefinition2.isApproved()) {
                objectDefinitionLocalService.deployObjectDefinition(objectDefinition2);
            }
        }
        if ((rootObjectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinition1.getRootObjectDefinitionId())).isApproved()) {
            objectDefinitionLocalService.deployObjectDefinition(rootObjectDefinition);
        }
    }

    private void _copyResourcePermissions(List<ResourceAction> sourceResourceActions, List<ResourcePermission> sourceResourcePermissions, String targetName, List<String> targetObjectActionNames, String targetPrimKey) throws PortalException {
        for (ResourcePermission sourceResourcePermission : sourceResourcePermissions) {
            ArrayList<String> targetResourceActionIds = new ArrayList<String>();
            for (ResourceAction sourceResourceAction : sourceResourceActions) {
                long bitwiseValue = sourceResourceAction.getBitwiseValue();
                if ((sourceResourcePermission.getActionIds() & bitwiseValue) != bitwiseValue) continue;
                targetResourceActionIds.add(sourceResourceAction.getActionId());
            }
            if (ListUtil.isNotEmpty(targetObjectActionNames)) {
                targetResourceActionIds.addAll(this._resourcePermissionLocalService.getAvailableResourcePermissionActionIds(sourceResourcePermission.getCompanyId(), targetName, sourceResourcePermission.getScope(), targetPrimKey, sourceResourcePermission.getRoleId(), targetObjectActionNames));
            }
            this._resourcePermissionLocalService.setResourcePermissions(sourceResourcePermission.getCompanyId(), targetName, sourceResourcePermission.getScope(), targetPrimKey, sourceResourcePermission.getRoleId(), targetResourceActionIds.toArray(new String[0]));
        }
    }

    private void _copyResourcePermissions(long companyId, String sourceName, String targetName, List<String> targetObjectActionNames) throws PortalException {
        List resourceActions = this._resourceActionLocalService.getResourceActions(sourceName);
        this._copyResourcePermissions(resourceActions, this._resourcePermissionLocalService.getResourcePermissions(companyId, sourceName, 1, String.valueOf(companyId)), targetName, targetObjectActionNames, String.valueOf(companyId));
        this._copyResourcePermissions(resourceActions, this._resourcePermissionLocalService.getResourcePermissions(companyId, sourceName, 3, String.valueOf(0L)), targetName, targetObjectActionNames, String.valueOf(0L));
    }

    private void _copyResourcePermissions(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2) throws PortalException {
        if (!objectDefinition1.isApproved() || !objectDefinition2.isApproved()) {
            return;
        }
        List objectActionNames = TransformUtil.transform((Collection)this._objectActionPersistence.findByO_A_OATK(objectDefinition2.getObjectDefinitionId(), true, "standalone"), ObjectActionModel::getName);
        List resourceActions = this._resourceActionLocalService.getResourceActions(objectDefinition1.getClassName());
        this._performActions(objectDefinition2.getObjectDefinitionId(), true, objectEntry -> this._copyResourcePermissions(resourceActions, this._resourcePermissionLocalService.getResourcePermissions(objectDefinition1.getCompanyId(), objectDefinition1.getClassName(), 4, String.valueOf(objectEntry.getRootObjectEntryId())), objectDefinition2.getClassName(), objectActionNames, String.valueOf(objectEntry.getObjectEntryId())));
        this._copyResourcePermissions(objectDefinition1.getCompanyId(), objectDefinition1.getClassName(), objectDefinition2.getClassName(), objectActionNames);
        this._copyResourcePermissions(objectDefinition1.getCompanyId(), objectDefinition1.getPortletId(), objectDefinition2.getPortletId(), null);
        this._copyResourcePermissions(objectDefinition1.getCompanyId(), objectDefinition1.getResourceName(), objectDefinition2.getResourceName(), null);
    }

    private void _copyWorkflowDefinitionLinks(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2) throws PortalException {
        if (!objectDefinition1.isApproved() || !objectDefinition2.isApproved()) {
            return;
        }
        for (WorkflowDefinitionLink workflowDefinitionLink : this._workflowDefinitionLinkLocalService.getWorkflowDefinitionLinks(objectDefinition1.getCompanyId(), objectDefinition1.getClassName())) {
            this._workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(workflowDefinitionLink.getUserId(), workflowDefinitionLink.getCompanyId(), workflowDefinitionLink.getGroupId(), objectDefinition2.getClassName(), 0L, 0L, workflowDefinitionLink.getWorkflowDefinitionName(), workflowDefinitionLink.getWorkflowDefinitionVersion());
        }
    }

    private void _deleteObjectFields(long objectDefinitionId, ObjectRelationship objectRelationship) throws PortalException {
        for (ObjectField objectField : this._objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId)) {
            ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectField.getObjectFieldId(), "objectRelationshipName");
            if (objectFieldSetting == null || !StringUtil.equals((String)objectFieldSetting.getValue(), (String)objectRelationship.getName())) continue;
            this._objectFieldLocalService.deleteObjectField(objectField.getObjectFieldId());
        }
    }

    private void _deployObjectDefinition(ObjectDefinition objectDefinition) throws PortalException {
        if (!objectDefinition.isApproved()) {
            return;
        }
        ObjectDefinitionLocalService objectDefinitionLocalService = (ObjectDefinitionLocalService)_objectDefinitionLocalServiceSnapshot.get();
        objectDefinitionLocalService.deployObjectDefinition(objectDefinition);
    }

    private int _getIncompleteWorkflowInstancesCount(ObjectDefinition objectDefinition) throws PortalException {
        HashSet<Long> classPKs = new HashSet<Long>();
        for (WorkflowInstanceLink workflowInstanceLink : this._workflowInstanceLinkLocalService.getWorkflowInstanceLinks(objectDefinition.getCompanyId(), objectDefinition.getClassName())) {
            WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)objectDefinition.getCompanyId(), (long)workflowInstanceLink.getWorkflowInstanceId());
            if (workflowInstance.isComplete()) continue;
            classPKs.add(workflowInstanceLink.getClassPK());
        }
        return classPKs.size();
    }

    private long _getRootObjectDefinitionId(ObjectDefinition objectDefinition) throws PortalException {
        long count = this.objectRelationshipPersistence.countByODI1_E(objectDefinition.getObjectDefinitionId(), true);
        if (count == 0L) {
            return 0L;
        }
        return objectDefinition.getObjectDefinitionId();
    }

    private String _getServiceRegistrationKey(ObjectRelationship objectRelationship) {
        return StringBundler.concat((Object[])new Object[]{objectRelationship.getCompanyId(), "#", objectRelationship.getObjectRelationshipId()});
    }

    private boolean _hasManyToManyObjectRelationshipMappingTableValues(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, ObjectRelationship objectRelationship, long primaryKey1, long primaryKey2) {
        Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)objectRelationship.isReverse());
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable((String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), objectRelationship.getDBTableName());
        Column primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
        Column primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
        int count = this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)dynamicObjectRelationshipMappingTable).where(primaryKeyColumn1.eq((Object)primaryKey1).and((Expression)primaryKeyColumn2.eq((Object)primaryKey2))));
        return count > 0;
    }

    private void _performActions(long objectDefinitionId, boolean parallel, ActionableDynamicQuery.PerformActionMethod<?> performActionMethod) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._objectEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"objectDefinitionId", (Object)objectDefinitionId)));
        actionableDynamicQuery.setParallel(parallel);
        actionableDynamicQuery.setPerformActionMethod(performActionMethod);
        actionableDynamicQuery.performActions();
    }

    private void _registerRelatedInfoItemCollectionProvider(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, ObjectRelationship objectRelationship) throws PortalException {
        if (!objectDefinition1.isApproved() || !objectDefinition2.isApproved()) {
            return;
        }
        RelatedInfoItemCollectionProvider relatedInfoItemCollectionProvider = this._relatedInfoCollectionProviderFactory.create(objectDefinition1, objectDefinition2, objectRelationship);
        if (relatedInfoItemCollectionProvider == null) {
            return;
        }
        this._serviceRegistrations.computeIfAbsent(this._getServiceRegistrationKey(objectRelationship), serviceRegistrationKey -> this._bundleContext.registerService(RelatedInfoItemCollectionProvider.class, (Object)relatedInfoItemCollectionProvider, (Dictionary)HashMapDictionaryBuilder.put((Object)"company.id", (Object)objectDefinition1.getCompanyId()).put((Object)"item.class.name", (Object)objectDefinition1.getClassName()).build()));
    }

    private void _unbindObjectDefinitions(ObjectRelationship objectRelationship) throws PortalException {
        objectRelationship.setEdge(false);
        objectRelationship = this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        if (objectDefinition1.isRootDescendantNode()) {
            objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinition1.getRootObjectDefinitionId());
        }
        long oldRootObjectDefinitionId1 = objectDefinition1.getRootObjectDefinitionId();
        long newRootObjectDefinitionId1 = this._getRootObjectDefinitionId(objectDefinition1);
        this._updateRootObjectDefinitionId(objectDefinition1, oldRootObjectDefinitionId1, newRootObjectDefinitionId1);
        this._updateObjectEntries(objectDefinition1, oldRootObjectDefinitionId1, newRootObjectDefinitionId1);
        if (newRootObjectDefinitionId1 == 0L) {
            for (ObjectAction objectAction : this._objectActionPersistence.findByO_A_OATK(objectDefinition1.getObjectDefinitionId(), true, "onAfterRootUpdate")) {
                objectAction.setActive(false);
                objectAction.setObjectActionTriggerKey("onAfterUpdate");
                this._objectActionPersistence.update((BaseModel)objectAction);
            }
        }
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        objectDefinition2.setScope(objectDefinition1.getScope());
        long oldRootObjectDefinitionId2 = objectDefinition2.getRootObjectDefinitionId();
        long newRootObjectDefinitionId2 = this._getRootObjectDefinitionId(objectDefinition2);
        this._updateRootObjectDefinitionId(objectDefinition2, oldRootObjectDefinitionId2, newRootObjectDefinitionId2);
        this._copyResourcePermissions(objectDefinition1, objectDefinition2);
        this._updateObjectEntries(objectDefinition2, oldRootObjectDefinitionId2, newRootObjectDefinitionId2);
        this._updateObjectDefinitionTree(objectDefinition2, oldRootObjectDefinitionId2, newRootObjectDefinitionId2);
        this._copyWorkflowDefinitionLinks(objectDefinition1, objectDefinition2);
        if (objectDefinition2.isRootNode()) {
            this._deployObjectDefinition(objectDefinition2);
        }
    }

    private void _updateObjectDefinitionTree(ObjectDefinition objectDefinition1, long oldRootObjectDefinitionId, long newRootObjectDefinitionId) throws PortalException {
        try {
            ObjectDefinitionResourcePermissionUtil.populateRootDescendantNodeModelResources(this._objectActionPersistence, this._objectDefinitionPersistence, this._resourceActions, objectDefinition1, newRootObjectDefinitionId);
            ObjectDefinitionResourcePermissionUtil.removeRootDescendantNodeModelResources(this._objectDefinitionPersistence, this._resourceActions, objectDefinition1, oldRootObjectDefinitionId);
        }
        catch (Exception exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
        if (newRootObjectDefinitionId == 0L) {
            return;
        }
        for (ObjectRelationship objectRelationship : this.objectRelationshipLocalService.getObjectRelationships(objectDefinition1.getObjectDefinitionId(), true)) {
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            if (oldRootObjectDefinitionId != objectDefinition2.getRootObjectDefinitionId()) continue;
            this._updateRootObjectDefinitionId(objectDefinition2, oldRootObjectDefinitionId, newRootObjectDefinitionId);
            if (objectDefinition2.isApproved()) {
                ObjectField objectField = this._objectFieldPersistence.findByPrimaryKey(objectRelationship.getObjectFieldId2());
                this._performActions(objectDefinition1.getObjectDefinitionId(), true, objectEntry -> this.runSQL(StringBundler.concat((Object[])new Object[]{"update ObjectEntry set rootObjectEntryId = ", objectEntry.getRootObjectEntryId(), " where objectEntryId in (select ", objectDefinition2.getPKObjectFieldDBColumnName(), " from ", objectField.getDBTableName(), " where ", objectField.getDBColumnName(), " = ", objectEntry.getObjectEntryId(), ")"})));
                if (objectDefinition2.isEnableIndexSearch()) {
                    Indexer indexer = IndexerRegistryUtil.getIndexer((String)objectDefinition2.getClassName());
                    this._performActions(objectDefinition2.getObjectDefinitionId(), true, objectEntry -> indexer.reindex(objectEntry));
                }
            }
            this._updateObjectDefinitionTree(objectDefinition2, oldRootObjectDefinitionId, newRootObjectDefinitionId);
        }
    }

    private void _updateObjectEntries(ObjectDefinition objectDefinition, long oldRootObjectDefinitionId, long newRootObjectDefinitionId) throws PortalException {
        if (!objectDefinition.isApproved() || oldRootObjectDefinitionId == newRootObjectDefinitionId) {
            return;
        }
        this._performActions(objectDefinition.getObjectDefinitionId(), false, objectEntry -> {
            if (newRootObjectDefinitionId == 0L) {
                objectEntry.setRootObjectEntryId(0L);
            } else {
                objectEntry.setRootObjectEntryId(objectEntry.getObjectEntryId());
            }
            this._objectEntryLocalService.updateObjectEntry(objectEntry);
        });
    }

    private ObjectRelationship _updateObjectRelationship(String externalReferenceCode, long parameterObjectFieldId, String deletionType, Map<Locale, String> labelMap, ObjectRelationship objectRelationship) {
        objectRelationship.setExternalReferenceCode(externalReferenceCode);
        objectRelationship.setParameterObjectFieldId(parameterObjectFieldId);
        objectRelationship.setDeletionType(deletionType);
        objectRelationship.setLabelMap(labelMap);
        return (ObjectRelationship)this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
    }

    private void _updateRootObjectDefinitionId(ObjectDefinition objectDefinition, long oldRootObjectDefinitionId, long newRootObjectDefinitionId) throws PortalException {
        if (oldRootObjectDefinitionId == newRootObjectDefinitionId) {
            this._deployObjectDefinition(objectDefinition);
            return;
        }
        String previousRESTContextPath = objectDefinition.getRESTContextPath();
        objectDefinition.setRootObjectDefinitionId(newRootObjectDefinitionId);
        objectDefinition = (ObjectDefinition)this._objectDefinitionPersistence.update((BaseModel)objectDefinition);
        objectDefinition.setPreviousRESTContextPath(previousRESTContextPath);
        this._deployObjectDefinition(objectDefinition);
    }

    private void _validateDeletionType(String deletionType, boolean edge, ObjectRelationship objectRelationship) throws PortalException {
        if (edge && objectRelationship.isEdge() && !StringUtil.equals((String)deletionType, (String)"cascade")) {
            throw new ObjectRelationshipDeletionTypeException.MustHaveCascadeDeletionType();
        }
    }

    private void _validateEdge(boolean edge, ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, ObjectRelationship objectRelationship, String type) throws PortalException {
        long objectDefinition2RootObjectDefinitionId;
        Tree tree;
        if (!FeatureFlagManagerUtil.isEnabled((long)objectDefinition1.getCompanyId(), (String)"LPD-34594")) {
            return;
        }
        if (!edge && objectRelationship != null && objectRelationship.isEdge()) {
            ArrayList<Object> arguments = new ArrayList<Object>();
            this._addArguments(arguments, this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinition1.getRootObjectDefinitionId()));
            if (ListUtil.isNotEmpty(arguments)) {
                throw new ObjectRelationshipEdgeException(arguments, String.format("These ongoing workflow instances must be completed to disable inheritance: \"%s\" (\"%s\" object entries)", arguments.get(0), arguments.get(1)), "these-ongoing-workflow-instances-must-be-completed-to-disable-inheritance-x-(x-object-entries)");
            }
        }
        if (!edge || objectRelationship != null && objectRelationship.isEdge()) {
            return;
        }
        if (!Objects.equals(type, "oneToMany")) {
            throw new ObjectRelationshipEdgeException("Object relationship must be one to many to be an edge of a root context", "object-relationship-must-be-one-to-many-to-be-an-edge-of-a-root-context");
        }
        if (objectDefinition1.getObjectDefinitionId() == objectDefinition2.getObjectDefinitionId()) {
            throw new ObjectRelationshipEdgeException("Object relationship must not be a self-relationship to be an edge of a root context", "object-relationship-must-not-be-a-self-relationship-to-be-an-edge-of-a-root-context");
        }
        if (objectDefinition1.isModifiableAndSystem() && !objectDefinition2.isSystem() || objectDefinition2.isModifiableAndSystem() && !objectDefinition1.isSystem()) {
            throw new ObjectRelationshipEdgeException("Inheritance between modifiable system and custom object definitions is not allowed", "inheritance-between-modifiable-system-and-custom-object-definitions-is-not-allowed");
        }
        if (objectDefinition1.isUnmodifiableSystemObject() || objectDefinition2.isUnmodifiableSystemObject()) {
            throw new ObjectRelationshipEdgeException("System object definitions cannot inherit configurations", "system-object-definitions-cannot-inherit-configurations");
        }
        if (objectDefinition1.getRootObjectDefinitionId() != 0L && objectDefinition1.getRootObjectDefinitionId() == objectDefinition2.getObjectDefinitionId()) {
            throw new ObjectRelationshipEdgeException("The object relationship must not create a circular reference in a root context", "the-object-relationship-must-not-create-a-circular-reference-in-a-root-context");
        }
        int treeHeight = 1;
        ObjectDefinitionTreeFactory objectDefinitionTreeFactory = new ObjectDefinitionTreeFactory(this._objectDefinitionPersistence, this.objectRelationshipLocalService);
        if (objectDefinition1.getRootObjectDefinitionId() != 0L) {
            tree = objectDefinitionTreeFactory.create(objectDefinition1.getRootObjectDefinitionId());
            Node node = tree.getNode(objectDefinition1.getObjectDefinitionId());
            treeHeight += node.getDepth();
        }
        if (objectDefinition2.getRootObjectDefinitionId() != 0L) {
            tree = objectDefinitionTreeFactory.create(objectDefinition2.getRootObjectDefinitionId());
            treeHeight += tree.getHeight(tree.getRootNode());
        }
        if (treeHeight > 4) {
            throw new ObjectRelationshipEdgeException("The object relationship cannot be an edge in the root context because it would exceed the tree's maximum height", "the-object-relationship-cannot-be-an-edge-in-the-root-context-because-it-would-exceed-the-tree's-maximum-height");
        }
        if (objectDefinition1.isApproved() && objectDefinition2.isApproved()) {
            int relatedObjectEntriesCount;
            if (objectRelationship != null && objectRelationship.getObjectRelationshipId() != 0L && (relatedObjectEntriesCount = this._objectEntryLocalService.getOneToManyObjectEntriesCount(0L, objectRelationship.getObjectRelationshipId(), 0L, false, null)) > 0) {
                throw new ObjectRelationshipEdgeException(StringBundler.concat((String[])new String[]{"There must be no unrelated object entries when ", "both object definitions are published so that ", "the object relationship can be an edge to a root ", "context"}), StringBundler.concat((String[])new String[]{"there-must-be-no-unrelated-object-entries-when-", "both-object-definitions-are-published-so-that-", "the-object-relationship-can-be-an-edge-to-a-root-", "context"}));
            }
            ArrayList<Object> arguments = new ArrayList<Object>();
            this._addArguments(arguments, objectDefinition1);
            this._addArguments(arguments, objectDefinition2);
            if (arguments.size() == 2) {
                throw new ObjectRelationshipEdgeException(arguments, String.format("These ongoing workflow instances must be completed to enable inheritance: \"%s\" (\"%s\" object entries)", arguments.get(0), arguments.get(1)), "these-ongoing-workflow-instances-must-be-completed-to-enable-inheritance-x-(x-object-entries)");
            }
            if (arguments.size() == 4) {
                throw new ObjectRelationshipEdgeException(arguments, String.format("These ongoing workflow instances must be completed to enable inheritance: \"%s\" (\"%s\" object entries) and \"%s\" (\"%s\" object entries)", arguments.get(0), arguments.get(1), arguments.get(2), arguments.get(3)), "these-ongoing-workflow-instances-must-be-completed-to-enable-inheritance-x-(x-object-entries)-and-x-(x-object-entries)");
            }
        }
        if ((objectDefinition2RootObjectDefinitionId = objectDefinition2.getRootObjectDefinitionId()) != 0L && objectDefinition2RootObjectDefinitionId != objectDefinition2.getObjectDefinitionId()) {
            throw new ObjectRelationshipEdgeException("Unable to bind the object definitions when the child object definition is bound to another object definition", "unable-to-bind-the-object-definitions-when-the-child-object-definition-is-bound-to-another-object-definition");
        }
        if (!StringUtil.equals((String)objectDefinition1.getScope(), (String)objectDefinition2.getScope())) {
            throw new ObjectRelationshipEdgeException(Arrays.asList(objectDefinition1.getShortName(), objectDefinition2.getShortName()), String.format("The scope of \"%s\" is not the same as \"%s\". To enable inheritance, the object definitions must have the same scope", objectDefinition1.getShortName(), objectDefinition2.getShortName()), "the-scope-of-x-is-not-the-same-as-x-to-enable-inheritance-the-object-definitions-must-have-the-same-scope");
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long objectRelationshipId, long companyId, long objectDefinitionId1) {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.fetchByERC_C_ODI1(externalReferenceCode, companyId, objectDefinitionId1);
        if (objectRelationship != null && objectRelationship.getObjectRelationshipId() != objectRelationshipId) {
            throw new DuplicateObjectRelationshipExternalReferenceCodeException();
        }
    }

    private void _validateInvokerBundle(String message, boolean system) throws PortalException {
        if (!system || ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            return;
        }
        throw new ObjectRelationshipSystemException(message);
    }

    private void _validateName(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, String name) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectRelationshipNameException("Name is null");
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectRelationshipNameException("Name must only contain letters and digits");
        }
        if (!Character.isLowerCase(nameCharArray[0])) {
            throw new ObjectRelationshipNameException("The first character of a name must be a lower case letter");
        }
        if (nameCharArray.length > 41) {
            throw new ObjectRelationshipNameException("Name must be less than 41 characters");
        }
        int count = this.objectRelationshipPersistence.countByODI1_N(objectDefinition1.getObjectDefinitionId(), name);
        if (count > 0) {
            throw new DuplicateObjectRelationshipException(StringBundler.concat((String[])new String[]{"There is already an object relationship with this name ", "in the object definition \"", objectDefinition1.getShortName(), "\""}));
        }
        this._validateNameObjectFieldName(name, objectDefinition1);
        this._validateNameObjectFieldName(name, objectDefinition2);
        this._validateNameObjectRelationshipName(name, objectDefinition1);
        this._validateNameObjectRelationshipName(name, objectDefinition2);
    }

    private void _validateNameObjectFieldName(String name, ObjectDefinition objectDefinition) throws PortalException {
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getObjectDefinitionId(), name);
        if (objectField == null) {
            return;
        }
        throw new ObjectRelationshipNameException(StringBundler.concat((String[])new String[]{"There is already an object field with this name in the ", "object definition \"", objectDefinition.getShortName(), ".\" Object fields and object relationships cannot have the ", "same name."}));
    }

    private void _validateNameObjectRelationshipName(String name, ObjectDefinition objectDefinition) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), name);
        if (objectRelationship == null) {
            return;
        }
        if (objectRelationship.getObjectDefinitionId1() != objectDefinition.getObjectDefinitionId()) {
            objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        }
        throw new ObjectRelationshipNameException(StringBundler.concat((String[])new String[]{"There is already an object relationship with this name in ", "the object definition \"", objectDefinition.getShortName(), ".\" Parent and child object definitions cannot have the same ", "name."}));
    }

    private void _validateObjectEntryId(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            systemObjectDefinitionManager.getBaseModelExternalReferenceCode(primaryKey);
        } else {
            this._objectEntryLocalService.getObjectEntry(primaryKey);
        }
    }

    private void _validateParameterObjectFieldId(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, long parameterObjectFieldId, String type) throws PortalException {
        String restContextPath = "";
        if (!objectDefinition1.isUnmodifiableSystemObject()) {
            restContextPath = objectDefinition1.getRESTContextPath();
        } else {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition1.getName());
            if (systemObjectDefinitionManager != null) {
                JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
                restContextPath = jaxRsApplicationDescriptor.getRESTContextPath();
            }
        }
        boolean parameterRequired = restContextPath.matches(".*/\\{\\w+}/.*");
        if (parameterObjectFieldId == 0L && parameterRequired) {
            throw new ObjectRelationshipParameterObjectFieldIdException("Object definition " + objectDefinition1.getName() + " requires a parameter object field ID");
        }
        if (parameterObjectFieldId > 0L) {
            if (!Objects.equals(type, "oneToMany")) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Object relationship type " + type + " does not allow a parameter object field ID");
            }
            if (!parameterRequired) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Object definition " + objectDefinition1.getName() + " does not allow a parameter object field ID");
            }
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(parameterObjectFieldId);
            if (objectField == null) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Parameter object field ID " + parameterObjectFieldId + " does not exist");
            }
            if (objectDefinition2.getObjectDefinitionId() != objectField.getObjectDefinitionId()) {
                throw new ObjectRelationshipParameterObjectFieldIdException(StringBundler.concat((Object[])new Object[]{"Parameter object field ID ", parameterObjectFieldId, " does not belong to object definition ", objectDefinition2.getName()}));
            }
            if (!Objects.equals(objectField.getBusinessType(), "Relationship")) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Parameter object field ID " + parameterObjectFieldId + " does not belong to a relationship object field");
            }
        }
    }

    private void _validateScope(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2) throws PortalException {
        if ((StringUtil.equals((String)objectDefinition1.getScope(), (String)"depot") || StringUtil.equals((String)objectDefinition2.getScope(), (String)"depot")) && !StringUtil.equals((String)objectDefinition1.getScope(), (String)objectDefinition2.getScope())) {
            throw new ObjectDefinitionScopeException("An object definition scoped by depot can only be related to object definitions of the same scope");
        }
    }

    private void _validateType(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, String name, long parameterObjectFieldId, String type) throws PortalException {
        int count;
        Set defaultObjectRelationshipTypes = ObjectRelationshipUtil.getDefaultObjectRelationshipTypes();
        if (!defaultObjectRelationshipTypes.contains(type)) {
            throw new ObjectRelationshipTypeException("Invalid type " + type);
        }
        if ((Objects.equals(type, "manyToMany") || Objects.equals(type, "oneToOne")) && (count = this.objectRelationshipPersistence.countByODI1_ODI2_N_T(objectDefinition2.getObjectDefinitionId(), objectDefinition1.getObjectDefinitionId(), name, type)) > 0) {
            throw new ObjectRelationshipTypeException("Inverse type already exists");
        }
        if (objectDefinition1.isUnmodifiableSystemObject()) {
            if (objectDefinition2.isUnmodifiableSystemObject()) {
                throw new ObjectRelationshipTypeException("Relationships are not allowed between system objects");
            }
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition1.getName());
            Set allowedObjectRelationshipTypes = systemObjectDefinitionManager.getAllowedObjectRelationshipTypes();
            if (!allowedObjectRelationshipTypes.contains(type)) {
                throw new ObjectRelationshipTypeException("Invalid type for system object definition " + objectDefinition1.getObjectDefinitionId());
            }
        }
        this._validateParameterObjectFieldId(objectDefinition1, objectDefinition2, parameterObjectFieldId, type);
    }
}

