/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.ObjectEntryVersionLocalService;
import com.liferay.object.service.persistence.ObjectEntryVersionPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ObjectEntryVersionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ObjectEntryVersionLocalService {
    protected ObjectEntryVersionLocalService objectEntryVersionLocalService;
    @Reference
    protected ObjectEntryVersionPersistence objectEntryVersionPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryVersionLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryVersion addObjectEntryVersion(ObjectEntryVersion objectEntryVersion) {
        objectEntryVersion.setNew(true);
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }

    @Transactional(enabled=false)
    public ObjectEntryVersion createObjectEntryVersion(long objectEntryVersionId) {
        return this.objectEntryVersionPersistence.create(objectEntryVersionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectEntryVersion deleteObjectEntryVersion(long objectEntryVersionId) throws PortalException {
        return this.objectEntryVersionPersistence.remove(objectEntryVersionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectEntryVersion deleteObjectEntryVersion(ObjectEntryVersion objectEntryVersion) {
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.remove((BaseModel)objectEntryVersion);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.objectEntryVersionPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(ObjectEntryVersion.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.objectEntryVersionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.objectEntryVersionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.objectEntryVersionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.objectEntryVersionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.objectEntryVersionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public ObjectEntryVersion fetchObjectEntryVersion(long objectEntryVersionId) {
        return this.objectEntryVersionPersistence.fetchByPrimaryKey(objectEntryVersionId);
    }

    public ObjectEntryVersion fetchObjectEntryVersionByUuidAndCompanyId(String uuid, long companyId) {
        return this.objectEntryVersionPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public ObjectEntryVersion getObjectEntryVersion(long objectEntryVersionId) throws PortalException {
        return this.objectEntryVersionPersistence.findByPrimaryKey(objectEntryVersionId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectEntryVersionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectEntryVersion.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectEntryVersionId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectEntryVersionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(ObjectEntryVersion.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("objectEntryVersionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectEntryVersionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectEntryVersion.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectEntryVersionId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ObjectEntryVersion>(){

            public void performAction(ObjectEntryVersion objectEntryVersion) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)objectEntryVersion);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)ObjectEntryVersion.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.objectEntryVersionPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement ObjectEntryVersionLocalServiceImpl#deleteObjectEntryVersion(ObjectEntryVersion) to avoid orphaned data");
        }
        return this.objectEntryVersionLocalService.deleteObjectEntryVersion((ObjectEntryVersion)persistedModel);
    }

    public BasePersistence<ObjectEntryVersion> getBasePersistence() {
        return this.objectEntryVersionPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.objectEntryVersionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public ObjectEntryVersion getObjectEntryVersionByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.objectEntryVersionPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(int start, int end) {
        return this.objectEntryVersionPersistence.findAll(start, end);
    }

    public int getObjectEntryVersionsCount() {
        return this.objectEntryVersionPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryVersion updateObjectEntryVersion(ObjectEntryVersion objectEntryVersion) {
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ObjectEntryVersionLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.objectEntryVersionLocalService = (ObjectEntryVersionLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return ObjectEntryVersionLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return ObjectEntryVersion.class;
    }

    protected String getModelClassName() {
        return ObjectEntryVersion.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.objectEntryVersionPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

