/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.object.internal.search.ObjectEntryBatchReindexer;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class AccountEntryOrganizationRelModelListener
extends BaseModelListener<AccountEntryOrganizationRel> {
    @Reference
    private DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    @Reference(target="(filter.factory.key=default)")
    private FilterFactory<Predicate> _filterFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    private ServiceTrackerMap<String, IndexerDocumentBuilder> _serviceTrackerMap;

    public void onAfterCreate(AccountEntryOrganizationRel accountEntryOrganizationRel) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._reindex(accountEntryOrganizationRel);
            return null;
        });
    }

    public void onAfterRemove(AccountEntryOrganizationRel accountEntryOrganizationRel) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._reindex(accountEntryOrganizationRel);
            return null;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, IndexerDocumentBuilder.class, (String)"indexer.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _reindex(AccountEntryOrganizationRel accountEntryOrganizationRel) throws PortalException {
        for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getObjectDefinitions(true)) {
            if (!objectDefinition.isEnableIndexSearch()) continue;
            ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
            if (!objectScopeProvider.isGroupAware()) {
                ObjectField objectField = ObjectFieldLocalServiceUtil.fetchObjectField((long)objectDefinition.getAccountEntryRestrictedObjectFieldId());
                if (objectField == null) continue;
                int count = this._objectEntryLocalService.getValuesListCount(0L, accountEntryOrganizationRel.getCompanyId(), objectDefinition.getUserId(), objectDefinition.getObjectDefinitionId(), (Predicate)this._filterFactory.create(StringBundler.concat((Object[])new Object[]{objectField.getName(), " eq '", accountEntryOrganizationRel.getAccountEntryId(), "'"}), objectDefinition), null);
                if (count <= 0) continue;
            }
            ObjectEntryBatchReindexer objectEntryBatchReindexer = new ObjectEntryBatchReindexer(this._dynamicQueryBatchIndexingActionableFactory, this._objectEntryLocalService, objectDefinition);
            IndexerDocumentBuilder indexerDocumentBuilder = (IndexerDocumentBuilder)this._serviceTrackerMap.getService((Object)objectEntryBatchReindexer.getClassName());
            objectEntryBatchReindexer.reindex(indexerDocumentBuilder, accountEntryOrganizationRel.getAccountEntryId(), accountEntryOrganizationRel.getCompanyId());
        }
    }
}

