/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.persistence.impl;

import com.liferay.object.exception.NoSuchObjectEntryException;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.impl.ObjectEntryImpl;
import com.liferay.object.model.impl.ObjectEntryModelImpl;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectEntryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectEntryPersistence.class})
public class ObjectEntryPersistenceImpl
extends BasePersistenceImpl<ObjectEntry>
implements ObjectEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ObjectEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "objectEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(objectEntry.uuid IS NULL OR objectEntry.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "objectEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "objectEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "objectEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "objectEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByObjectDefinitionId;
    private FinderPath _finderPathWithoutPaginationFindByObjectDefinitionId;
    private FinderPath _finderPathCountByObjectDefinitionId;
    private static final String _FINDER_COLUMN_OBJECTDEFINITIONID_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ?";
    private FinderPath _finderPathWithPaginationFindByG_ODI;
    private FinderPath _finderPathWithoutPaginationFindByG_ODI;
    private FinderPath _finderPathCountByG_ODI;
    private static final String _FINDER_COLUMN_G_ODI_GROUPID_2 = "objectEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_ODI_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ?";
    private FinderPath _finderPathWithPaginationFindByG_OEFI;
    private FinderPath _finderPathWithoutPaginationFindByG_OEFI;
    private FinderPath _finderPathCountByG_OEFI;
    private static final String _FINDER_COLUMN_G_OEFI_GROUPID_2 = "objectEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_OEFI_OBJECTENTRYFOLDERID_2 = "objectEntry.objectEntryFolderId = ?";
    private FinderPath _finderPathWithPaginationFindByU_ODI;
    private FinderPath _finderPathWithoutPaginationFindByU_ODI;
    private FinderPath _finderPathCountByU_ODI;
    private static final String _FINDER_COLUMN_U_ODI_USERID_2 = "objectEntry.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_ODI_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ?";
    private FinderPath _finderPathWithPaginationFindByODI_NotS;
    private FinderPath _finderPathWithPaginationCountByODI_NotS;
    private static final String _FINDER_COLUMN_ODI_NOTS_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ? AND ";
    private static final String _FINDER_COLUMN_ODI_NOTS_STATUS_2 = "objectEntry.status != ?";
    private FinderPath _finderPathFetchByERC_G_C;
    private static final String _FINDER_COLUMN_ERC_G_C_EXTERNALREFERENCECODE_2 = "objectEntry.externalReferenceCode = ? AND ";
    private static final String _FINDER_COLUMN_ERC_G_C_EXTERNALREFERENCECODE_3 = "(objectEntry.externalReferenceCode IS NULL OR objectEntry.externalReferenceCode = '') AND ";
    private static final String _FINDER_COLUMN_ERC_G_C_GROUPID_2 = "objectEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_ERC_G_C_COMPANYID_2 = "objectEntry.companyId = ?";
    private FinderPath _finderPathFetchByERC_C_ODI;
    private static final String _FINDER_COLUMN_ERC_C_ODI_EXTERNALREFERENCECODE_2 = "objectEntry.externalReferenceCode = ? AND ";
    private static final String _FINDER_COLUMN_ERC_C_ODI_EXTERNALREFERENCECODE_3 = "(objectEntry.externalReferenceCode IS NULL OR objectEntry.externalReferenceCode = '') AND ";
    private static final String _FINDER_COLUMN_ERC_C_ODI_COMPANYID_2 = "objectEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_ERC_C_ODI_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ?";
    private FinderPath _finderPathWithPaginationFindByG_ODI_S;
    private FinderPath _finderPathWithoutPaginationFindByG_ODI_S;
    private FinderPath _finderPathCountByG_ODI_S;
    private static final String _FINDER_COLUMN_G_ODI_S_GROUPID_2 = "objectEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_ODI_S_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ? AND ";
    private static final String _FINDER_COLUMN_G_ODI_S_STATUS_2 = "objectEntry.status = ?";
    private FinderPath _finderPathWithPaginationFindByU_GtCD_ODI;
    private FinderPath _finderPathWithPaginationCountByU_GtCD_ODI;
    private static final String _FINDER_COLUMN_U_GTCD_ODI_USERID_2 = "objectEntry.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_1 = "objectEntry.createDate IS NULL AND ";
    private static final String _FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_2 = "objectEntry.createDate > ? AND ";
    private static final String _FINDER_COLUMN_U_GTCD_ODI_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OBJECTENTRY = "SELECT objectEntry FROM ObjectEntry objectEntry";
    private static final String _SQL_SELECT_OBJECTENTRY_WHERE = "SELECT objectEntry FROM ObjectEntry objectEntry WHERE ";
    private static final String _SQL_COUNT_OBJECTENTRY = "SELECT COUNT(objectEntry) FROM ObjectEntry objectEntry";
    private static final String _SQL_COUNT_OBJECTENTRY_WHERE = "SELECT COUNT(objectEntry) FROM ObjectEntry objectEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "objectEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ObjectEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ObjectEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<ObjectEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<ObjectEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<ObjectEntry> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (uuid.equals(objectEntry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByUuid_First(String uuid, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_First(String uuid, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByUuid_Last(String uuid, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_Last(String uuid, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByUuid_PrevAndNext(long objectEntryId, String uuid, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        uuid = Objects.toString(uuid, "");
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByUuid_PrevAndNext(session, objectEntry, uuid, orderByComparator, true), objectEntry, this.getByUuid_PrevAndNext(session, objectEntry, uuid, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByUuid_PrevAndNext(Session session, ObjectEntry objectEntry, String uuid, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (ObjectEntry objectEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectEntry findByUUID_G(String uuid, long groupId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUUID_G(uuid, groupId);
        if (objectEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchObjectEntryException(sb.toString());
        }
        return objectEntry;
    }

    public ObjectEntry fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public ObjectEntry fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        ObjectEntry objectEntry;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistence)this);
        }
        if (result instanceof ObjectEntry && (!Objects.equals(uuid, (objectEntry = (ObjectEntry)result).getUuid()) || groupId != objectEntry.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("objectEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    ObjectEntry objectEntry2 = (ObjectEntry)list.get(0);
                    result = objectEntry2;
                    this.cacheResult(objectEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ObjectEntry)result;
    }

    public ObjectEntry removeByUUID_G(String uuid, long groupId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByUUID_G(uuid, groupId);
        return (ObjectEntry)this.remove((BaseModel)objectEntry);
    }

    public int countByUUID_G(String uuid, long groupId) {
        ObjectEntry objectEntry = this.fetchByUUID_G(uuid, groupId);
        if (objectEntry == null) {
            return 0;
        }
        return 1;
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (uuid.equals(objectEntry.getUuid()) && companyId == objectEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("objectEntry.uuid = ? AND ");
            }
            sb.append("objectEntry.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByUuid_C_PrevAndNext(long objectEntryId, String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        uuid = Objects.toString(uuid, "");
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByUuid_C_PrevAndNext(session, objectEntry, uuid, companyId, orderByComparator, true), objectEntry, this.getByUuid_C_PrevAndNext(session, objectEntry, uuid, companyId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByUuid_C_PrevAndNext(Session session, ObjectEntry objectEntry, String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("objectEntry.uuid = ? AND ");
        }
        sb.append("objectEntry.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (ObjectEntry objectEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("objectEntry.uuid = ? AND ");
            }
            sb.append("objectEntry.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId) {
        return this.findByObjectDefinitionId(objectDefinitionId, -1, -1, null);
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId, int start, int end) {
        return this.findByObjectDefinitionId(objectDefinitionId, start, end, null);
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByObjectDefinitionId(objectDefinitionId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByObjectDefinitionId;
                finderArgs = new Object[]{objectDefinitionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByObjectDefinitionId;
            finderArgs = new Object[]{objectDefinitionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (objectDefinitionId == objectEntry.getObjectDefinitionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.objectDefinitionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByObjectDefinitionId_First(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByObjectDefinitionId_First(objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByObjectDefinitionId_First(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByObjectDefinitionId(objectDefinitionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByObjectDefinitionId_Last(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByObjectDefinitionId_Last(objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByObjectDefinitionId_Last(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByObjectDefinitionId(objectDefinitionId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByObjectDefinitionId(objectDefinitionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByObjectDefinitionId_PrevAndNext(long objectEntryId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByObjectDefinitionId_PrevAndNext(session, objectEntry, objectDefinitionId, orderByComparator, true), objectEntry, this.getByObjectDefinitionId_PrevAndNext(session, objectEntry, objectDefinitionId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByObjectDefinitionId_PrevAndNext(Session session, ObjectEntry objectEntry, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.objectDefinitionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(objectDefinitionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByObjectDefinitionId(long objectDefinitionId) {
        for (ObjectEntry objectEntry : this.findByObjectDefinitionId(objectDefinitionId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByObjectDefinitionId(long objectDefinitionId) {
        FinderPath finderPath = this._finderPathCountByObjectDefinitionId;
        Object[] finderArgs = new Object[]{objectDefinitionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.objectDefinitionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId) {
        return this.findByG_ODI(groupId, objectDefinitionId, -1, -1, null);
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId, int start, int end) {
        return this.findByG_ODI(groupId, objectDefinitionId, start, end, null);
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByG_ODI(groupId, objectDefinitionId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_ODI;
                finderArgs = new Object[]{groupId, objectDefinitionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_ODI;
            finderArgs = new Object[]{groupId, objectDefinitionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (groupId == objectEntry.getGroupId() && objectDefinitionId == objectEntry.getObjectDefinitionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectDefinitionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByG_ODI_First(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_ODI_First(groupId, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_ODI_First(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByG_ODI(groupId, objectDefinitionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByG_ODI_Last(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_ODI_Last(groupId, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_ODI_Last(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByG_ODI(groupId, objectDefinitionId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByG_ODI(groupId, objectDefinitionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByG_ODI_PrevAndNext(long objectEntryId, long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByG_ODI_PrevAndNext(session, objectEntry, groupId, objectDefinitionId, orderByComparator, true), objectEntry, this.getByG_ODI_PrevAndNext(session, objectEntry, groupId, objectDefinitionId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByG_ODI_PrevAndNext(Session session, ObjectEntry objectEntry, long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.groupId = ? AND ");
        sb.append("objectEntry.objectDefinitionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(objectDefinitionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByG_ODI(long groupId, long objectDefinitionId) {
        for (ObjectEntry objectEntry : this.findByG_ODI(groupId, objectDefinitionId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByG_ODI(long groupId, long objectDefinitionId) {
        FinderPath finderPath = this._finderPathCountByG_ODI;
        Object[] finderArgs = new Object[]{groupId, objectDefinitionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectDefinitionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByG_OEFI(long groupId, long objectEntryFolderId) {
        return this.findByG_OEFI(groupId, objectEntryFolderId, -1, -1, null);
    }

    public List<ObjectEntry> findByG_OEFI(long groupId, long objectEntryFolderId, int start, int end) {
        return this.findByG_OEFI(groupId, objectEntryFolderId, start, end, null);
    }

    public List<ObjectEntry> findByG_OEFI(long groupId, long objectEntryFolderId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByG_OEFI(groupId, objectEntryFolderId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByG_OEFI(long groupId, long objectEntryFolderId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_OEFI;
                finderArgs = new Object[]{groupId, objectEntryFolderId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_OEFI;
            finderArgs = new Object[]{groupId, objectEntryFolderId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (groupId == objectEntry.getGroupId() && objectEntryFolderId == objectEntry.getObjectEntryFolderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_OEFI_OBJECTENTRYFOLDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectEntryFolderId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByG_OEFI_First(long groupId, long objectEntryFolderId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_OEFI_First(groupId, objectEntryFolderId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectEntryFolderId=");
        sb.append(objectEntryFolderId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_OEFI_First(long groupId, long objectEntryFolderId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByG_OEFI(groupId, objectEntryFolderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByG_OEFI_Last(long groupId, long objectEntryFolderId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_OEFI_Last(groupId, objectEntryFolderId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectEntryFolderId=");
        sb.append(objectEntryFolderId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_OEFI_Last(long groupId, long objectEntryFolderId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByG_OEFI(groupId, objectEntryFolderId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByG_OEFI(groupId, objectEntryFolderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByG_OEFI_PrevAndNext(long objectEntryId, long groupId, long objectEntryFolderId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByG_OEFI_PrevAndNext(session, objectEntry, groupId, objectEntryFolderId, orderByComparator, true), objectEntry, this.getByG_OEFI_PrevAndNext(session, objectEntry, groupId, objectEntryFolderId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByG_OEFI_PrevAndNext(Session session, ObjectEntry objectEntry, long groupId, long objectEntryFolderId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_OEFI_OBJECTENTRYFOLDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(objectEntryFolderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByG_OEFI(long groupId, long objectEntryFolderId) {
        for (ObjectEntry objectEntry : this.findByG_OEFI(groupId, objectEntryFolderId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByG_OEFI(long groupId, long objectEntryFolderId) {
        FinderPath finderPath = this._finderPathCountByG_OEFI;
        Object[] finderArgs = new Object[]{groupId, objectEntryFolderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_OEFI_OBJECTENTRYFOLDERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectEntryFolderId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByU_ODI(long userId, long objectDefinitionId) {
        return this.findByU_ODI(userId, objectDefinitionId, -1, -1, null);
    }

    public List<ObjectEntry> findByU_ODI(long userId, long objectDefinitionId, int start, int end) {
        return this.findByU_ODI(userId, objectDefinitionId, start, end, null);
    }

    public List<ObjectEntry> findByU_ODI(long userId, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByU_ODI(userId, objectDefinitionId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByU_ODI(long userId, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByU_ODI;
                finderArgs = new Object[]{userId, objectDefinitionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByU_ODI;
            finderArgs = new Object[]{userId, objectDefinitionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (userId == objectEntry.getUserId() && objectDefinitionId == objectEntry.getObjectDefinitionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.userId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                queryPos.add(objectDefinitionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByU_ODI_First(long userId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByU_ODI_First(userId, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByU_ODI_First(long userId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByU_ODI(userId, objectDefinitionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByU_ODI_Last(long userId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByU_ODI_Last(userId, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByU_ODI_Last(long userId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByU_ODI(userId, objectDefinitionId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByU_ODI(userId, objectDefinitionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByU_ODI_PrevAndNext(long objectEntryId, long userId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByU_ODI_PrevAndNext(session, objectEntry, userId, objectDefinitionId, orderByComparator, true), objectEntry, this.getByU_ODI_PrevAndNext(session, objectEntry, userId, objectDefinitionId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByU_ODI_PrevAndNext(Session session, ObjectEntry objectEntry, long userId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.userId = ? AND ");
        sb.append("objectEntry.objectDefinitionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        queryPos.add(objectDefinitionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByU_ODI(long userId, long objectDefinitionId) {
        for (ObjectEntry objectEntry : this.findByU_ODI(userId, objectDefinitionId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByU_ODI(long userId, long objectDefinitionId) {
        FinderPath finderPath = this._finderPathCountByU_ODI;
        Object[] finderArgs = new Object[]{userId, objectDefinitionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.userId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                queryPos.add(objectDefinitionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status) {
        return this.findByODI_NotS(objectDefinitionId, status, -1, -1, null);
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status, int start, int end) {
        return this.findByODI_NotS(objectDefinitionId, status, start, end, null);
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByODI_NotS(objectDefinitionId, status, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByODI_NotS;
        finderArgs = new Object[]{objectDefinitionId, status, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (objectDefinitionId == objectEntry.getObjectDefinitionId() && status != objectEntry.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.objectDefinitionId = ? AND ");
            sb.append(_FINDER_COLUMN_ODI_NOTS_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByODI_NotS_First(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByODI_NotS_First(objectDefinitionId, status, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", status!=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByODI_NotS_First(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByODI_NotS(objectDefinitionId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByODI_NotS_Last(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByODI_NotS_Last(objectDefinitionId, status, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", status!=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByODI_NotS_Last(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByODI_NotS(objectDefinitionId, status);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByODI_NotS(objectDefinitionId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByODI_NotS_PrevAndNext(long objectEntryId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByODI_NotS_PrevAndNext(session, objectEntry, objectDefinitionId, status, orderByComparator, true), objectEntry, this.getByODI_NotS_PrevAndNext(session, objectEntry, objectDefinitionId, status, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByODI_NotS_PrevAndNext(Session session, ObjectEntry objectEntry, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.objectDefinitionId = ? AND ");
        sb.append(_FINDER_COLUMN_ODI_NOTS_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(objectDefinitionId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByODI_NotS(long objectDefinitionId, int status) {
        for (ObjectEntry objectEntry : this.findByODI_NotS(objectDefinitionId, status, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByODI_NotS(long objectDefinitionId, int status) {
        FinderPath finderPath = this._finderPathWithPaginationCountByODI_NotS;
        Object[] finderArgs = new Object[]{objectDefinitionId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.objectDefinitionId = ? AND ");
            sb.append(_FINDER_COLUMN_ODI_NOTS_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectEntry findByERC_G_C(String externalReferenceCode, long groupId, long companyId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByERC_G_C(externalReferenceCode, groupId, companyId);
        if (objectEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchObjectEntryException(sb.toString());
        }
        return objectEntry;
    }

    public ObjectEntry fetchByERC_G_C(String externalReferenceCode, long groupId, long companyId) {
        return this.fetchByERC_G_C(externalReferenceCode, groupId, companyId, true);
    }

    public ObjectEntry fetchByERC_G_C(String externalReferenceCode, long groupId, long companyId, boolean useFinderCache) {
        ObjectEntry objectEntry;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{externalReferenceCode, groupId, companyId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByERC_G_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof ObjectEntry && (!Objects.equals(externalReferenceCode, (objectEntry = (ObjectEntry)result).getExternalReferenceCode()) || groupId != objectEntry.getGroupId() || companyId != objectEntry.getCompanyId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append("(objectEntry.externalReferenceCode IS NULL OR objectEntry.externalReferenceCode = '') AND ");
            } else {
                bindExternalReferenceCode = true;
                sb.append("objectEntry.externalReferenceCode = ? AND ");
            }
            sb.append("objectEntry.groupId = ? AND ");
            sb.append("objectEntry.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                queryPos.add(groupId);
                queryPos.add(companyId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByERC_G_C, finderArgs, (Object)list);
                    }
                } else {
                    ObjectEntry objectEntry2 = (ObjectEntry)list.get(0);
                    result = objectEntry2;
                    this.cacheResult(objectEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ObjectEntry)result;
    }

    public ObjectEntry removeByERC_G_C(String externalReferenceCode, long groupId, long companyId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByERC_G_C(externalReferenceCode, groupId, companyId);
        return (ObjectEntry)this.remove((BaseModel)objectEntry);
    }

    public int countByERC_G_C(String externalReferenceCode, long groupId, long companyId) {
        ObjectEntry objectEntry = this.fetchByERC_G_C(externalReferenceCode, groupId, companyId);
        if (objectEntry == null) {
            return 0;
        }
        return 1;
    }

    public ObjectEntry findByERC_C_ODI(String externalReferenceCode, long companyId, long objectDefinitionId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        if (objectEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append(", objectDefinitionId=");
            sb.append(objectDefinitionId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchObjectEntryException(sb.toString());
        }
        return objectEntry;
    }

    public ObjectEntry fetchByERC_C_ODI(String externalReferenceCode, long companyId, long objectDefinitionId) {
        return this.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId, true);
    }

    public ObjectEntry fetchByERC_C_ODI(String externalReferenceCode, long companyId, long objectDefinitionId, boolean useFinderCache) {
        ObjectEntry objectEntry;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{externalReferenceCode, companyId, objectDefinitionId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByERC_C_ODI, finderArgs, (BasePersistence)this);
        }
        if (result instanceof ObjectEntry && (!Objects.equals(externalReferenceCode, (objectEntry = (ObjectEntry)result).getExternalReferenceCode()) || companyId != objectEntry.getCompanyId() || objectDefinitionId != objectEntry.getObjectDefinitionId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append("(objectEntry.externalReferenceCode IS NULL OR objectEntry.externalReferenceCode = '') AND ");
            } else {
                bindExternalReferenceCode = true;
                sb.append("objectEntry.externalReferenceCode = ? AND ");
            }
            sb.append(_FINDER_COLUMN_ERC_C_ODI_COMPANYID_2);
            sb.append("objectEntry.objectDefinitionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                queryPos.add(companyId);
                queryPos.add(objectDefinitionId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByERC_C_ODI, finderArgs, (Object)list);
                    }
                } else {
                    ObjectEntry objectEntry2 = (ObjectEntry)list.get(0);
                    result = objectEntry2;
                    this.cacheResult(objectEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ObjectEntry)result;
    }

    public ObjectEntry removeByERC_C_ODI(String externalReferenceCode, long companyId, long objectDefinitionId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        return (ObjectEntry)this.remove((BaseModel)objectEntry);
    }

    public int countByERC_C_ODI(String externalReferenceCode, long companyId, long objectDefinitionId) {
        ObjectEntry objectEntry = this.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        if (objectEntry == null) {
            return 0;
        }
        return 1;
    }

    public List<ObjectEntry> findByG_ODI_S(long groupId, long objectDefinitionId, int status) {
        return this.findByG_ODI_S(groupId, objectDefinitionId, status, -1, -1, null);
    }

    public List<ObjectEntry> findByG_ODI_S(long groupId, long objectDefinitionId, int status, int start, int end) {
        return this.findByG_ODI_S(groupId, objectDefinitionId, status, start, end, null);
    }

    public List<ObjectEntry> findByG_ODI_S(long groupId, long objectDefinitionId, int status, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByG_ODI_S(groupId, objectDefinitionId, status, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByG_ODI_S(long groupId, long objectDefinitionId, int status, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_ODI_S;
                finderArgs = new Object[]{groupId, objectDefinitionId, status};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_ODI_S;
            finderArgs = new Object[]{groupId, objectDefinitionId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (groupId == objectEntry.getGroupId() && objectDefinitionId == objectEntry.getObjectDefinitionId() && status == objectEntry.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ? AND ");
            sb.append(_FINDER_COLUMN_G_ODI_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectDefinitionId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByG_ODI_S_First(long groupId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_ODI_S_First(groupId, objectDefinitionId, status, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_ODI_S_First(long groupId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByG_ODI_S(groupId, objectDefinitionId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByG_ODI_S_Last(long groupId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_ODI_S_Last(groupId, objectDefinitionId, status, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_ODI_S_Last(long groupId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByG_ODI_S(groupId, objectDefinitionId, status);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByG_ODI_S(groupId, objectDefinitionId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByG_ODI_S_PrevAndNext(long objectEntryId, long groupId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByG_ODI_S_PrevAndNext(session, objectEntry, groupId, objectDefinitionId, status, orderByComparator, true), objectEntry, this.getByG_ODI_S_PrevAndNext(session, objectEntry, groupId, objectDefinitionId, status, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByG_ODI_S_PrevAndNext(Session session, ObjectEntry objectEntry, long groupId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.groupId = ? AND ");
        sb.append("objectEntry.objectDefinitionId = ? AND ");
        sb.append(_FINDER_COLUMN_G_ODI_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(objectDefinitionId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByG_ODI_S(long groupId, long objectDefinitionId, int status) {
        for (ObjectEntry objectEntry : this.findByG_ODI_S(groupId, objectDefinitionId, status, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByG_ODI_S(long groupId, long objectDefinitionId, int status) {
        FinderPath finderPath = this._finderPathCountByG_ODI_S;
        Object[] finderArgs = new Object[]{groupId, objectDefinitionId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ? AND ");
            sb.append(_FINDER_COLUMN_G_ODI_S_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectDefinitionId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByU_GtCD_ODI(long userId, Date createDate, long objectDefinitionId) {
        return this.findByU_GtCD_ODI(userId, createDate, objectDefinitionId, -1, -1, null);
    }

    public List<ObjectEntry> findByU_GtCD_ODI(long userId, Date createDate, long objectDefinitionId, int start, int end) {
        return this.findByU_GtCD_ODI(userId, createDate, objectDefinitionId, start, end, null);
    }

    public List<ObjectEntry> findByU_GtCD_ODI(long userId, Date createDate, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByU_GtCD_ODI(userId, createDate, objectDefinitionId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByU_GtCD_ODI(long userId, Date createDate, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByU_GtCD_ODI;
        finderArgs = new Object[]{userId, ObjectEntryPersistenceImpl._getTime(createDate), objectDefinitionId, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (userId == objectEntry.getUserId() && createDate.getTime() < objectEntry.getCreateDate().getTime() && objectDefinitionId == objectEntry.getObjectDefinitionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.userId = ? AND ");
            boolean bindCreateDate = false;
            if (createDate == null) {
                sb.append(_FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_1);
            } else {
                bindCreateDate = true;
                sb.append(_FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_2);
            }
            sb.append("objectEntry.objectDefinitionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindCreateDate) {
                    queryPos.add(new Timestamp(createDate.getTime()));
                }
                queryPos.add(objectDefinitionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByU_GtCD_ODI_First(long userId, Date createDate, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByU_GtCD_ODI_First(userId, createDate, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append(", createDate>");
        sb.append((Object)createDate);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByU_GtCD_ODI_First(long userId, Date createDate, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByU_GtCD_ODI(userId, createDate, objectDefinitionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByU_GtCD_ODI_Last(long userId, Date createDate, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByU_GtCD_ODI_Last(userId, createDate, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append(", createDate>");
        sb.append((Object)createDate);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByU_GtCD_ODI_Last(long userId, Date createDate, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByU_GtCD_ODI(userId, createDate, objectDefinitionId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByU_GtCD_ODI(userId, createDate, objectDefinitionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByU_GtCD_ODI_PrevAndNext(long objectEntryId, long userId, Date createDate, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByU_GtCD_ODI_PrevAndNext(session, objectEntry, userId, createDate, objectDefinitionId, orderByComparator, true), objectEntry, this.getByU_GtCD_ODI_PrevAndNext(session, objectEntry, userId, createDate, objectDefinitionId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByU_GtCD_ODI_PrevAndNext(Session session, ObjectEntry objectEntry, long userId, Date createDate, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.userId = ? AND ");
        boolean bindCreateDate = false;
        if (createDate == null) {
            sb.append(_FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_1);
        } else {
            bindCreateDate = true;
            sb.append(_FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_2);
        }
        sb.append("objectEntry.objectDefinitionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (bindCreateDate) {
            queryPos.add(new Timestamp(createDate.getTime()));
        }
        queryPos.add(objectDefinitionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByU_GtCD_ODI(long userId, Date createDate, long objectDefinitionId) {
        for (ObjectEntry objectEntry : this.findByU_GtCD_ODI(userId, createDate, objectDefinitionId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByU_GtCD_ODI(long userId, Date createDate, long objectDefinitionId) {
        FinderPath finderPath = this._finderPathWithPaginationCountByU_GtCD_ODI;
        Object[] finderArgs = new Object[]{userId, ObjectEntryPersistenceImpl._getTime(createDate), objectDefinitionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.userId = ? AND ");
            boolean bindCreateDate = false;
            if (createDate == null) {
                sb.append(_FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_1);
            } else {
                bindCreateDate = true;
                sb.append(_FINDER_COLUMN_U_GTCD_ODI_CREATEDATE_2);
            }
            sb.append("objectEntry.objectDefinitionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindCreateDate) {
                    queryPos.add(new Timestamp(createDate.getTime()));
                }
                queryPos.add(objectDefinitionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(ObjectEntry.class);
        this.setModelImplClass(ObjectEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)ObjectEntryTable.INSTANCE);
    }

    public void cacheResult(ObjectEntry objectEntry) {
        this.entityCache.putResult(ObjectEntryImpl.class, (Serializable)Long.valueOf(objectEntry.getPrimaryKey()), (Serializable)objectEntry);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{objectEntry.getUuid(), objectEntry.getGroupId()}, (Object)objectEntry);
        this.finderCache.putResult(this._finderPathFetchByERC_G_C, new Object[]{objectEntry.getExternalReferenceCode(), objectEntry.getGroupId(), objectEntry.getCompanyId()}, (Object)objectEntry);
        this.finderCache.putResult(this._finderPathFetchByERC_C_ODI, new Object[]{objectEntry.getExternalReferenceCode(), objectEntry.getCompanyId(), objectEntry.getObjectDefinitionId()}, (Object)objectEntry);
    }

    public void cacheResult(List<ObjectEntry> objectEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && objectEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            if (this.entityCache.getResult(ObjectEntryImpl.class, (Serializable)Long.valueOf(objectEntry.getPrimaryKey())) != null) continue;
            this.cacheResult(objectEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ObjectEntryImpl.class);
        this.finderCache.clearCache(ObjectEntryImpl.class);
    }

    public void clearCache(ObjectEntry objectEntry) {
        this.entityCache.removeResult(ObjectEntryImpl.class, (BaseModel)objectEntry);
    }

    public void clearCache(List<ObjectEntry> objectEntries) {
        for (ObjectEntry objectEntry : objectEntries) {
            this.entityCache.removeResult(ObjectEntryImpl.class, (BaseModel)objectEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(ObjectEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ObjectEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(ObjectEntryModelImpl objectEntryModelImpl) {
        Object[] args = new Object[]{objectEntryModelImpl.getUuid(), objectEntryModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)objectEntryModelImpl);
        args = new Object[]{objectEntryModelImpl.getExternalReferenceCode(), objectEntryModelImpl.getGroupId(), objectEntryModelImpl.getCompanyId()};
        this.finderCache.putResult(this._finderPathFetchByERC_G_C, args, (Object)objectEntryModelImpl);
        args = new Object[]{objectEntryModelImpl.getExternalReferenceCode(), objectEntryModelImpl.getCompanyId(), objectEntryModelImpl.getObjectDefinitionId()};
        this.finderCache.putResult(this._finderPathFetchByERC_C_ODI, args, (Object)objectEntryModelImpl);
    }

    public ObjectEntry create(long objectEntryId) {
        ObjectEntryImpl objectEntry = new ObjectEntryImpl();
        objectEntry.setNew(true);
        objectEntry.setPrimaryKey(objectEntryId);
        String uuid = PortalUUIDUtil.generate();
        objectEntry.setUuid(uuid);
        objectEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return objectEntry;
    }

    public ObjectEntry remove(long objectEntryId) throws NoSuchObjectEntryException {
        return this.remove(Long.valueOf(objectEntryId));
    }

    public ObjectEntry remove(Serializable primaryKey) throws NoSuchObjectEntryException {
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry objectEntry = (ObjectEntry)session.get(ObjectEntryImpl.class, primaryKey);
            if (objectEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchObjectEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ObjectEntry objectEntry2 = (ObjectEntry)this.remove((BaseModel)objectEntry);
            return objectEntry2;
        }
        catch (NoSuchObjectEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry removeImpl(ObjectEntry objectEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)objectEntry)) {
                objectEntry = (ObjectEntry)session.get(ObjectEntryImpl.class, objectEntry.getPrimaryKeyObj());
            }
            if (objectEntry != null) {
                session.delete((Object)objectEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (objectEntry != null) {
            this.clearCache(objectEntry);
        }
        return objectEntry;
    }

    public ObjectEntry updateImpl(ObjectEntry objectEntry) {
        long userId;
        boolean isNew = objectEntry.isNew();
        if (!(objectEntry instanceof ObjectEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(objectEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)objectEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in objectEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ObjectEntry implementation " + objectEntry.getClass());
        }
        ObjectEntryModelImpl objectEntryModelImpl = (ObjectEntryModelImpl)objectEntry;
        if (Validator.isNull((String)objectEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            objectEntry.setUuid(uuid);
        }
        if (Validator.isNull((String)objectEntry.getExternalReferenceCode())) {
            objectEntry.setExternalReferenceCode(objectEntry.getUuid());
        } else if (!Objects.equals(objectEntryModelImpl.getColumnOriginalValue("externalReferenceCode"), objectEntry.getExternalReferenceCode()) && (userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName())) > 0L) {
            long companyId = objectEntry.getCompanyId();
            long groupId = objectEntry.getGroupId();
            long classPK = 0L;
            if (!isNew) {
                classPK = objectEntry.getPrimaryKey();
            }
            try {
                objectEntry.setExternalReferenceCode(SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)ObjectEntry.class.getName(), (long)classPK, (String)"text/html", (String)"ALL", (String)objectEntry.getExternalReferenceCode(), null));
            }
            catch (SanitizerException sanitizerException) {
                throw new SystemException((Throwable)sanitizerException);
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && objectEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                objectEntry.setCreateDate(date);
            } else {
                objectEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!objectEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                objectEntry.setModifiedDate(date);
            } else {
                objectEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)objectEntry);
            } else {
                objectEntry = (ObjectEntry)session.merge((Object)objectEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(ObjectEntryImpl.class, (BaseModel)objectEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(objectEntryModelImpl);
        if (isNew) {
            objectEntry.setNew(false);
        }
        objectEntry.resetOriginalValues();
        return objectEntry;
    }

    public ObjectEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = (ObjectEntry)this.fetchByPrimaryKey(primaryKey);
        if (objectEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchObjectEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return objectEntry;
    }

    public ObjectEntry findByPrimaryKey(long objectEntryId) throws NoSuchObjectEntryException {
        return this.findByPrimaryKey(Long.valueOf(objectEntryId));
    }

    public ObjectEntry fetchByPrimaryKey(long objectEntryId) {
        return (ObjectEntry)this.fetchByPrimaryKey(Long.valueOf(objectEntryId));
    }

    public List<ObjectEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ObjectEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ObjectEntry> findAll(int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findAll(int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OBJECTENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OBJECTENTRY;
                sql = sql.concat(" ORDER BY objectEntry.objectEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ObjectEntry objectEntry : this.findAll()) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OBJECTENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "objectEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OBJECTENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ObjectEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByObjectDefinitionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"objectDefinitionId"}, true);
        this._finderPathWithoutPaginationFindByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByObjectDefinitionId", new String[]{Long.class.getName()}, new String[]{"objectDefinitionId"}, true);
        this._finderPathCountByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByObjectDefinitionId", new String[]{Long.class.getName()}, new String[]{"objectDefinitionId"}, false);
        this._finderPathWithPaginationFindByG_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_ODI", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "objectDefinitionId"}, true);
        this._finderPathWithoutPaginationFindByG_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_ODI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "objectDefinitionId"}, true);
        this._finderPathCountByG_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_ODI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "objectDefinitionId"}, false);
        this._finderPathWithPaginationFindByG_OEFI = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_OEFI", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "objectEntryFolderId"}, true);
        this._finderPathWithoutPaginationFindByG_OEFI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_OEFI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "objectEntryFolderId"}, true);
        this._finderPathCountByG_OEFI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_OEFI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "objectEntryFolderId"}, false);
        this._finderPathWithPaginationFindByU_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByU_ODI", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId", "objectDefinitionId"}, true);
        this._finderPathWithoutPaginationFindByU_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByU_ODI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"userId", "objectDefinitionId"}, true);
        this._finderPathCountByU_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByU_ODI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"userId", "objectDefinitionId"}, false);
        this._finderPathWithPaginationFindByODI_NotS = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByODI_NotS", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"objectDefinitionId", "status"}, true);
        this._finderPathWithPaginationCountByODI_NotS = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByODI_NotS", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"objectDefinitionId", "status"}, false);
        this._finderPathFetchByERC_G_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByERC_G_C", new String[]{String.class.getName(), Long.class.getName(), Long.class.getName()}, new String[]{"externalReferenceCode", "groupId", "companyId"}, true);
        this._finderPathFetchByERC_C_ODI = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByERC_C_ODI", new String[]{String.class.getName(), Long.class.getName(), Long.class.getName()}, new String[]{"externalReferenceCode", "companyId", "objectDefinitionId"}, true);
        this._finderPathWithPaginationFindByG_ODI_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_ODI_S", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "objectDefinitionId", "status"}, true);
        this._finderPathWithoutPaginationFindByG_ODI_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_ODI_S", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "objectDefinitionId", "status"}, true);
        this._finderPathCountByG_ODI_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_ODI_S", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "objectDefinitionId", "status"}, false);
        this._finderPathWithPaginationFindByU_GtCD_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByU_GtCD_ODI", new String[]{Long.class.getName(), Date.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId", "createDate", "objectDefinitionId"}, true);
        this._finderPathWithPaginationCountByU_GtCD_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByU_GtCD_ODI", new String[]{Long.class.getName(), Date.class.getName(), Long.class.getName()}, new String[]{"userId", "createDate", "objectDefinitionId"}, false);
        ObjectEntryUtil.setPersistence((ObjectEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        ObjectEntryUtil.setPersistence(null);
        this.entityCache.removeCache(ObjectEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.object.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private static Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

