/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.object.configuration.ObjectConfiguration;
import com.liferay.object.definition.security.permission.resource.ObjectDefinitionPortletResourcePermissionRegistryUtil;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedException;
import com.liferay.object.exception.ObjectEntryCountException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.base.ObjectEntryServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.tree.Edge;
import com.liferay.object.tree.Node;
import com.liferay.object.tree.ObjectDefinitionTreeFactory;
import com.liferay.object.tree.Tree;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.configuration.ObjectConfiguration"}, property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectEntry"}, service={AopService.class})
public class ObjectEntryServiceImpl
extends ObjectEntryServiceBaseImpl {
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    private volatile ObjectConfiguration _objectConfiguration;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public ObjectEntry addObjectEntry(long groupId, long objectDefinitionId, long objectEntryFolderId, String defaultLanguageId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this._checkAddObjectEntryPortletResourcePermission(groupId, objectDefinitionId, values);
        }
        this._validateSubmissionLimit(objectDefinitionId, this.getUser());
        return this.objectEntryLocalService.addObjectEntry(this.getUserId(), groupId, objectDefinitionId, objectEntryFolderId, defaultLanguageId, values, serviceContext);
    }

    public ObjectEntry addOrUpdateObjectEntry(String externalReferenceCode, long groupId, long objectDefinitionId, long objectEntryFolderId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, serviceContext.getCompanyId(), objectDefinitionId);
        if (objectEntry == null) {
            this._checkAddObjectEntryPortletResourcePermission(groupId, objectDefinitionId, values);
        } else {
            this.checkModelResourcePermission(objectDefinitionId, objectEntry.getObjectEntryId(), "UPDATE");
        }
        return this.objectEntryLocalService.addOrUpdateObjectEntry(externalReferenceCode, this.getUserId(), groupId, objectDefinitionId, objectEntryFolderId, values, serviceContext);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkModelResourcePermission(long objectDefinitionId, long objectEntryId, String actionId) throws PortalException {
        this._checkPermission(actionId, objectDefinitionId, this.objectEntryLocalService.getObjectEntry(objectEntryId));
    }

    public ObjectEntry deleteObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        this._checkPermission("DELETE", objectEntry.getObjectDefinitionId(), objectEntry);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntryId);
    }

    public ObjectEntry deleteObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(externalReferenceCode, companyId, groupId);
        this._checkPermission("DELETE", objectEntry.getObjectDefinitionId(), objectEntry);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    public ObjectEntry fetchManyToOneObjectEntry(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.fetchManyToOneObjectEntry(groupId, objectRelationshipId, primaryKey);
        if (objectEntry != null && !ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this.objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
        }
        return objectEntry;
    }

    public ObjectEntry fetchObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.fetchObjectEntry(objectEntryId);
        if (objectEntry != null) {
            this._checkPermission("VIEW", objectEntry.getObjectDefinitionId(), objectEntry);
        }
        return objectEntry;
    }

    public List<ObjectEntry> getManyToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, String search, int start, int end) throws PortalException {
        List objectEntries = this.objectEntryLocalService.getManyToManyObjectEntries(groupId, objectRelationshipId, primaryKey, related, reverse, search, start, end);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            for (ObjectEntry objectEntry : objectEntries) {
                this.objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
            }
        }
        return objectEntries;
    }

    public int getManyToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, String search) throws PortalException {
        return this.objectEntryLocalService.getManyToManyObjectEntriesCount(groupId, objectRelationshipId, primaryKey, related, reverse, search);
    }

    public ModelResourcePermission<ObjectEntry> getModelResourcePermission(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isRootDescendantNode()) {
            objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinition.getRootObjectDefinitionId());
        }
        return ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
    }

    public ObjectEntry getObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this._checkPermission("VIEW", objectEntry.getObjectDefinitionId(), objectEntry);
        }
        return objectEntry;
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long objectDefinitionId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(externalReferenceCode, objectDefinitionId);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this._checkPermission("VIEW", objectEntry.getObjectDefinitionId(), objectEntry);
        }
        return objectEntry;
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(externalReferenceCode, companyId, groupId);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this._checkPermission("VIEW", objectEntry.getObjectDefinitionId(), objectEntry);
        }
        return objectEntry;
    }

    public List<ObjectEntry> getOneToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, String search, int start, int end) throws PortalException {
        List objectEntries = this.objectEntryLocalService.getOneToManyObjectEntries(groupId, objectRelationshipId, primaryKey, related, search, start, end);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            for (ObjectEntry objectEntry : objectEntries) {
                this.objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
            }
        }
        return objectEntries;
    }

    public int getOneToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related, String search) throws PortalException {
        return this.objectEntryLocalService.getOneToManyObjectEntriesCount(groupId, objectRelationshipId, primaryKey, related, search);
    }

    public boolean hasModelResourcePermission(long objectDefinitionId, long objectEntryId, String actionId) throws PortalException {
        ModelResourcePermission<ObjectEntry> modelResourcePermission = this.getModelResourcePermission(objectDefinitionId);
        return modelResourcePermission.contains(this.getPermissionChecker(), objectEntryId, actionId);
    }

    public boolean hasModelResourcePermission(ObjectEntry objectEntry, String actionId) throws PortalException {
        ModelResourcePermission<ObjectEntry> modelResourcePermission = this.getModelResourcePermission(objectEntry.getObjectDefinitionId());
        return modelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)objectEntry, actionId);
    }

    public boolean hasModelResourcePermission(User user, long objectEntryId, String actionId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        ModelResourcePermission<ObjectEntry> modelResourcePermission = this.getModelResourcePermission(objectEntry.getObjectDefinitionId());
        return modelResourcePermission.contains(this._permissionCheckerFactory.create(user), objectEntryId, actionId);
    }

    public boolean hasPortletResourcePermission(long groupId, long objectDefinitionId, String actionId) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._getPortletResourcePermission(objectDefinitionId);
        return portletResourcePermission.contains(this.getPermissionChecker(), groupId, actionId);
    }

    public ObjectEntry updateObjectEntry(long objectEntryId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "UPDATE");
        }
        return this.objectEntryLocalService.updateObjectEntry(this.getUserId(), objectEntryId, values, serviceContext);
    }

    public void validate(long groupId, ObjectEntry objectEntry, List<String> objectValidationRuleExternalReferenceCodes, ServiceContext serviceContext) throws PortalException {
        this._checkAddObjectEntryPortletResourcePermission(groupId, objectEntry.getObjectDefinitionId(), objectEntry.getValues());
        this.objectEntryLocalService.validate(groupId, objectEntry, objectValidationRuleExternalReferenceCodes, serviceContext, this.getUserId());
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._objectConfiguration = (ObjectConfiguration)ConfigurableUtil.createConfigurable(ObjectConfiguration.class, properties);
    }

    private void _checkAddObjectEntryPortletResourcePermission(long groupId, long objectDefinitionId, Map<String, Serializable> values) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._getPortletResourcePermission(objectDefinitionId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        try {
            portletResourcePermission.check(permissionChecker, groupId, "ADD_OBJECT_ENTRY");
        }
        catch (PortalException portalException1) {
            if (objectDefinition.isRootDescendantNode()) {
                try {
                    this._checkPermission("UPDATE", objectDefinitionId, this._getRootObjectEntry(objectDefinition, values));
                    return;
                }
                catch (PortalException portalException2) {
                    portalException1.addSuppressed((Throwable)portalException2);
                }
            }
            throw portalException1;
        }
        if (permissionChecker.hasPermission(groupId, portletResourcePermission.getResourceName(), 0L, "ADD_OBJECT_ENTRY")) {
            return;
        }
        long accountEntryId = 0L;
        boolean rootDescendantNode = false;
        if (objectDefinition.isRootDescendantNode()) {
            accountEntryId = this._getRootObjectEntryAccountEntryId(objectDefinition, values);
            objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinition.getRootObjectDefinitionId());
            rootDescendantNode = true;
        } else {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
            accountEntryId = MapUtil.getLong(values, (String)objectField.getName());
        }
        long[] accountEntryIds = ListUtil.toLongArray((List)this._accountEntryLocalService.getUserAccountEntries(this.getUserId(), Long.valueOf(0L), null, AccountConstants.ACCOUNT_ENTRY_TYPES_DEFAULT_ALLOWED_TYPES, Integer.valueOf(0), -1, -1), AccountEntryModel::getAccountEntryId);
        if (!ArrayUtil.contains((long[])accountEntryIds, (long)accountEntryId)) {
            throw new ObjectDefinitionAccountEntryRestrictedException(StringBundler.concat((Object[])new Object[]{"User ", this.getUserId(), " does not have access to account entry ", accountEntryId}));
        }
        HashSet rolesIds = new HashSet();
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), accountEntry.getAccountEntryGroupId()), UserGroupRoleModel::getRoleId));
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId);
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
            Organization organization = accountEntryOrganizationRel.getOrganization();
            Group group = this._groupLocalService.getOrganizationGroup(objectDefinition.getCompanyId(), organization.getOrganizationId());
            rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), group.getGroupId()), UserGroupRoleModel::getRoleId));
            for (Organization ancestorOrganization : organization.getAncestors()) {
                group = this._groupLocalService.getOrganizationGroup(objectDefinition.getCompanyId(), ancestorOrganization.getOrganizationId());
                rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), group.getGroupId()), UserGroupRoleModel::getRoleId));
            }
        }
        for (Long roleId : rolesIds) {
            ResourcePermission resourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(objectDefinition.getCompanyId(), objectDefinition.getResourceName(), 3, "0", roleId.longValue());
            if (resourcePermission == null) continue;
            if (rootDescendantNode && (resourcePermission.hasActionId("ADD_OBJECT_ENTRY") || resourcePermission.hasActionId("UPDATE"))) {
                return;
            }
            if (!resourcePermission.hasActionId("ADD_OBJECT_ENTRY")) continue;
            return;
        }
        throw new PrincipalException.MustHavePermission(permissionChecker, objectDefinition.getResourceName(), 0L, new String[]{"ADD_OBJECT_ENTRY"});
    }

    private void _checkPermission(String actionId, long objectDefinitionId, ObjectEntry objectEntry) throws PortalException {
        ModelResourcePermission<ObjectEntry> modelResourcePermission = this.getModelResourcePermission(objectDefinitionId);
        try {
            modelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)objectEntry, actionId);
        }
        catch (PortalException portalException1) {
            if (objectEntry.getRootObjectEntryId() != 0L && objectEntry.getRootObjectEntryId() != objectEntry.getObjectEntryId() && (actionId.equals("DELETE") || actionId.equals("UPDATE") || actionId.equals("VIEW"))) {
                try {
                    modelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)objectEntry, "UPDATE");
                    return;
                }
                catch (PortalException portalException2) {
                    portalException1.addSuppressed((Throwable)portalException2);
                }
            }
            throw portalException1;
        }
    }

    private PortletResourcePermission _getPortletResourcePermission(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isRootDescendantNode()) {
            objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinition.getRootObjectDefinitionId());
        }
        return ObjectDefinitionPortletResourcePermissionRegistryUtil.getService((String)objectDefinition.getResourceName());
    }

    private ObjectEntry _getRootObjectEntry(ObjectDefinition objectDefinition, Map<String, Serializable> values) throws PortalException {
        ObjectDefinitionTreeFactory objectDefinitionTreeFactory = new ObjectDefinitionTreeFactory(this._objectDefinitionPersistence, this._objectRelationshipLocalService);
        Tree tree = objectDefinitionTreeFactory.create(objectDefinition.getRootObjectDefinitionId());
        Node node = tree.getNode(objectDefinition.getObjectDefinitionId());
        Edge edge = node.getEdge();
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(edge.getObjectRelationshipId());
        ObjectField objectField2 = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        ObjectEntry parentObjectEntry = this.objectEntryLocalService.getObjectEntry(MapUtil.getLong(values, (String)objectField2.getName()));
        return this.objectEntryLocalService.getObjectEntry(parentObjectEntry.getRootObjectEntryId());
    }

    private long _getRootObjectEntryAccountEntryId(ObjectDefinition objectDefinition, Map<String, Serializable> values) throws PortalException {
        ObjectEntry rootObjectEntry = this._getRootObjectEntry(objectDefinition, values);
        ObjectDefinition rootObjectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinition.getRootObjectDefinitionId());
        ObjectField accountEntryRestrictedObjectField = this._objectFieldLocalService.getObjectField(rootObjectDefinition.getAccountEntryRestrictedObjectFieldId());
        return MapUtil.getLong((Map)rootObjectEntry.getValues(), (String)accountEntryRestrictedObjectField.getName());
    }

    private Date _getStartDate() {
        return Date.from(LocalDate.now().minusDays(Objects.equals(this._objectConfiguration.timeScale(), "days") ? this._objectConfiguration.duration() - 1L : this._objectConfiguration.duration() * 7L - 1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private void _sendUserNotificationEvents(long userId, String portletId, ObjectDefinition objectDefinition) throws PortalException {
        this._userNotificationEventLocalService.sendUserNotificationEvents(userId, portletId, 10002, true, false, JSONUtil.put((String)"className", (Object)objectDefinition.getClassName()).put("exceedsObjectEntryLimit", true).put("externalReferenceCode", objectDefinition.getExternalReferenceCode()).put("notificationMessage", StringBundler.concat((String[])new String[]{"The limit of guest entries for ", objectDefinition.getLabel(objectDefinition.getDefaultLanguageId()), " has been reached and will no longer be accepted. Go to ", "Instance Settings to change this."})).put("portletId", portletId));
    }

    private void _sendUserNotificationEvents(ObjectDefinition objectDefinition) throws PortalException {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String portletId = objectDefinition.isUnmodifiableSystemObject() ? "" : objectDefinition.getPortletId();
        long timestamp = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant().getEpochSecond();
        Role role = this._roleLocalService.getRole(objectDefinition.getCompanyId(), "Administrator");
        for (long userId : this._userLocalService.getRoleUserIds(role.getRoleId())) {
            boolean addUserId = true;
            List userNotificationEvents = this._userNotificationEventLocalService.getUserNotificationEvents(userId, portletId, timestamp, true);
            for (UserNotificationEvent userNotificationEvent : userNotificationEvents) {
                JSONObject jsonObject = this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
                if (!jsonObject.has("exceedsObjectEntryLimit")) continue;
                addUserId = false;
                break;
            }
            if (!addUserId) continue;
            userIds.add(userId);
        }
        try {
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                Iterator iterator = userIds.iterator();
                while (iterator.hasNext()) {
                    long userId = (Long)iterator.next();
                    this._sendUserNotificationEvents(userId, portletId, objectDefinition);
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    private void _validateSubmissionLimit(long objectDefinitionId, User user) throws PortalException {
        if (!user.isGuestUser()) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        try {
            this._objectConfiguration = (ObjectConfiguration)this._configurationProvider.getCompanyConfiguration(ObjectConfiguration.class, objectDefinition.getCompanyId());
            if (this._objectConfiguration == null) {
                this._objectConfiguration = (ObjectConfiguration)this._configurationProvider.getSystemConfiguration(ObjectConfiguration.class);
            }
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException);
        }
        long count = this.objectEntryLocalService.getObjectEntriesCount(user.getUserId(), this._getStartDate(), objectDefinition.getObjectDefinitionId());
        long maximumNumberOfGuestUserObjectEntriesPerObjectDefinition = this._objectConfiguration.maximumNumberOfGuestUserObjectEntriesPerObjectDefinition();
        if (count >= maximumNumberOfGuestUserObjectEntriesPerObjectDefinition) {
            this._sendUserNotificationEvents(objectDefinition);
            throw new ObjectEntryCountException(Collections.singletonList(objectDefinition.getLabel(objectDefinition.getDefaultLanguageId())), StringBundler.concat((String[])new String[]{"The limit of guest entries for ", objectDefinition.getLabel(objectDefinition.getDefaultLanguageId()), " has been reached and will no longer be accepted"}), "the-limit-of-guest-entries-for-object-definition-has-been-reached-and-will-no-longer-be-accepted", objectDefinition.getLabel(objectDefinition.getDefaultLanguageId()));
        }
    }
}

