/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Text"}, service={ObjectFieldBusinessType.class})
public class TextObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"maxLength", "showCounter", "uniqueValues"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDDMFormFieldTypeName(boolean localized) {
        if (localized) {
            return "localizable_text";
        }
        return this.getDDMFormFieldTypeName();
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-text-up-to-280-characters");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "text");
    }

    public String getName() {
        return "Text";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Set<String> getUnmodifiableObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"uniqueValues"});
    }

    public boolean isLocalizable() {
        return true;
    }

    public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectField, objectFieldSettings);
        Map<String, String> objectFieldSettingsValues = this.getObjectFieldSettingsValues(objectFieldSettings);
        this.validateBooleanObjectFieldSetting(objectField.getName(), "uniqueValues", objectFieldSettingsValues);
        this.validateRelatedObjectFieldSettings(objectField, "showCounter", "maxLength", objectFieldSettingsValues);
    }
}

