/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.trigger.messaging;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.internal.entry.util.ObjectEntryUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/object_entry_attachment_download"}, service={MessageListener.class})
public class ObjectActionDownloadTriggerMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionDownloadTriggerMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectActionEngine _objectActionEngine;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    private ServiceRegistration<Destination> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("synchronous", "liferay/object_entry_attachment_download");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        long companyId;
        String objectDefinitionExternalReferenceCode = message.getString("objectDefinitionExternalReferenceCode");
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode(objectDefinitionExternalReferenceCode, companyId = message.getLong("companyId"));
        if (objectDefinition == null && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Object definition is null for external reference ", "code ", objectDefinitionExternalReferenceCode, " and company ", companyId}));
            return;
        }
        String objectEntryExternalReferenceCode = message.getString("objectEntryExternalReferenceCode");
        ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(objectEntryExternalReferenceCode, objectDefinition.getObjectDefinitionId());
        if (objectEntry == null && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Object entry is null for external reference code ", objectEntryExternalReferenceCode, " and object definition ", objectDefinitionExternalReferenceCode}));
            return;
        }
        this._objectActionEngine.executeObjectActions(objectDefinition.getClassName(), message.getLong("companyId"), "onAfterAttachmentDownload", () -> ObjectEntryUtil.getPayloadJSONObject(this._dtoConverterRegistry, this._jsonFactory, "onAfterAttachmentDownload", objectDefinition, objectEntry, null, null, this._userLocalService.getUser(message.getLong("userId"))), message.getLong("userId"));
    }
}

